/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;

public class Comet
extends Sprite {
    public static final int SLOW = 0;
    public static final int MED = 1;
    public static final int FAST = 2;
    static Image[] img = new Image[3];
    Color coll;
    Color cold;
    int points = 0;
    boolean givepoints = true;
    boolean damage = false;
    int type = 0;
    int factor = 0;
    double radius = 0.0;
    double c = 0.0;
    double x = 0.0;
    double y = 0.0;

    public Comet(int x, int y, int width, int height, int typeset, int vx, int vy, int s) {
        this.r = new Rectangle(x, y, width, height);
        this.type = typeset;
        if (this.type <= 0) {
            this.col = Color.gray;
            this.coll = this.col.brighter();
            this.cold = this.col.darker();
            this.points = 100;
            this.velx = vx;
            this.vely = vy;
            this.type = 0;
        } else if (this.type == 1) {
            this.col = Comets.lightblue;
            this.coll = this.col.brighter();
            this.cold = this.col.darker();
            this.points = 200;
            this.velx = vx * 2;
            this.vely = vy * 2;
        } else if (this.type >= 2) {
            this.col = new Color(200, 100, 100);
            this.coll = this.col.brighter();
            this.cold = this.col.darker();
            this.points = 300;
            this.velx = vx * 3;
            this.vely = vy * 3;
            this.type = 2;
        }
        this.strength = s;
        this.radius = this.r.width / 2;
        this.factor = 2 + this.r.width / 15;
        if (Math.sqrt(this.velx * this.velx + this.vely * this.vely) <= this.radius + 5.0) {
            ++this.factor;
        }
        this.preCalc();
    }

    public static void loadImages() throws Exception {
        MediaTracker tracker = new MediaTracker(Comets.esta);
        Comet.img[0] = AppletWrapper.getImage("Media/CometGrey.gif");
        tracker.addImage(img[0], 0);
        Comet.img[1] = AppletWrapper.getImage("Media/CometBlue.gif");
        tracker.addImage(img[1], 1);
        Comet.img[2] = AppletWrapper.getImage("Media/CometRed.gif");
        tracker.addImage(img[2], 2);
        tracker.waitForID(0);
        tracker.waitForID(1);
        tracker.waitForID(2);
        if (img[0] == null || img[1] == null || img[2] == null || tracker.isErrorAny()) {
            throw new Exception("Error loading Comet images");
        }
    }

    void preCalc() {
        this.c = Math.atan((double)this.vely / (double)this.velx);
        this.x = this.radius * Math.sin(this.c);
        this.y = this.radius * Math.cos(this.c);
    }

    public void paint(Graphics g) {
        this.clear(g);
        if (!this.visible) {
            return;
        }
        g.setColor(this.col);
        if (Comets.TAILS) {
            double cx = (double)this.r.x + this.radius;
            double cy = (double)this.r.y + this.radius;
            g.setColor(this.col);
            g.fillPolygon(new int[]{(int)(cx - this.x), (int)(cx - (double)(this.velx * this.factor)), (int)(cx + this.x)}, new int[]{(int)(cy + this.y), (int)(cy - (double)(this.vely * this.factor)), (int)(cy - this.y)}, 3);
        }
        try {
            if (Comets.IMAGES && img[this.type] != null) {
                g.drawImage(img[this.type], this.r.x, this.r.y, this.r.width, this.r.height, null);
            } else {
                g.fillOval(this.r.x, this.r.y, this.r.width, this.r.height);
            }
        }
        catch (Exception e) {
            g.fillOval(this.r.x, this.r.y, this.r.width, this.r.height);
            System.out.println(String.valueOf(String.valueOf(e)));
        }
        int px = 0;
        int py = 0;
        int c = 0;
        while (c < 5) {
            g.setColor(this.coll);
            px = this.r.x + Comets.esta.getRand(1, this.r.width);
            py = this.r.y + Comets.esta.getRand(1, this.r.height);
            g.drawLine(px, py, px, py);
            g.setColor(this.cold);
            px = this.r.x + Comets.esta.getRand(1, this.r.width);
            py = this.r.y + Comets.esta.getRand(1, this.r.height);
            g.drawLine(px, py, px, py);
            ++c;
        }
    }

    public void update() {
        if (!Sprite.active) {
            return;
        }
        this.r.x += this.velx;
        this.r.y += this.vely;
        if (this.r.x < Sprite.cr.x) {
            this.velx = -this.velx;
            this.r.x = Sprite.cr.x;
            this.preCalc();
        } else if (this.r.y < Sprite.cr.y) {
            this.vely = -this.vely;
            this.r.y = Sprite.cr.y;
            this.preCalc();
        } else if (this.r.x + this.r.width > Sprite.cr.x + Sprite.cr.width) {
            this.velx = -this.velx;
            this.r.x = Sprite.cr.x + Sprite.cr.width - this.r.width;
            this.preCalc();
        } else if (this.r.y + this.r.height > Sprite.cr.y + Sprite.cr.height) {
            new Explotion(this.r, this.id, null);
            Comets.esta.life -= 10;
            --Comets.esta.numcoms;
        }
    }

    public void hitTop(Sprite b, boolean mycc) {
        this.vely = -this.vely;
        if (mycc) {
            this.r.y = b.r.y - this.r.height;
        }
        if (b instanceof Avatar) {
            Comets.esta.av.hit(0);
            this.givepoints = false;
            this.hit(Comets.esta.av.strength);
            this.givepoints = true;
            if (Comets.esta.av.sheild == null) {
                Comets.esta.life -= 10;
            }
        } else if (b instanceof PlanetSheild) {
            b.hit(0);
            this.damage = true;
            this.hit(2);
            this.damage = false;
        }
        this.preCalc();
    }

    public void hitLeft(Sprite b, boolean mycc) {
        this.velx = -this.velx;
        if (mycc) {
            this.r.x = b.r.x - this.r.width;
        }
        if (b instanceof Avatar) {
            Comets.esta.av.hit(0);
            this.givepoints = false;
            this.hit(Comets.esta.av.strength);
            this.givepoints = true;
            if (Comets.esta.av.sheild == null) {
                Comets.esta.life -= 10;
            }
        } else if (b instanceof PlanetSheild) {
            b.hit(0);
            this.damage = true;
            this.hit(2);
            this.damage = false;
        }
        this.preCalc();
    }

    public void hitRight(Sprite b, boolean mycc) {
        this.velx = -this.velx;
        if (mycc) {
            this.r.x = b.r.x + b.r.width;
        }
        if (b instanceof Avatar) {
            Comets.esta.av.hit(0);
            this.givepoints = false;
            this.hit(Comets.esta.av.strength);
            this.givepoints = true;
            if (Comets.esta.av.sheild == null) {
                Comets.esta.life -= 10;
            }
        } else if (b instanceof PlanetSheild) {
            b.hit(0);
            this.damage = true;
            this.hit(2);
            this.damage = false;
        }
        this.preCalc();
    }

    public void hitBottom(Sprite b, boolean mycc) {
        this.vely = -this.vely;
        if (mycc) {
            this.r.y = b.r.y + b.r.height;
        }
        if (b instanceof Avatar) {
            Comets.esta.av.hit(0);
            this.givepoints = false;
            this.hit(Comets.esta.av.strength);
            this.givepoints = true;
            if (Comets.esta.av.sheild == null) {
                Comets.esta.life -= 10;
            }
        } else if (b instanceof PlanetSheild) {
            b.hit(0);
            this.damage = true;
            this.hit(2);
            this.damage = false;
        }
        this.preCalc();
    }

    public void hit(int p) {
        this.strength -= p;
        if (this.strength <= 0) {
            --Comets.esta.comsleft;
            --Comets.esta.numcoms;
            if (this.givepoints) {
                Comets.esta.addPoints(this.points);
            }
            new Explotion(this.r, this.id, this.givepoints ? new Message(String.valueOf(this.points), this.r.x, this.r.y, this.damage ? Color.red : Color.blue) : null);
        }
    }

    public String toString() {
        return "Comet strength = " + this.strength + "points = " + this.points;
    }
}

