/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class Bomb
extends Weapon {
    int stx = 0;
    int sty = 0;
    int time = 0;
    boolean exploded = false;

    public Bomb(int x, int y) {
        super(x, y, 10, 10, 0, -8);
        this.stx = x;
        this.sty = y;
        this.power = 2;
        this.time = Comets.esta.getRand(15, 50);
        this.col = new Color(229, 30, 224);
    }

    public Weapon newWeapon(int x, int y, Gun b) {
        Bomb w = new Bomb(x, y);
        w.from = b;
        return w;
    }

    public void update() {
        if (!Sprite.active) {
            return;
        }
        --this.time;
        if (this.time == 0) {
            this.destroySelf();
        } else if (this.time <= -5) {
            Comets.esta.destroy(this.id);
        }
        this.r.x += this.velx;
        this.r.y += this.vely;
        if (this.r.x < Sprite.cr.x) {
            this.velx = -this.velx;
            this.r.x = Sprite.cr.x;
        } else if (this.r.y < Sprite.cr.y) {
            if (!this.from.bounce) {
                Comets.esta.destroy(this.id);
            }
            this.vely = -this.vely;
            this.r.y = Sprite.cr.y;
        } else if (this.r.x + this.r.width > Sprite.cr.x + Sprite.cr.width) {
            this.velx = -this.velx;
            this.r.x = Sprite.cr.x + Sprite.cr.width - this.r.width;
        } else if (this.r.y + this.r.height > Sprite.cr.y + Sprite.cr.height) {
            this.vely = -this.vely;
            this.r.y = Sprite.cr.y + Sprite.cr.height - this.r.height;
        }
    }

    public void paint(Graphics g) {
        if (this.time > 0) {
            g.setColor(this.col);
            g.fillOval(this.r.x, this.r.y, this.r.width, this.r.height);
        }
    }

    public void hit(Sprite s, boolean myReport) {
        if (s instanceof Explotion && this.exploded) {
            return;
        }
        if (s instanceof Avatar) {
            return;
        }
        if (s instanceof PlanetSheild) {
            return;
        }
        if (s instanceof Weapon) {
            if (myReport) {
                ((Weapon)s).hit(this, false);
            }
            if (this.canHitWeapon((Weapon)s)) {
                return;
            }
        }
        s.hit(this.power);
        this.destroySelf();
    }

    public void destroySelf() {
        if (this.exploded) {
            return;
        }
        this.exploded = true;
        this.r = new Rectangle(this.r.x - 60, this.r.y - 60, 120, 120);
        Comets.esta.addSprite(new Explotion(this.r, -1, null));
        this.time = 0;
    }

    public boolean canHitWeapon(Weapon s) {
        return false;
    }
}

