/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;

public class Boss
extends Sprite {
    Message indicator = null;
    static Image img = null;
    static Image imgop = null;
    Color coll = Color.lightGray;
    Color cold = Color.gray;
    int firefreq = 2;
    int dificulty = 1;
    int count = 0;
    boolean open = false;
    byte state = 0;
    static final byte HOVER = 0;
    static final byte OPENING = 1;
    static final byte OPEN = 2;
    static final byte CLOSING = 3;
    static final byte RAMING = 4;
    static final byte RETREAT = 5;

    public Boss() {
        super(100, 100, 80, 60, 5, 0);
        this.strength = Comets.esta.wave * 2;
        this.indicator = new Message("Cloud: " + this.strength, 0, 0, Color.red, -1);
        Comets.esta.addTimer(this.indicator);
        this.dificulty = Comets.esta.wave / 10;
        if (this.dificulty > 5) {
            this.dificulty = 5;
        }
    }

    public static void loadImages() throws Exception {
        img = AppletWrapper.getImage("Media/CloudClosed.gif");
        imgop = AppletWrapper.getImage("Media/CloudOpen.gif");
        MediaTracker tracker = new MediaTracker(Comets.esta);
        tracker.addImage(img, 0);
        tracker.addImage(imgop, 1);
        tracker.waitForID(0);
        tracker.waitForID(1);
        if (img == null || imgop == null || tracker.isErrorAny()) {
            throw new Exception("Error loading Cloud images");
        }
    }

    public void update() {
        if (!Sprite.active) {
            return;
        }
        this.r.x += this.velx;
        this.r.y += this.vely;
        switch (this.state) {
            case 0: {
                double r1 = Math.random();
                if (r1 <= 0.3 - (double)(this.dificulty / 100)) {
                    this.state = 1;
                    this.open = true;
                } else if (r1 >= 0.75 - (double)(this.dificulty / 100)) {
                    this.state = (byte)4;
                }
                if (++this.count < 40 - this.dificulty * 5) break;
                this.count = 0;
                r1 = Math.random();
                if (r1 < 0.5) {
                    this.velx = -this.velx;
                }
                this.vely = (r1 = Math.random()) < 0.33 ? 0 : (r1 < 0.66 ? 5 : -5);
                if (this.r.y > 100) {
                    this.vely = -5;
                    break;
                }
                if (this.r.y >= 30) break;
                this.vely = 0;
                break;
            }
            case 1: {
                if (++this.count < 10 - this.dificulty) break;
                this.state = (byte)2;
                break;
            }
            case 2: {
                double r2 = Math.random();
                if (r2 <= 0.35 + (double)(this.dificulty / 100)) {
                    this.fire();
                } else if (r2 <= 1.0 - (0.006 + 0.016 * (double)(this.dificulty - 1) / 4.0)) {
                    this.state = (byte)3;
                    this.count = 0;
                }
                if (++this.count < 40 - this.dificulty * 5) break;
                this.count = 0;
                r2 = Math.random();
                if (r2 < 0.5) {
                    this.velx = -this.velx;
                }
                this.vely = (r2 = Math.random()) < 0.33 ? 0 : (r2 < 0.66 ? 5 : -5);
                if (this.r.y > 100) {
                    this.vely = -5;
                    break;
                }
                if (this.r.y >= 30) break;
                this.vely = 0;
                break;
            }
            case 3: {
                if (++this.count < 10 - this.dificulty) break;
                this.state = 0;
                this.open = false;
                break;
            }
            case 4: {
                if (++this.count < 10 + this.dificulty * 3) break;
                this.count = 0;
                double r3 = Math.random();
                if (r3 <= 0.33) {
                    this.velx = 5;
                } else if (r3 <= 0.66) {
                    this.velx = -5;
                } else if (r3 > 0.94 + (double)(this.dificulty / 100)) {
                    this.state = (byte)5;
                }
                this.vely = Comets.esta.getRand(2, 5 + this.dificulty);
                break;
            }
            case 5: {
                this.vely = -Comets.esta.getRand(2, 5 + this.dificulty);
                if (this.r.y > 65) break;
                this.state = 0;
                break;
            }
        }
        if (this.r.x < Sprite.cr.x) {
            this.velx = -this.velx;
            this.r.x = Sprite.cr.x;
        } else if (this.r.y < 14) {
            this.vely = -this.vely;
            this.r.y = 14;
        } else if (this.r.x + this.r.width > Sprite.cr.x + Sprite.cr.width) {
            this.velx = -this.velx;
            this.r.x = Sprite.cr.x + Sprite.cr.width - this.r.width;
        } else if (this.r.y + this.r.height > Sprite.cr.y + 150) {
            this.vely = -this.vely;
            this.r.y = Sprite.cr.y + 150 - this.r.height;
        }
    }

    public void paint(Graphics g) {
        if (Comets.IMAGES && img != null) {
            if (this.open) {
                g.drawImage(imgop, this.r.x, this.r.y, this.r.width, this.r.height, null);
            } else {
                g.drawImage(img, this.r.x, this.r.y, this.r.width, this.r.height, null);
            }
        } else {
            g.setColor(Color.white);
            g.fillOval(this.r.x, this.r.y, this.r.width, this.r.height);
            if (this.open) {
                g.setColor(Color.black);
                g.fillOval(this.r.x + 15, this.r.y + 45, 50, 15);
            }
        }
    }

    public void fire() {
        int t = Comets.esta.getRand(0, 20);
        if (t <= 10) {
            Comets.esta.addSprite(new Comet(Comets.esta.getRand(this.r.x, this.r.x + this.r.width), this.r.y + this.r.height + 10, 15, 15, Comets.esta.getRand(0, 3 + Comets.esta.wave / 10), Comets.esta.getRand(-2, 2), Comets.esta.getRand(1, 3 + Comets.esta.wave / 5), 1));
        } else if (t <= 15) {
            Comets.esta.addSprite(new Comet(Comets.esta.getRand(this.r.x, this.r.x + this.r.width), this.r.y + this.r.height + 10, 30, 30, Comets.esta.getRand(0, 3 + Comets.esta.wave / 10), Comets.esta.getRand(-2, 2), Comets.esta.getRand(1, 3 + Comets.esta.wave / 4), 2));
        } else if (t <= 18) {
            Comets.esta.addSprite(new Comet(Comets.esta.getRand(this.r.x, this.r.x + this.r.width), this.r.y + this.r.height + 10, 45, 45, Comets.esta.getRand(1, 3 + Comets.esta.wave / 10), Comets.esta.getRand(-2, 2), Comets.esta.getRand(1, 3 + Comets.esta.wave / 3), 3));
        }
    }

    void cometExplosion() {
        int steps = 3 * this.dificulty;
        int ang = Comets.esta.getRand(-3 * this.dificulty, 10);
        int ang_end = Comets.esta.getRand(170, 180 + 3 * this.dificulty);
        int ang_step = (ang_end - ang) / steps;
        int rd = steps * 8;
        int cx = this.r.x + this.r.width / 2;
        int cy = this.r.y + this.r.height / 2;
        double x = 0.0;
        double y = 0.0;
        int vx = 0;
        int vy = 0;
        int size = 1;
        int cang = 0;
        while (cang < ang_end) {
            x = Math.cos(cang);
            y = Math.sin(cang);
            vx = (int)(x * (double)this.dificulty) + 3;
            vy = (int)(y * (double)this.dificulty) + 3;
            size = Comets.esta.getRand(1, 3);
            Comets.esta.addSprite(new Comet((int)((double)cx + x * (double)rd), (int)((double)cy + y * (double)rd), size * 15, size * 15, Comets.esta.getRand(0, 3 + Comets.esta.wave / 10), vx, vy, size));
            cang += ang_step;
        }
    }

    public void hit(int power) {
        if (!this.open) {
            return;
        }
        this.strength -= power;
        this.indicator.mess = "Cloud: " + this.strength;
        if (++this.firefreq > 1 + this.dificulty) {
            this.firefreq = 1 + this.dificulty;
        }
        if (this.strength <= 0) {
            Comets.esta.destroyTimer(this.indicator.id);
            new Explotion(this.r, this.id, new Message("1000", this.r.x, this.r.y, Color.green));
            Comets.esta.addTimer(new MTimer("Cloud disipating", 100, 25, Color.red, Comets.esta.getRand(1, 8) * 1000, new 1()));
            this.cometExplosion();
        }
    }

    public void hitTop(Sprite b, boolean mycc) {
        this.hit(b);
    }

    public void hitLeft(Sprite b, boolean mycc) {
        this.hit(b);
    }

    public void hitRight(Sprite b, boolean mycc) {
        this.hit(b);
    }

    public void hitBottom(Sprite b, boolean mycc) {
        this.hit(b);
    }

    void hit(Sprite s) {
        if (s instanceof Avatar) {
            Comets.esta.av.hit(this.strength);
            if (Comets.esta.av.sheild == null) {
                Comets.esta.life -= this.strength;
            }
        } else if (s instanceof PlanetSheild) {
            s.hit(this.strength);
            this.state = (byte)5;
        }
    }

    private final class 1
    implements MTimerListener {
        public void timeUp() {
            Comets.esta.bossOver();
        }

        /* synthetic */ 1() {
        }
    }
}

