/*
 * Decompiled with CFR 0.152.
 */
import java.awt.CheckboxMenuItem;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;

public class Tools {
    public static int pixelSize(int inches) {
        int ppi;
        try {
            Toolkit tool = Toolkit.getDefaultToolkit();
            ppi = tool.getScreenResolution();
        }
        catch (Exception exception) {
            ppi = 70;
        }
        return ppi * inches;
    }

    public static Menu makeMenu(Object parent, Object[] items, int[] shortcuts, Object target) {
        Menu m = null;
        if (parent instanceof Menu) {
            m = (Menu)parent;
        } else if (parent instanceof String) {
            m = new Menu((String)parent);
        } else {
            return null;
        }
        int i = 0;
        while (i < items.length) {
            MenuItem mi;
            if (items[i] instanceof String) {
                int sc = shortcuts[i];
                mi = sc != 0 ? new MenuItem((String)items[i], new MenuShortcut(shortcuts[i])) : new MenuItem((String)items[i]);
                if (target instanceof ActionListener) {
                    mi.addActionListener((ActionListener)target);
                }
                m.add(mi);
            } else if (items[i] instanceof CheckboxMenuItem && target instanceof ItemListener) {
                CheckboxMenuItem cmi = (CheckboxMenuItem)items[i];
                cmi.addItemListener((ItemListener)target);
                m.add(cmi);
            } else if (items[i] instanceof MenuItem) {
                mi = (MenuItem)items[i];
                if (target instanceof ActionListener) {
                    mi.addActionListener((ActionListener)target);
                }
                m.add(mi);
            } else if (items[i] == null) {
                m.addSeparator();
            }
            ++i;
        }
        return m;
    }

    public static Dimension getScreenDim() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        return tk.getScreenSize();
    }

    public static void paintString(String s, int x, int y, Graphics g) {
        FontMetrics fm = g.getFontMetrics(g.getFont());
        StringTokenizer st = new StringTokenizer(s, "\n");
        while (st.hasMoreTokens()) {
            g.drawString(st.nextToken(), x, y);
            y += fm.getHeight();
        }
    }

    public static void paintCenteredString(String s, Rectangle bounds, Graphics g) {
        FontMetrics fm = g.getFontMetrics(g.getFont());
        StringTokenizer st = new StringTokenizer(s, "\n");
        int tokens = st.countTokens() - 1;
        int y = bounds.y + (bounds.height - tokens * fm.getHeight()) / 2;
        String token = st.nextToken();
        int x = bounds.x + (bounds.width - fm.stringWidth(token)) / 2;
        int c = 0;
        while (c < tokens) {
            g.drawString(token, x, y);
            y += fm.getHeight();
            token = st.nextToken();
            ++c;
        }
    }
}

