/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class DataList
extends JComponent {
    private Vector elements = new Vector();
    private int len = 0;
    private PieGraph listener = null;

    public DataList(PieGraph pieGraph) {
        this.listener = pieGraph;
        this.setLayout(null);
        this.addElem();
    }

    protected void valueChanged(int n) {
        if (n == this.len - 1 && this.getValue(n) != -1.0) {
            this.addElem();
            this.listener.listSizeChanged();
        }
        this.listener.updateGraph();
    }

    private void addElem() {
        DataRow dataRow = new DataRow(this, this.len++);
        this.elements.add(dataRow);
        this.add(dataRow);
        Dimension dimension = this.getMinimumSize();
        dataRow.setBounds(0, dimension.height * (this.len - 1), dimension.width, dimension.height);
        this.revalidate();
    }

    public Dimension getPreferredSize() {
        if (this.len < 1) {
            return new Dimension(100, 50);
        }
        Dimension dimension = ((DataRow)this.elements.get(0)).getPreferredSize();
        return new Dimension(dimension.width, dimension.height * this.len);
    }

    public Dimension getMinimumSize() {
        if (this.len < 1) {
            return new Dimension(100, 25);
        }
        Dimension dimension = ((DataRow)this.elements.get(0)).getPreferredSize();
        return new Dimension(dimension.width, dimension.height);
    }

    public String getName(int n) {
        return ((DataRow)this.elements.get((int)n)).name;
    }

    public double getValue(int n) {
        return ((DataRow)this.elements.get((int)n)).value;
    }

    public int length() {
        return this.len - 1;
    }

    class DataRow
    extends JPanel
    implements ActionListener,
    FocusListener {
        JLabel indexL = null;
        JTextField nameF = new JTextField("", 10);
        NumberField valueF = new NumberField(true, 6);
        String name = "";
        double value = 0.0;
        int index = 0;
        DataList list;

        public DataRow(DataList dataList2, int n) {
            this.list = dataList2;
            this.index = n;
            this.setLayout(new BorderLayout());
            this.indexL = new JLabel(" " + (this.index + 1) + " ");
            this.indexL.setForeground(Color.black);
            this.indexL.setHorizontalAlignment(4);
            this.indexL.setFont(new Font("Monospace", 0, 12));
            this.add("West", this.indexL);
            this.nameF.addActionListener(this);
            this.nameF.addFocusListener(this);
            this.add("Center", this.nameF);
            this.valueF.setFont(new Font("Monospace", 0, 12));
            this.valueF.setLimitRange(true);
            this.valueF.setMinValue(0.0);
            this.valueF.setMaxValue(-1.0);
            this.valueF.setHorizontalAlignment(4);
            this.valueF.addActionListener(this);
            this.valueF.addFocusListener(this);
            this.add("East", this.valueF);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.update();
        }

        public void focusGained(FocusEvent focusEvent) {
            Object object = focusEvent.getSource();
            if (object instanceof JTextField) {
                ((JTextField)object).selectAll();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            this.update();
        }

        public void update() {
            String string = this.nameF.getText();
            double d = this.valueF.getDoubleValue();
            if (d == this.value && string.equals(this.name)) {
                return;
            }
            this.value = d;
            this.name = string;
            this.list.valueChanged(this.index);
        }
    }
}

