/*
 * Decompiled with CFR 0.152.
 */
import com.apple.mrj.MRJAboutHandler;
import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJQuitHandler;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class PieGraph
extends JFrame
implements MRJAboutHandler,
MRJQuitHandler {
    static final Color[] colors = new Color[]{Color.red.brighter(), Color.cyan, Color.yellow, Color.magenta, Color.green, Color.blue, Color.orange, Color.pink};
    static final int TILT_OFF = 100;
    static final int X_INSET = 20;
    static final int X_EXPLODE_INSET = 80;
    static final int SHADE_OFF = 10;
    double x_Size_Factor = 1.0;
    double y_Size_Factor = 1.0;
    JLabel dispL = new JLabel("");
    Image img = null;
    Graphics imgG = null;
    JCheckBox titleB = new JCheckBox("Title");
    JCheckBox tiltB = new JCheckBox("Tilt");
    JCheckBox shadeB = new JCheckBox("Shade");
    JCheckBox explodeB = new JCheckBox("Explode");
    JCheckBox namesB = new JCheckBox("Names");
    JCheckBox valueB = new JCheckBox("Value");
    JCheckBox percentB = new JCheckBox("Percent");
    JCheckBox totalB = new JCheckBox("Total");
    JRadioButton allB = new JRadioButton("All", true);
    JRadioButton indexB = new JRadioButton("Index", false);
    NumberField indexF = new NumberField(1, 3);
    JTextField titleF = new JTextField("My Pie Graph", 15);
    DataList list = new DataList(this);
    JScrollBar scrollbar = null;
    AboutBox aboutBox = new AboutBox();
    ActionListener updateL = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            PieGraph.this.updateGraph();
        }
    };
    final Frame cheatvar = this;
    ActionListener menuL = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            String string = ((JMenuItem)actionEvent.getSource()).getText();
            if (string.equals("Quit")) {
                System.exit(0);
            } else if (string.equals("Save as JPEG...")) {
                try {
                    FileDialog fileDialog = new FileDialog(PieGraph.this.cheatvar, "Choose Location", 1);
                    ((Component)fileDialog).setVisible(true);
                    String string2 = fileDialog.getDirectory();
                    String string3 = fileDialog.getFile();
                    if (string3 == null || string2 == null) {
                        return;
                    }
                    File file = new File(string2 + string3);
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    BufferedImage bufferedImage = new BufferedImage(400, 400, 1);
                    Graphics graphics = bufferedImage.getGraphics();
                    graphics.setColor(Color.white);
                    graphics.fillRect(0, 0, 400, 400);
                    PieGraph.this.render(graphics, 400, 400);
                    JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)fileOutputStream);
                    jPEGImageEncoder.encode(bufferedImage);
                    fileOutputStream.close();
                    PieGraph.this.showNote("Graph Saved");
                }
                catch (Exception exception) {
                    PieGraph.this.showError("Error saving the Graph as a JPEG");
                }
            } else if (string.equals("Print...")) {
                try {
                    PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(PieGraph.this.cheatvar, PieGraph.this.titleF.getText(), new JobAttributes(), new PageAttributes());
                    if (printJob == null) {
                        return;
                    }
                    System.out.println("Have pj: " + printJob);
                    Dimension dimension = printJob.getPageDimension();
                    System.out.println("a");
                    int n = printJob.getPageResolution();
                    System.out.println("b");
                    Graphics graphics = printJob.getGraphics();
                    System.out.println("Have pg: " + graphics);
                    graphics.translate(50, 50);
                    System.out.println("translated");
                    PieGraph.this.render(graphics, dimension.width - 100, dimension.height - 100);
                    System.out.println("rendered");
                    graphics.dispose();
                    System.out.println("pg disposed");
                    printJob.end();
                    System.out.println("job ended");
                    PieGraph.this.showNote("Printing complete");
                }
                catch (Exception exception) {
                    System.out.println("Error: " + exception);
                }
            }
        }
    };
    ActionListener enableL = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            if (PieGraph.this.explodeB.isSelected()) {
                PieGraph.this.allB.setEnabled(true);
                PieGraph.this.indexB.setEnabled(true);
                if (PieGraph.this.indexB.isSelected()) {
                    PieGraph.this.indexF.setEnabled(true);
                } else {
                    PieGraph.this.indexF.setEnabled(false);
                }
            } else {
                PieGraph.this.allB.setEnabled(true);
                PieGraph.this.indexB.setEnabled(true);
                PieGraph.this.indexF.setEnabled(false);
            }
        }
    };

    public static void main(String[] stringArray) {
        PieGraph pieGraph = new PieGraph();
        ((Component)pieGraph).setBounds(50, 50, 600, 500);
        ((Component)pieGraph).setVisible(true);
        pieGraph.updateGraph();
    }

    public PieGraph() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        this.dispL.setHorizontalAlignment(0);
        this.dispL.setVerticalAlignment(0);
        container.add("Center", this.dispL);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setAlignmentX(0.0f);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        JPanel jPanel2 = new JPanel(new FlowLayout(1));
        jPanel2.add(this.titleB);
        jPanel2.add(this.titleF);
        this.titleB.addActionListener(this.updateL);
        this.titleF.addActionListener(this.updateL);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.add(new JLabel(" # "));
        jPanel4.add(new JLabel("Name                      "));
        jPanel4.add(new JLabel("Value"));
        jPanel3.add("North", jPanel4);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        this.scrollbar = jScrollPane.getVerticalScrollBar();
        jPanel3.add("Center", jScrollPane);
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)this.tiltB, gridBagConstraints);
        this.tiltB.addActionListener(this.updateL);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)this.shadeB, gridBagConstraints);
        this.shadeB.addActionListener(this.updateL);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)this.explodeB, gridBagConstraints);
        this.explodeB.addActionListener(this.updateL);
        this.explodeB.addActionListener(this.enableL);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 25, 5, 5);
        JPanel jPanel5 = new JPanel(new GridLayout(2, 2));
        ButtonGroup buttonGroup = new ButtonGroup();
        jPanel5.add(this.allB);
        buttonGroup.add(this.allB);
        this.allB.addActionListener(this.updateL);
        jPanel5.add(new JLabel());
        jPanel5.add(this.indexB);
        jPanel5.add(this.indexF);
        buttonGroup.add(this.indexB);
        this.indexF.setEnabled(false);
        this.indexF.setLimitRange(true);
        this.indexF.setMinValue(1);
        this.indexF.setMaxValue(1);
        this.indexF.setCharLimit(3);
        this.indexB.addActionListener(this.updateL);
        this.indexF.addActionListener(this.updateL);
        this.indexB.addActionListener(this.enableL);
        this.allB.addActionListener(this.enableL);
        jPanel.add((Component)jPanel5, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)new JLabel("Show:"), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(5, 25, 5, 5);
        JPanel jPanel6 = new JPanel(new GridLayout(4, 1));
        jPanel6.add(this.namesB);
        jPanel6.add(this.valueB);
        jPanel6.add(this.percentB);
        jPanel6.add(this.totalB);
        this.namesB.addActionListener(this.updateL);
        this.valueB.addActionListener(this.updateL);
        this.percentB.addActionListener(this.updateL);
        this.totalB.addActionListener(this.updateL);
        jPanel.add((Component)jPanel6, gridBagConstraints);
        container.add("East", jPanel);
        this.setJMenuBar(this.makeMenuBar());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }

            public void windowResized(WindowEvent windowEvent) {
                PieGraph.this.img = null;
                PieGraph.this.updateGraph();
            }
        });
        Toolkit.getDefaultToolkit();
        MRJApplicationUtils.registerAboutHandler((MRJAboutHandler)this);
        MRJApplicationUtils.registerQuitHandler((MRJQuitHandler)this);
    }

    public void listSizeChanged() {
        this.scrollbar.setValue(this.scrollbar.getMaximum());
        System.out.println("list.length:" + this.list.length());
        this.indexF.setMaxValue(this.list.length());
    }

    protected void updateGraph() {
        Dimension dimension = this.dispL.getSize();
        if (this.img == null) {
            this.img = this.createImage(dimension.width, dimension.height);
            this.imgG = this.img.getGraphics();
            this.x_Size_Factor = dimension.width / 400;
            this.y_Size_Factor = dimension.height / 450;
            System.out.println("WxH:" + dimension.width + "x" + dimension.height);
        }
        this.render(this.imgG, dimension.width, dimension.height);
        this.dispL.setIcon(new ImageIcon(this.img));
    }

    public void render(Graphics graphics, int n, int n2) {
        int n3 = 0;
        Font font = new Font("Dialog", 0, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        Font font2 = new Font("SansSerif", 0, 16);
        FontMetrics fontMetrics2 = graphics.getFontMetrics(font2);
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, n, n2);
        if (this.titleB.isSelected()) {
            graphics.setColor(Color.black);
            graphics.setFont(font2);
            String string = this.titleF.getText();
            graphics.drawString(string, (n - fontMetrics2.stringWidth(string)) / 2, 5 + fontMetrics2.getHeight());
        }
        double d = 0.0;
        n3 = 0;
        while (n3 < this.list.length()) {
            d += this.list.getValue(n3);
            ++n3;
        }
        double d2 = 0.0;
        double d3 = 360.0 / d;
        double d4 = 0.0;
        int n4 = n - (this.explodeB.isSelected() ? 80 : 20);
        if (n2 - 60 < n4) {
            n4 = n2 - 60;
        }
        int n5 = this.tiltB.isSelected() ? n4 - 100 : n4;
        int n6 = (n - n4) / 2;
        int n7 = 25 + (n2 - n5) / 2;
        Point point = new Point();
        boolean bl = this.explodeB.isSelected();
        if (this.shadeB.isSelected()) {
            graphics.setColor(Color.gray);
            n3 = 0;
            while (n3 < this.list.length()) {
                d4 = d3 * this.list.getValue(n3);
                if (bl) {
                    this.doExplode(point, n6, n7 + this.ty(10), d2, d2 + d4, n3);
                } else {
                    point.x = n6;
                    point.y = n7 + this.ty(10);
                }
                graphics.fillArc(point.x, point.y, n4, n5, (int)(d2 + 0.5), (int)(d4 + 0.5));
                d2 += d4;
                ++n3;
            }
            d2 = 0.0;
        }
        n3 = 0;
        while (n3 < this.list.length()) {
            d4 = d3 * this.list.getValue(n3);
            if (bl) {
                this.doExplode(point, n6, n7, d2, d2 + d4, n3);
            } else {
                point.x = n6;
                point.y = n7;
            }
            graphics.setColor(colors[n3 % colors.length]);
            graphics.fillArc(point.x, point.y, n4, n5, (int)(d2 + 0.5), (int)(d4 + 0.5));
            d2 += d4;
            ++n3;
        }
        graphics.setFont(font);
        graphics.setColor(Color.black);
        DecimalFormat decimalFormat = new DecimalFormat("##0.##");
        d2 = 0.0;
        double d5 = 0.0;
        String string = "";
        double d6 = 0.0;
        boolean bl2 = false;
        n3 = 0;
        while (n3 < this.list.length()) {
            d6 = this.list.getValue(n3);
            d4 = d3 * d6;
            if (this.namesB.isSelected()) {
                string = this.list.getName(n3);
                bl2 = true;
            } else {
                string = "";
                bl2 = false;
            }
            if (this.valueB.isSelected()) {
                if (bl2) {
                    string = string + ": ";
                }
                string = string + PieGraph.format(d6);
                bl2 = true;
            }
            if (this.percentB.isSelected()) {
                if (bl2) {
                    string = string + ": ";
                }
                string = string + " " + decimalFormat.format(d6 / d * 100.0) + "%";
            }
            d5 = (d2 + d2 + d4) / 2.0;
            point.y = (int)((double)(n7 + n5 / 2) - (double)n4 / 3.5 * Math.sin(Math.toRadians(d5)));
            point.x = (int)((double)(n6 + n4 / 2) + (double)n4 / 3.5 * Math.cos(Math.toRadians(d5)));
            if (bl) {
                this.doExplode(point, point.x, point.y, d2, d2 + d4, n3);
            }
            point.x -= fontMetrics.stringWidth(string) / 2;
            graphics.drawString(string, point.x, point.y);
            d2 += d4;
            ++n3;
        }
        if (this.totalB.isSelected()) {
            graphics.drawString("Total: " + PieGraph.format(d), n / 2, 5 + fontMetrics2.getHeight() * 2);
        }
    }

    void doExplode(Point point, int n, int n2, double d, double d2, int n3) {
        if (this.indexB.isSelected() && n3 + 1 != this.indexF.getIntValue()) {
            point.x = n;
            point.y = n2;
            return;
        }
        double d3 = (d + d2) / 2.0;
        point.y = (int)((double)n2 - 30.0 * Math.sin(Math.toRadians(d3)));
        point.x = (int)((double)n + 30.0 * Math.cos(Math.toRadians(d3)));
    }

    public int tx(int n) {
        return n;
    }

    public int ty(int n) {
        return n;
    }

    private JMenuBar makeMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("Save as JPEG...", 83);
        jMenuItem.addActionListener(this.menuL);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Print...", 80);
        jMenuItem.addActionListener(this.menuL);
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Quit", 81);
        jMenuItem.addActionListener(this.menuL);
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        return jMenuBar;
    }

    private void showNote(String string) {
        JOptionPane.showMessageDialog(null, string, "Notice", 1);
    }

    private void showError(String string) {
        JOptionPane.showMessageDialog(null, string, "Notice", 0);
    }

    public static String format(double d) {
        if (d != (double)((int)d)) {
            return "" + d;
        }
        return "" + (int)d;
    }

    public void handleAbout() {
        this.aboutBox.setResizable(false);
        ((Component)this.aboutBox).setVisible(true);
        this.aboutBox.show();
    }

    public void handleQuit() {
        System.exit(0);
    }
}

