/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;

public class MathCanvas
extends Panel {
    Main parent;
    boolean menu = true;
    boolean menu2 = false;
    boolean answered = false;
    boolean retry = false;
    boolean random = false;
    boolean stats = false;
    int focus = 2;
    int prob = 1;
    int num1 = 2;
    int num2 = 1;
    String message = "";
    int problem = 0;
    int correct = 0;
    int wrong = 0;
    int[][] stat;
    int max_q = 0;
    boolean solid = true;
    int try_num = 1;
    long start = 0L;
    String[] try_mess = new String[]{"Ooooooo, try again!", "No, let's try again.", "Oops!", "You'll get it, try again!"};
    String[] cor_mess = new String[]{"Correct!", "That's it!", "You got it!", "You're doing great!"};

    public MathCanvas(Main m) {
        this.parent = m;
        this.setBackground(Color.black);
        this.stat = new int[11][3];
        this.repaint();
    }

    public synchronized void paint(Graphics g) {
        g.setColor(Color.green);
        if (this.menu) {
            if (this.menu2) {
                g.drawString("Type number of questions", 10, 50);
                g.drawString(this.parent.input, 50, 75);
            } else {
                g.drawString("Type number to focus on", 10, 50);
                g.drawString(this.parent.input, 50, 75);
            }
        } else if (this.answered) {
            g.drawString(this.message, 10, 50);
            g.drawString("Questions: " + this.problem, 10, 80);
            g.drawString("Correct: " + this.correct, 10, 100);
            g.drawString("Wrong: " + this.wrong, 10, 120);
        } else if (this.stats) {
            int pc = (int)((double)((float)this.correct / (float)this.problem * 100.0f) + 0.5);
            int pw = (int)((double)((float)this.wrong / (float)this.problem * 100.0f) + 0.5);
            g.drawString("Questions: " + this.problem, 10, 20);
            g.drawString("Correct: " + this.correct + "       " + pc + " %", 10, 40);
            g.drawString("Wrong: " + this.wrong + "       " + pw + " %", 10, 60);
            g.drawString("Number: ", 10, 80);
            g.drawString("Shown: ", 10, 100);
            g.drawString("Trys: ", 10, 120);
            g.drawString("Rating: ", 10, 140);
            int sum = 0;
            int n = 0;
            while (n < 11) {
                g.drawString(String.valueOf(n), 80 + n * 20, 80);
                g.drawString(String.valueOf(this.stat[n][0]), 80 + n * 20, 100);
                g.drawString(String.valueOf(this.stat[n][1]), 80 + n * 20, 120);
                g.drawString(this.getRate(this.stat[n][2]), 80 + n * 20, 140);
                sum += this.stat[n][2];
                ++n;
            }
            g.drawString("Overal: " + this.getRate((int)((double)(sum / 10) + 0.5)), 10, 160);
        } else {
            g.setFont(new Font("Geneva", 0, 18));
            g.drawString(String.valueOf(this.num1), 130, 40);
            g.drawString("x " + this.num2, 115, 70);
            g.drawLine(100, 85, 170, 85);
            g.drawString("?", 130, 100);
            g.drawString(this.parent.input, 125, 135);
        }
    }

    String getRate(int num) {
        switch (num) {
            case 1: {
                return "++";
            }
            case 2: {
                return "+";
            }
            case 3: {
                return "~+";
            }
            case 4: {
                return "~";
            }
            case 5: {
                return "~-";
            }
            case 6: {
                return "-";
            }
        }
        return "x";
    }

    public void setFocus(int f) {
        this.focus = f;
    }

    public void setMax(int m) {
        if (m > 0) {
            this.max_q = m;
        } else {
            this.max_q = -m;
            this.solid = false;
        }
    }

    public synchronized void changeProblem() {
        if (this.solid && this.problem >= this.max_q || !this.solid && this.correct >= this.max_q) {
            this.end();
            return;
        }
        if (this.random) {
            this.focus = this.getRand(0, 11);
            if (this.focus == 11) {
                this.focus = 10;
            }
        }
        int[] most = new int[11];
        int mnext = 0;
        int[] mid = new int[11];
        int dnext = 0;
        int[] least = new int[11];
        int lnext = 0;
        int c = 0;
        while (c < 11) {
            most[c] = -1;
            mid[c] = -1;
            least[c] = -1;
            ++c;
        }
        int max = 0;
        int min = 999;
        int z = 0;
        while (z < 11) {
            if (this.stat[z][0] > max && z != this.prob) {
                max = this.stat[z][0];
            }
            if (this.stat[z][0] < min && z != this.prob) {
                min = this.stat[z][0];
            }
            ++z;
        }
        if (max != min) {
            int x = 0;
            while (x < 11) {
                if (this.stat[x][0] == max && x != this.prob) {
                    least[lnext++] = x;
                } else if (this.stat[x][0] == min && x != this.prob) {
                    most[mnext++] = x;
                } else if (x != this.prob) {
                    mid[dnext++] = x;
                }
                ++x;
            }
        } else {
            int y = 0;
            while (y < 11) {
                most[y] = y;
                ++y;
            }
            mnext = 11;
        }
        int r = this.getRand(1, 10);
        if (r > 4 && mnext > 0 || min == max || r > 1 && dnext == 0) {
            int r2 = this.getRand(0, mnext - 1);
            this.prob = most[r2];
        } else if (r > 1 && dnext > 0) {
            int r2 = this.getRand(0, dnext - 1);
            this.prob = mid[r2];
        } else {
            int r2 = this.getRand(0, lnext - 1);
            this.prob = least[r2];
        }
        if (r == 1) {
            this.num1 = this.prob;
            this.num2 = this.focus;
        } else {
            this.num2 = this.prob;
            this.num1 = this.focus;
        }
        ++this.problem;
        int[] nArray = this.stat[this.prob];
        nArray[0] = nArray[0] + 1;
        this.retry = false;
        this.try_num = 1;
        this.repaint();
        this.start = System.currentTimeMillis();
    }

    public void answered(int num) {
        if (this.answered) {
            return;
        }
        this.answered = true;
        long atime = System.currentTimeMillis() - this.start;
        this.start = 0L;
        int[] nArray = this.stat[this.prob];
        nArray[1] = nArray[1] + 1;
        int r = this.getRand(0, 4);
        if (r == 4) {
            r = 3;
        }
        if (this.num1 * this.num2 == num) {
            this.message = this.cor_mess[r];
            if (!this.retry) {
                ++this.correct;
            }
            this.retry = false;
            int rate = 0;
            rate = this.try_num == 1 ? (atime <= 1300L ? 1 : (atime <= 3000L ? 2 : (atime <= 5000L ? 3 : 4))) : (this.try_num == 2 ? 5 : 6);
            this.stat[this.prob][2] = this.stat[this.prob][2] == 0 ? rate : (this.stat[this.prob][2] * this.stat[this.prob][0] + rate) / (this.stat[this.prob][0] + 1);
        } else {
            this.message = this.try_mess[r];
            if (!this.retry) {
                ++this.wrong;
            }
            this.retry = true;
            ++this.try_num;
        }
        Thread time = new Thread(new 1());
        this.repaint();
        time.start();
    }

    public void end() {
        this.random = false;
        this.retry = false;
        this.answered = false;
        this.stats = true;
        this.solid = true;
        this.parent.end_rand.setLabel("Done");
        this.repaint();
    }

    public void clearStat() {
        this.stat = new int[11][3];
        this.problem = 0;
        this.correct = 0;
        this.wrong = 0;
        this.try_num = 1;
        this.start = 0L;
    }

    public int getRand(int s, int e) {
        return (int)(Math.random() * (double)(e - s) + (double)s);
    }

    private final class 1
    implements Runnable {
        public void run() {
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {}
            MathCanvas.this.answered = false;
            if (!MathCanvas.this.retry) {
                MathCanvas.this.changeProblem();
            }
            MathCanvas.this.repaint();
        }

        /* synthetic */ 1() {
        }
    }
}

