/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.applet.AudioClip;
import java.awt.Button;
import java.awt.Component;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;

public class MoonApplet
extends Applet {
    static MoonApplet applet = null;
    static boolean appRunning = false;
    static MediaTracker mt = null;
    static int nextID = 0;
    static Hashtable sounds = new Hashtable();
    static boolean soundsEnabled = true;

    public void init() {
        applet = this;
        appRunning = true;
        MoonBattle.main(new String[]{"--applet"});
        this.add(new Label("MoonBattle Applet Launcher"));
        Button b = new Button("Reload");
        b.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MoonApplet.reload();
            }
        });
        this.add(b);
    }

    public static void reload() {
        if (applet != null && !appRunning) {
            MoonBattle.main(new String[]{"--applet"});
            appRunning = true;
        }
    }

    public static void quit() {
        appRunning = false;
        if (applet == null) {
            System.exit(0);
        }
    }

    public static void startLoad(Component t) {
        mt = new MediaTracker(t);
    }

    public static Image loadImage(String path) {
        Image i = null;
        i = applet == null ? Toolkit.getDefaultToolkit().getImage(path) : applet.getImage(applet.getCodeBase(), path);
        mt.addImage(i, nextID++);
        return i;
    }

    public static boolean finishLoad() {
        if (mt == null) {
            return false;
        }
        try {
            mt.waitForAll();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return !mt.isErrorAny();
    }

    public static boolean addSound(Object key, String path) {
        AudioClip clip = null;
        URL url = null;
        try {
            if (applet == null) {
                File f = new File(path);
                url = f.toURL();
            } else {
                url = new URL(applet.getCodeBase(), path);
            }
            clip = Applet.newAudioClip(url);
        }
        catch (MalformedURLException mue) {
            System.out.println("Malformed URL error while loading snd:" + path);
        }
        if (clip == null) {
            return false;
        }
        sounds.put(key, clip);
        return true;
    }

    public static void playSound(Object key) {
        if (!soundsEnabled) {
            return;
        }
        AudioClip clip = (AudioClip)sounds.get(key);
        if (clip != null) {
            clip.play();
        }
    }

    public static void stopSound(Object key) {
        AudioClip clip = (AudioClip)sounds.get(key);
        if (clip != null) {
            clip.stop();
        }
    }

    public static void loopSound(Object key) {
        if (!soundsEnabled) {
            return;
        }
        AudioClip clip = (AudioClip)sounds.get(key);
        if (clip != null) {
            clip.loop();
        }
    }
}

