/*
 * Decompiled with CFR 0.152.
 */
import com.apple.mrj.MRJAboutHandler;
import com.apple.mrj.MRJApplicationUtils;
import com.apple.mrj.MRJQuitHandler;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.Vector;

public class MoonBattle
extends Frame
implements KeyListener,
MRJAboutHandler,
MRJQuitHandler,
Runnable {
    protected AboutBox aboutBox = new AboutBox();
    int players = 2;
    protected Vector sprites = new Vector();
    protected Stars stars = new Stars(100);
    protected Moon moon = new Moon(0, 300, 700, 200);
    protected Thread anim = null;
    protected boolean running = false;
    protected boolean pause = false;
    protected BufferedImage buffer = null;
    public static MoonBattle envi = null;
    static int fuel1 = -1;
    static int fuel2 = -1;
    static int fuel3 = -1;
    static int damage1 = -1;
    static int damage2 = -1;
    static int damage3 = -1;

    public static void main(String[] args) {
        MoonBattle b = new MoonBattle();
        ((Component)b).setBounds(5, 5, 700, 500);
        ((Component)b).setVisible(true);
        envi = b;
    }

    public MoonBattle() {
        MRJApplicationUtils.registerAboutHandler(this);
        MRJApplicationUtils.registerQuitHandler(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent we) {
                MoonBattle.this.handleQuit();
            }

            public void windowActivated(WindowEvent we) {
                MoonBattle.this.resumeAnim();
            }

            public void windowDeactivated(WindowEvent we) {
                MoonBattle.this.pauseAnim();
            }
        });
        this.addKeyListener(this);
        MoonApplet.startLoad(this);
        Player.img1 = MoonApplet.loadImage("Data/Images/ship1.png");
        Player.img2 = MoonApplet.loadImage("Data/Images/ship2.png");
        Player.img3 = MoonApplet.loadImage("Data/Images/ship3.png");
        Plasma.img = MoonApplet.loadImage("Data/Images/plasma.png");
        PowerUp.healthImg = MoonApplet.loadImage("Data/Images/health.png");
        PowerUp.fuelImg = MoonApplet.loadImage("Data/Images/fuel.png");
        if (!MoonApplet.finishLoad()) {
            Sprite.IMAGES = false;
        }
        MoonApplet.addSound("laser", "Data/Sounds/laser.au");
        MoonApplet.addSound("plasma", "Data/Sounds/plasma.au");
        MoonApplet.addSound("powerup", "Data/Sounds/powerup.au");
        MoonApplet.addSound("crash", "Data/Sounds/crash.au");
        MoonApplet.addSound("hit", "Data/Sounds/hit.au");
        MoonApplet.addSound("thrust", "Data/Sounds/thrust.au");
        MoonApplet.addSound("nofuel", "Data/Sounds/nofuel.au");
        MoonApplet.addSound("explode", "Data/Sounds/explode.au");
    }

    public void handleAbout() {
        this.aboutBox.setResizable(false);
        ((Component)this.aboutBox).setVisible(true);
        this.aboutBox.show();
    }

    public void handleQuit() {
        this.dispose();
        MoonApplet.quit();
    }

    public void keyPressed(KeyEvent ke) {
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyTyped(KeyEvent ke) {
        char c = ke.getKeyChar();
        if (!this.running) {
            if (c == 'p' || c == 'P') {
                this.newGame();
            } else if (c == 'q' || c == 'Q') {
                this.handleQuit();
            } else if (c == '2') {
                this.players = 2;
                this.repaint();
            } else if (c == '3') {
                this.players = 3;
                this.repaint();
            } else if (c == 's' || c == 'S') {
                MoonApplet.soundsEnabled = !MoonApplet.soundsEnabled;
                MoonApplet.playSound("laser");
            }
        } else if (c == 'p' || c == 'P') {
            this.togglePause();
        } else if (c == 'g' || c == 'G') {
            this.endGame();
        }
    }

    public void startAnim() {
        if (this.anim == null) {
            this.anim = new Thread(this);
            this.anim.start();
        }
    }

    public void pauseAnim() {
        if (this.anim != null) {
            this.pause = true;
            this.anim.suspend();
            this.repaint();
        }
    }

    public void resumeAnim() {
        if (this.anim != null) {
            this.pause = false;
            this.anim.resume();
            this.repaint();
        }
    }

    public void togglePause() {
        if (this.anim != null) {
            if (this.pause) {
                this.pause = false;
                this.anim.resume();
            } else {
                this.pause = true;
                this.anim.suspend();
            }
            this.repaint();
        }
    }

    public void newGame() {
        this.buffer = null;
        this.sprites.add(new Player(1));
        this.sprites.add(new Player(2));
        if (this.players == 3) {
            this.sprites.add(new Player(3));
        }
        this.pause = false;
        this.running = true;
        this.startAnim();
    }

    public void endGame() {
        this.running = false;
        if (this.anim == null) {
            return;
        }
        if (this.pause) {
            this.anim.resume();
        }
        this.pause = false;
        this.sprites.removeAllElements();
        this.repaint();
    }

    public void winGame() {
        this.repaint();
        try {
            Thread.sleep(3000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        Enumeration e = this.sprites.elements();
        Sprite s = null;
        while (e.hasMoreElements()) {
            s = (Sprite)e.nextElement();
            if (!(s instanceof Player)) continue;
            s.die();
        }
        this.endGame();
    }

    public void run() {
        while (this.running) {
            this.updateGame();
            this.repaint();
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.anim = null;
    }

    public void update(Graphics g) {
        if (this.buffer == null) {
            Dimension d = this.getSize();
            Insets in = this.getInsets();
            this.buffer = new BufferedImage(d.width, d.height, 1);
            Sprite.field = new Rectangle(in.left, in.top, d.width - in.left - in.right, d.height - in.top - in.bottom);
            this.moon = new Moon(Sprite.field.x, Sprite.field.height - 200 + Sprite.field.y, Sprite.field.width, 200);
        }
        this.paint(this.buffer.getGraphics());
        g.drawImage(this.buffer, 0, 0, this);
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(Color.black);
        g.fillRect(0, 0, d.width, d.height);
        this.stars.paint(g);
        this.moon.paint(g);
        Enumeration e = this.sprites.elements();
        Sprite s = null;
        while (e.hasMoreElements()) {
            s = (Sprite)e.nextElement();
            s.paint(g);
        }
        FontMetrics fm = null;
        Insets in = this.getInsets();
        int x = in.left + 10;
        int y = in.top + 10;
        if (this.running) {
            g.setFont(new Font("DialogInput", 0, 14));
            fm = g.getFontMetrics();
            int yy = y + fm.getHeight();
            int yy2 = yy + fm.getHeight() + 10;
            int xo = fm.stringWidth("Health:") + 10;
            if (fuel1 != -1) {
                g.setColor(Color.blue);
                g.drawString("Fuel:", x, yy);
                g.drawString("Health:", x, yy2);
                g.fillRect(x + xo, y, fuel1, fm.getHeight());
                g.fillRect(x + xo, yy + 10, damage1, fm.getHeight());
                g.setColor(Color.yellow);
                g.drawRect(x + xo, y, 100, fm.getHeight());
                g.drawRect(x + xo, yy + 10, 100, fm.getHeight());
            }
            if (fuel2 != -1) {
                x = d.width / 3;
                g.setColor(Color.green);
                g.drawString("Fuel:", x, yy);
                g.drawString("Health:", x, yy2);
                g.fillRect(x + xo, y, fuel2, fm.getHeight());
                g.fillRect(x + xo, yy + 10, damage2, fm.getHeight());
                g.setColor(Color.yellow);
                g.drawRect(x + xo, y, 100, fm.getHeight());
                g.drawRect(x + xo, yy + 10, 100, fm.getHeight());
            }
            if (fuel3 != -1) {
                x = d.width / 3 * 2;
                g.setColor(Color.red);
                g.drawString("Fuel:", x, yy);
                g.drawString("Health:", x, yy2);
                g.fillRect(x + xo, y, fuel3, fm.getHeight());
                g.fillRect(x + xo, yy + 10, damage3, fm.getHeight());
                g.setColor(Color.yellow);
                g.drawRect(x + xo, y, 100, fm.getHeight());
                g.drawRect(x + xo, yy + 10, 100, fm.getHeight());
            }
            if (this.pause) {
                g.setFont(new Font("SansSerif", 0, 24));
                fm = g.getFontMetrics();
                String mm = "Paused";
                g.setColor(Color.yellow);
                g.drawString(mm, (d.width - fm.stringWidth(mm)) / 2, d.height / 2);
            }
        } else {
            g.setFont(new Font("SansSerif", 0, 24));
            fm = g.getFontMetrics();
            String m = "Press P to play, Q to quit";
            g.setColor(Color.green);
            g.drawString(m, (d.width - fm.stringWidth(m)) / 2, d.height / 2);
            m = "" + this.players + " Players";
            g.drawString(m, (d.width - fm.stringWidth(m)) / 2, d.height / 2 + fm.getHeight());
        }
    }

    public void updateGame() {
        this.stars.update();
        Enumeration e = this.sprites.elements();
        Sprite s = null;
        while (e.hasMoreElements()) {
            s = (Sprite)e.nextElement();
            s.update();
        }
        int num = 0;
        if (damage1 > 0) {
            ++num;
        }
        if (damage2 > 0) {
            ++num;
        }
        if (damage3 > 0) {
            ++num;
        }
        if (num <= 1) {
            this.winGame();
        }
        e = this.sprites.elements();
        s = null;
        block1: while (e.hasMoreElements()) {
            s = (Sprite)e.nextElement();
            if (this.moon.crash(s) && s.crash()) continue;
            Enumeration e2 = this.sprites.elements();
            Sprite s2 = null;
            while (e2.hasMoreElements() && s2 != s) {
                s2 = (Sprite)e2.nextElement();
            }
            while (e2.hasMoreElements()) {
                s2 = (Sprite)e2.nextElement();
                if (!s2.bounds.intersects(s.bounds)) continue;
                s2.hit(s);
                if (s.hit(s2)) continue block1;
            }
        }
        if (Math.random() > 0.98) {
            this.sprites.add(new PowerUp((int)(Math.random() * (double)Sprite.field.width + (double)Sprite.field.x), (int)(Math.random() * (double)Sprite.field.height / 3.0 + (double)Sprite.field.y), (int)(Math.random() * 20.0 - 10.0), (int)(Math.random() * 16.0 - 8.0)));
        }
    }
}

