/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class Player
extends Sprite
implements KeyListener {
    public static final int NONE = 0;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    static Image img1 = null;
    static Image img2 = null;
    static Image img3 = null;
    static double gravity = 0.1;
    int player;
    double x = 0.0;
    double y = 0.0;
    double velx = 0.0;
    double vely = -10.0;
    double accelx = 0.0;
    double accely = 0.0;
    double side = 0.75;
    double thrust = 0.7;
    boolean plasma = false;
    double fuel = 100.0;
    int health = 100;
    Image img = null;
    int fire = 0;
    int firerate = 0;
    int plasmahit = 0;

    public Player(int n) {
        super((n - 1) * Sprite.field.width / 4 + Sprite.field.width / 8, Sprite.field.height / 3, 40, 40);
        this.x = this.bounds.x;
        this.y = this.bounds.y;
        this.player = n;
        MoonBattle.envi.addKeyListener(this);
        this.updateStats();
        if (this.player == 1 && img1 != null) {
            this.img = img1;
        } else if (this.player == 2 && img2 != null) {
            this.img = img2;
        } else if (this.player == 3 && img3 != null) {
            this.img = img3;
        }
    }

    public void paint(Graphics g) {
        if (this.player == 1) {
            g.setColor(Color.blue);
        } else if (this.player == 2) {
            g.setColor(Color.green);
        } else {
            g.setColor(Color.red);
        }
        if (this.img != null && Sprite.IMAGES) {
            g.drawImage(this.img, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, MoonBattle.envi);
        } else {
            g.fillArc(this.bounds.x + 5, this.bounds.y, this.bounds.width - 10, this.bounds.height * 4 / 3, 0, 180);
            g.fillRect(this.bounds.x, this.bounds.y + this.bounds.height / 3 * 2, this.bounds.width, this.bounds.height / 3);
        }
        g.setColor(Color.red);
        if (this.accely != 0.0 && this.fuel > 0.0) {
            g.fillRect(this.bounds.x + 10, this.bounds.y + this.bounds.height, 20, 5);
        }
        if (this.accelx > 0.0) {
            g.fillRect(this.bounds.x - 5, this.bounds.y + this.bounds.height / 3 * 2, 5, this.bounds.height / 3);
        } else if (this.accelx < 0.0) {
            g.fillRect(this.bounds.x + this.bounds.width, this.bounds.y + this.bounds.height / 3 * 2, 5, this.bounds.height / 3);
        }
    }

    public void update() {
        if (this.velx > 5.0 && this.accelx > 0.0 || this.velx < -5.0 && this.accelx < 0.0) {
            this.accelx = 0.0;
        }
        this.velx += this.accelx;
        this.vely += gravity;
        if (this.accely != 0.0 && this.fuel > 0.0) {
            this.fuel -= 0.1;
            this.vely += this.accely;
            this.updateStats();
        }
        this.x += this.velx;
        this.y += this.vely;
        this.bounds.x = (int)this.x;
        this.bounds.y = (int)this.y;
        if (this.bounds.x + this.bounds.width < Sprite.field.x) {
            this.x = Sprite.field.x + Sprite.field.width;
            this.bounds.x = (int)this.x;
        } else if (this.bounds.x > Sprite.field.x + Sprite.field.width) {
            this.x = Sprite.field.x - this.bounds.width;
            this.bounds.x = (int)this.x;
        }
        if (this.bounds.y < Sprite.field.y) {
            this.y = Sprite.field.y + 1;
            this.bounds.y = (int)this.y;
            this.vely = 0.0;
        } else if (this.bounds.y > Sprite.field.y + Sprite.field.height) {
            System.out.println("Player " + this.player + " too low: " + this.health);
            this.die();
        }
        --this.plasmahit;
        if (this.firerate-- <= 0) {
            if (this.fire == 1) {
                this.fireLeft();
            } else if (this.fire == 2) {
                this.fireRight();
            }
        }
    }

    public boolean hit(Sprite s) {
        boolean safe = false;
        if (s instanceof Laser) {
            this.health -= 5;
            MoonApplet.playSound("hit");
        } else if (s instanceof Plasma && this.plasmahit < 0) {
            this.health -= ((Plasma)s).power;
            safe = true;
            this.plasmahit = 100;
            MoonApplet.playSound("hit");
        } else if (!(s instanceof Player) && s instanceof PowerUp) {
            PowerUp p = (PowerUp)s;
            if (!p.mode) {
                this.fuel += (double)p.amount;
            } else {
                this.health += p.amount;
            }
            MoonApplet.playSound("powerup");
        }
        if (this.health > 100) {
            this.health = 100;
        }
        if (this.fuel > 100.0) {
            this.fuel = 100.0;
        }
        if (this.health <= 0) {
            MoonApplet.playSound("explode");
            this.die();
            return true;
        }
        this.updateStats();
        return safe;
    }

    public boolean crash() {
        if (this.vely > 0.0) {
            this.health -= 25;
        }
        this.vely = -5.0;
        this.updateStats();
        MoonApplet.playSound("crash");
        if (this.health <= 0) {
            MoonApplet.playSound("explode");
            this.die();
            return true;
        }
        return false;
    }

    public void die() {
        MoonBattle.envi.removeKeyListener(this);
        this.health = -1;
        this.fuel = -1.0;
        this.updateStats();
        super.die();
    }

    public void fireLeft() {
        this.firerate = 4;
        if (this.plasma) {
            if (this.fuel > 20.0) {
                this.fuel -= 20.0;
                this.updateStats();
                MoonBattle.envi.sprites.add(new Plasma(this.bounds.x, this.bounds.y + 15, -8));
                MoonApplet.playSound("plasma");
            }
        } else {
            MoonBattle.envi.sprites.add(new Laser(this.bounds.x, this.bounds.y + 19, -15));
            MoonApplet.playSound("laser");
        }
    }

    public void fireRight() {
        this.firerate = 4;
        if (this.plasma) {
            if (this.fuel > 20.0) {
                this.fuel -= 20.0;
                this.updateStats();
                MoonBattle.envi.sprites.add(new Plasma(this.bounds.x + this.bounds.width, this.bounds.y + 15, 8));
                MoonApplet.playSound("plasma");
            }
        } else {
            MoonBattle.envi.sprites.add(new Laser(this.bounds.x + this.bounds.width, this.bounds.y + 19, 15));
            MoonApplet.playSound("laser");
        }
    }

    public void updateStats() {
        if (this.player == 1) {
            MoonBattle.fuel1 = (int)this.fuel;
            MoonBattle.damage1 = this.health;
        } else if (this.player == 2) {
            MoonBattle.fuel2 = (int)this.fuel;
            MoonBattle.damage2 = this.health;
        } else if (this.player == 3) {
            MoonBattle.fuel3 = (int)this.fuel;
            MoonBattle.damage3 = this.health;
        }
    }

    public void keyPressed(KeyEvent ke) {
        int key = ke.getKeyCode();
        if (this.player == 1) {
            if (key == 65) {
                this.accelx = -this.side;
            } else if (key == 68) {
                this.accelx = this.side;
            } else if (key == 83) {
                if (this.accely == 0.0) {
                    if (this.fuel > 0.0) {
                        MoonApplet.playSound("thrust");
                    } else {
                        MoonApplet.playSound("nofuel");
                    }
                }
                this.accely = -this.thrust;
            } else if (key == 81) {
                this.fire = 1;
            } else if (key == 69) {
                this.fire = 2;
            } else if (key == 87) {
                this.plasma = true;
            }
        } else if (this.player == 2) {
            if (key == 100) {
                this.accelx = -this.side;
            } else if (key == 102) {
                this.accelx = this.side;
            } else if (key == 101) {
                if (this.accely == 0.0) {
                    if (this.fuel > 0.0) {
                        MoonApplet.playSound("thrust");
                    } else {
                        MoonApplet.playSound("nofuel");
                    }
                }
                this.accely = -this.thrust;
            } else if (key == 103) {
                this.fire = 1;
            } else if (key == 105) {
                this.fire = 2;
            } else if (key == 104) {
                this.plasma = true;
            }
        } else if (this.player == 3) {
            if (key == 74) {
                this.accelx = -this.side;
            } else if (key == 76) {
                this.accelx = this.side;
            } else if (key == 75) {
                if (this.accely == 0.0) {
                    if (this.fuel > 0.0) {
                        MoonApplet.playSound("thrust");
                    } else {
                        MoonApplet.playSound("nofuel");
                    }
                }
                this.accely = -this.thrust;
            } else if (key == 85) {
                this.fire = 1;
            } else if (key == 79) {
                this.fire = 2;
            } else if (key == 73) {
                this.plasma = true;
            }
        }
    }

    public void keyReleased(KeyEvent ke) {
        int key = ke.getKeyCode();
        if (this.player == 1) {
            if (key == 65) {
                if (this.accelx < 0.0) {
                    this.accelx = 0.0;
                }
            } else if (key == 68) {
                if (this.accelx > 0.0) {
                    this.accelx = 0.0;
                }
            } else if (key == 83) {
                this.accely = 0.0;
            } else if (key == 81) {
                this.fire = 0;
            } else if (key == 69) {
                this.fire = 0;
            } else if (key == 87) {
                this.plasma = false;
            }
        } else if (this.player == 2) {
            if (key == 100) {
                if (this.accelx < 0.0) {
                    this.accelx = 0.0;
                }
            } else if (key == 102) {
                if (this.accelx > 0.0) {
                    this.accelx = 0.0;
                }
            } else if (key == 101) {
                this.accely = 0.0;
            } else if (key == 103) {
                this.fire = 0;
            } else if (key == 105) {
                this.fire = 0;
            } else if (key == 104) {
                this.plasma = false;
            }
        } else if (this.player == 3) {
            if (key == 74) {
                if (this.accelx < 0.0) {
                    this.accelx = 0.0;
                }
            } else if (key == 76) {
                if (this.accelx > 0.0) {
                    this.accelx = 0.0;
                }
            } else if (key == 75) {
                this.accely = 0.0;
            } else if (key == 85) {
                this.fire = 0;
            } else if (key == 79) {
                this.fire = 0;
            } else if (key == 73) {
                this.plasma = false;
            }
        }
    }

    public void keyTyped(KeyEvent ke) {
    }
}

