/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;

class GCanvas
extends Canvas {
    public Map map;
    int drawX = 0;
    int drawY = 0;
    public static final int visibleWidth = 14;
    public static final int visibleHeight = 10;
    public BufferedImage buffer;
    public static int offX = 0;
    public static int offY = 0;
    double vx = 0.0;
    double vy = 0.0;
    double ax = 0.0;
    double ay = 0.0;
    boolean stopping = false;
    public Color msgColor = Color.yellow;
    public String msg = " . . . LOADING . . .";
    public int msgSize = 10;

    public GCanvas(Map map) {
        this.map = map;
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = GCanvas.this.getSize();
                GCanvas.this.buffer = null;
                int n = dimension.width / 12 / 14;
                int n2 = dimension.height / 12 / 10;
                Map.MULT = n < n2 ? (n < 1 ? 1 : n) : (n2 < 1 ? 1 : n2);
                Map.CELLSIZE = 12 * Map.MULT;
            }
        });
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.buffer == null) {
            this.buffer = new BufferedImage(dimension.width, dimension.height, 1);
        }
        this.paint(this.buffer.getGraphics());
        graphics.drawImage(this.buffer, 0, 0, this);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.translate((dimension.width - 14 * Map.CELLSIZE) / 2, (dimension.height - 10 * Map.CELLSIZE) / 2);
        graphics.setClip(new Rectangle(0, 0, 14 * Map.CELLSIZE, 10 * Map.CELLSIZE));
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        this.map.paint(this.drawX, this.drawY, 15, 10, graphics2D);
        if (MVBOffMario.gen != null) {
            MVBOffMario.gen.paint(graphics2D);
        }
        graphics2D.dispose();
        graphics.setColor(Color.yellow);
        graphics.setFont(new Font("Dialog", 0, 9 * Map.MULT));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        graphics.drawString("Level: " + MVBOffMario.level + "  Lives: " + MVBOffMario.lives, 5, fontMetrics.getHeight());
        if (MVBOffMario.mario != null) {
            int n = 14 * Map.CELLSIZE - 5 - fontMetrics.stringWidth("Time: 999");
            graphics.drawString("Time: " + MVBOffMario.mario.lifespan / 20, n, fontMetrics.getHeight());
            graphics.drawString("Score: " + MVBOffMario.score, n - fontMetrics.stringWidth("Score: 999"), fontMetrics.getHeight());
        }
        if (this.msg != null) {
            graphics.setColor(this.msgColor);
            graphics.setFont(new Font("DialogInput", 1, this.msgSize * Map.MULT));
            fontMetrics = graphics.getFontMetrics();
            graphics.drawString(this.msg, (14 * Map.CELLSIZE - fontMetrics.stringWidth(this.msg)) / 2, (10 * Map.CELLSIZE - fontMetrics.getHeight()) / 2);
        }
    }

    public Graphics2D getGenGraphics() {
        Dimension dimension = this.getSize();
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        graphics2D.translate((dimension.width - 14 * Map.CELLSIZE) / 2, (dimension.height - 10 * Map.CELLSIZE) / 2);
        graphics2D.setClip(new Rectangle(0, 0, 14 * Map.CELLSIZE, 10 * Map.CELLSIZE));
        return graphics2D;
    }

    public void adjustVisibleToMario() {
        if (MVBOffMario.mario == null) {
            return;
        }
        double d = MVBOffMario.mario.getVelX();
        int n = MVBOffMario.mario.bounds.x;
        int n2 = MVBOffMario.mario.bounds.y;
        this.drawX = n / 12 - 4;
        offX = (this.drawX + 4) * 12 - n;
        if (this.drawX < 0) {
            this.drawX = 0;
            offX = 0;
        }
        this.drawY = n2 / 12 - 5;
        offY = (this.drawY + 5) * 12 - n2;
        if (this.drawY >= this.map.mapHeight() - 10 || this.drawY + 5 > this.map.mapHeight() - 8) {
            this.drawY = this.map.mapHeight() - 10;
            offY = 0;
        }
        if (this.drawY < 0) {
            this.drawY = 0;
            offY = 0;
        }
        if (d > 0.0) {
            this.map.activate(this.drawX + 14 + 5, 0, 1, this.map.mapHeight());
        }
        if (d < 0.0) {
            this.map.activate(this.drawX - 5, 0, 1, this.map.mapHeight());
        }
    }

    public void showMessage(String string, Color color, int n, final long l) {
        this.msg = string;
        this.msgColor = color;
        this.msgSize = n;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                GCanvas.this.msg = null;
                GCanvas.this.repaint();
            }
        });
        thread.start();
        this.repaint();
    }

    public void showMessage(String string, Color color, int n) {
        this.msg = string;
        this.msgColor = color;
        this.msgSize = n;
        this.repaint();
    }
}

