/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class GEngine
implements Runnable {
    public static final int MAX_SPRITES = 50;
    private Sprite[] sprites = new Sprite[50];
    private int numSprites = 0;
    private Thread runner = null;
    private boolean running = false;
    public long delay = 50L;
    private boolean donttouch = false;

    public void start() {
        if (!this.running) {
            this.running = true;
            this.runner = new Thread(this);
            this.runner.start();
        }
    }

    public void stop() {
        this.running = false;
        this.runner = null;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void run() {
        while (this.running) {
            long l = System.currentTimeMillis();
            MVBOffMario.gp.repaint();
            this.update();
            long l2 = this.delay - (System.currentTimeMillis() - l);
            if (l2 < 0L) {
                l2 = 5L;
            }
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("No durmio todo el " + l2);
            }
        }
    }

    public synchronized void paint(Graphics2D graphics2D) {
        graphics2D.translate(-MVBOffMario.gp.drawX * Map.CELLSIZE, -MVBOffMario.gp.drawY * Map.CELLSIZE);
        for (int i = 0; i < this.numSprites; ++i) {
            if (this.sprites[i] == null) continue;
            this.sprites[i].paint(graphics2D);
        }
    }

    public synchronized void update() {
        for (int i = 0; i < this.numSprites; ++i) {
            if (this.sprites[i] == null) continue;
            this.sprites[i].update();
        }
    }

    public synchronized void addSprite(Sprite sprite) {
        if (this.numSprites < 50) {
            this.sprites[this.numSprites] = sprite;
            sprite.genID = this.numSprites++;
        }
    }

    public synchronized void removeSprite(Sprite sprite) {
        if (this.donttouch) {
            return;
        }
        if (sprite.genID > -1 && sprite.genID < this.sprites.length && this.sprites[sprite.genID] == sprite) {
            this.sprites[sprite.genID] = this.sprites[--this.numSprites];
            this.sprites[sprite.genID].genID = sprite.genID;
            this.sprites[this.numSprites] = null;
            sprite.genID = -1;
        }
    }

    public synchronized void killAll() {
        if (this.donttouch) {
            return;
        }
        this.donttouch = true;
        for (int i = 0; i < this.numSprites; ++i) {
            if (!(this.sprites[i] instanceof Mario)) {
                this.sprites[i].die();
            }
            this.sprites[i].genID = -1;
            this.sprites[i] = null;
        }
        this.numSprites = 0;
        this.donttouch = false;
    }

    public synchronized void killInBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        for (int i = 0; i < this.numSprites; ++i) {
            if (!(this.sprites[i] instanceof Baddie) || !rectangle.intersects(this.sprites[i].bounds)) continue;
            this.removeSprite(this.sprites[i]);
            --i;
        }
    }

    public synchronized void killLessThan(int n) {
        if (this.donttouch) {
            return;
        }
        System.out.println("Killing less than " + n);
        Sprite[] spriteArray = new Sprite[this.numSprites];
        System.arraycopy(this.sprites, 0, spriteArray, 0, this.numSprites);
        for (int i = 0; i < this.numSprites; ++i) {
            if (spriteArray[i] instanceof Mario || spriteArray[i].bounds.x >= n) continue;
            spriteArray[i].die();
        }
    }

    public void detectCollision(Mario mario, int n, int n2) {
        Shot shot;
        int n3;
        block0: for (n3 = 0; n3 < this.numSprites; ++n3) {
            if (this.sprites[n3] == null || !(this.sprites[n3] instanceof Shot)) continue;
            shot = (Shot)this.sprites[n3];
            if (shot.badguy) continue;
            for (int i = 0; i < this.numSprites; ++i) {
                if (!(this.sprites[i] instanceof Baddie) || !this.sprites[i].bounds.intersects(shot.bounds)) continue;
                Sprite sprite = this.sprites[i];
                shot.die();
                sprite.die();
                --n3;
                continue block0;
            }
        }
        for (n3 = 0; n3 < this.numSprites; ++n3) {
            if (!this.sprites[n3].tangible) continue;
            if (this.sprites[n3] instanceof Baddie) {
                if (!mario.bounds.intersects(this.sprites[n3].bounds)) continue;
                if (n2 + mario.bounds.height - 1 < this.sprites[n3].bounds.y) {
                    mario.bounds.y = this.sprites[n3].bounds.y - mario.bounds.height;
                    mario.locY = mario.bounds.y;
                    mario.velY = -5.0;
                    this.sprites[n3].die();
                    return;
                }
                mario.shrink();
                return;
            }
            if (this.sprites[n3] instanceof Goodie) {
                if (!mario.bounds.intersects(this.sprites[n3].bounds)) continue;
                ((Goodie)this.sprites[n3]).collect();
                return;
            }
            if (!(this.sprites[n3] instanceof Shot)) continue;
            shot = (Shot)this.sprites[n3];
            if (!shot.badguy || !mario.bounds.intersects(this.sprites[n3].bounds)) continue;
            this.sprites[n3].die();
            mario.shrink();
            return;
        }
    }
}

