/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.DataInputStream;
import java.io.FileInputStream;

public class Map {
    public static final int DEFAULT_CELLSIZE = 12;
    public static int CELLSIZE = 12;
    public static int MULT = 1;
    public static Color skyColor = new Color(64, 64, 255);
    public static final Color brown = new Color(196, 196, 128);
    public int time = 250;
    private String[] sublevMsg;
    private char[][][] map;
    private char[][][] saveState = null;
    private int curZ = 0;

    public Map(String string) {
        int n;
        int n2;
        try {
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
            n2 = Integer.parseInt(new String(new char[]{(char)dataInputStream.readByte()}));
            this.time = 20 * Integer.parseInt(new String(new char[]{(char)dataInputStream.readByte(), (char)dataInputStream.readByte(), (char)dataInputStream.readByte()}));
            this.map = new char[n2 + 1][][];
            this.sublevMsg = new String[n2 + 1];
            byte[] byArray = new byte[255];
            for (n = 0; n <= n2; ++n) {
                int n3 = Integer.parseInt(new String(new char[]{(char)dataInputStream.readByte(), (char)dataInputStream.readByte(), (char)dataInputStream.readByte()}));
                int n4 = Integer.parseInt(new String(new char[]{(char)dataInputStream.readByte(), (char)dataInputStream.readByte()}));
                while (dataInputStream.readByte() != 13) {
                }
                if (dataInputStream.readByte() != 10) {
                    throw new Exception("Missing LF in 1rst line");
                }
                int n5 = 32;
                int n6 = 0;
                while (true) {
                    byte by = dataInputStream.readByte();
                    n5 = by;
                    if (by == 13) break;
                    byArray[n6++] = n5;
                }
                if (dataInputStream.readByte() != 10) {
                    throw new Exception("Missing LF in 1rst line");
                }
                this.sublevMsg[n] = new String(byArray, 0, n6);
                this.map[n] = new char[n3][n4];
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        this.map[n][j][i] = (char)dataInputStream.readByte();
                    }
                    if (dataInputStream.readByte() != 13) {
                        throw new Exception("Missing CR");
                    }
                    if (dataInputStream.readByte() == 10) continue;
                    throw new Exception("Missing LF");
                }
            }
        }
        catch (Exception exception) {
            System.out.println("Can't load level: " + string + "\n\treason:" + exception);
        }
        for (int i = 0; i < this.map.length; ++i) {
            for (n2 = 0; n2 < this.map[i][0].length; ++n2) {
                for (int j = 0; j < this.map[i].length; ++j) {
                    if ((this.map[i][j][n2] < '0' || this.map[i][j][n2] > '9') && this.map[i][j][n2] != 'P') continue;
                    if (this.map[i][j][n2] == 'P') {
                        this.map[i][j][n2] = 58;
                    }
                    if (this.mapAt(i, j, n2 - 1) == 'G') {
                        this.setAt(i, j, n2 - 1, '\u00e7');
                        this.setAt(i, j - 1, n2 - 1, '\u0167');
                        this.setAt(i, j + 1, n2 - 1, '\u01e7');
                        this.setAt(i, j - 1, n2, '\u0267');
                        this.setAt(i, j + 1, n2, '\u02e7');
                        this.setAt(i, j, n2, (char)(0x347 | this.map[i][j][n2] - 48 << 11));
                        continue;
                    }
                    if (this.mapAt(i, j, n2 - 1) == 'g') {
                        this.setAt(i, j, n2 - 1, '\u03e7');
                        this.setAt(i, j, n2, (char)(0xC7 | this.map[i][j][n2] - 48 << 11));
                        continue;
                    }
                    if (this.mapAt(i, j, n2 + 1) == '|' || this.mapAt(i, j, n2 + 1) == '\\') {
                        n = n2;
                        while (this.mapAt(i, j, ++n) == '|') {
                            this.setAt(i, j, n, '\u00fc');
                        }
                        this.setAt(i, j, n2, (char)(0x1FC | this.map[i][j][n2] - 48 << 11));
                        continue;
                    }
                    if (this.mapAt(i, j, n2 - 1) == '|' || this.mapAt(i, j, n2 - 1) == '\\') {
                        n = n2;
                        while (this.mapAt(i, j, --n) == '|') {
                            this.setAt(i, j, n, '\u00fc');
                        }
                        this.setAt(i, j, n2, (char)(0x27C | this.map[i][j][n2] - 48 << 11));
                        continue;
                    }
                    if (this.mapAt(i, j - 1, n2) == '|' || this.mapAt(i, j - 1, n2) == '\\') {
                        n = j;
                        while (this.mapAt(i, --n, n2) == '|') {
                            this.setAt(i, n, n2, '\u017c');
                        }
                        this.setAt(i, j, n2, (char)(0x2FC | this.map[i][j][n2] - 48 << 11));
                        continue;
                    }
                    if (this.mapAt(i, j + 1, n2) == '|' || this.mapAt(i, j + 1, n2) == '\\') {
                        n = j;
                        while (this.mapAt(i, ++n, n2) == '|') {
                            this.setAt(i, n, n2, '\u017c');
                        }
                        this.setAt(i, j, n2, (char)(0x37C | this.map[i][j][n2] - 48 << 11));
                        continue;
                    }
                    if (this.mapAt(i, j, n2 + 1) != 'Y') continue;
                    this.setAt(i, j, n2 + 1, (char)(0x59 | this.map[i][j][n2] - 48 << 11));
                }
            }
        }
        this.saveMapState();
    }

    private char mapAt(int n, int n2, int n3) {
        if (n >= 0 && n < this.map.length && n2 >= 0 && n2 < this.map[n].length && n3 >= 0 && n3 < this.map[n][n2].length) {
            return this.map[n][n2][n3];
        }
        return '\u0000';
    }

    private void setAt(int n, int n2, int n3, char c) {
        if (n >= 0 && n < this.map.length && n2 >= 0 && n2 < this.map[n].length && n3 >= 0 && n3 < this.map[n][n2].length) {
            this.map[n][n2][n3] = c;
        }
    }

    public int mapWidth() {
        return this.map[this.curZ].length;
    }

    public int mapHeight() {
        return this.map[this.curZ][0].length;
    }

    public Point getPortalEntrance() {
        for (int i = 0; i < this.map[this.curZ].length; ++i) {
            for (int j = 0; j < this.map[this.curZ][0].length; ++j) {
                if ((this.map[this.curZ][i][j] & 0xF800) >> 11 != 10) continue;
                return new Point(i, j);
            }
        }
        return new Point(0, 0);
    }

    public String getSubLevMsg() {
        return this.sublevMsg[this.curZ];
    }

    public void saveMapState() {
        this.saveState = new char[this.map.length][][];
        for (int i = 0; i < this.map.length; ++i) {
            this.saveState[i] = new char[this.map[i].length][this.map[i][0].length];
            for (int j = 0; j < this.map[i].length; ++j) {
                for (int k = 0; k < this.map[i][0].length; ++k) {
                    this.saveState[i][j][k] = this.map[i][j][k];
                }
            }
        }
    }

    public void restoreMapState(int n) {
        this.curZ = n;
        for (int i = 0; i < this.map[n][0].length; ++i) {
            block5: for (int j = 0; j < this.map[n].length; ++j) {
                switch (this.saveState[n][j][i]) {
                    case 'M': 
                    case 'S': 
                    case 'a': 
                    case 'z': {
                        continue block5;
                    }
                    case 'u': {
                        this.map[n][j][i] = 109;
                        continue block5;
                    }
                    default: {
                        this.map[n][j][i] = this.saveState[n][j][i];
                    }
                }
            }
        }
    }

    public void paint(int n, int n2, int n3, int n4, Graphics2D graphics2D) {
        if (GMedia.getImage("sky") != null) {
            graphics2D.drawImage(GMedia.getImage("sky"), 0, 0, n3 * CELLSIZE, n4 * CELLSIZE, MVBOffMario.gp);
        } else {
            graphics2D.setColor(skyColor);
            graphics2D.fillRect(0, 0, n3 * CELLSIZE, n4 * CELLSIZE);
        }
        for (int i = 0; i < n4 && n2 + i < this.map[this.curZ][0].length; ++i) {
            for (int j = 0; j < n3 && n + j < this.map[this.curZ].length; ++j) {
                this.paintCell((char)(this.map[this.curZ][n + j][n2 + i] & 0x7FF), graphics2D, CELLSIZE * j + GCanvas.offX * MULT, CELLSIZE * i + GCanvas.offY * MULT);
            }
        }
    }

    private void paintCell(char c, Graphics2D graphics2D, int n, int n2) {
        if (GMedia.getImage("" + c) != null) {
            graphics2D.drawImage(GMedia.getImage("" + c), n, n2, CELLSIZE, CELLSIZE, MVBOffMario.gp);
            return;
        }
        switch (c) {
            case ',': 
            case '.': {
                break;
            }
            case 'B': 
            case 'C': 
            case 'M': {
                break;
            }
            case 'S': {
                graphics2D.setColor(Color.blue);
                graphics2D.fillRect(n, n2, CELLSIZE, CELLSIZE);
                break;
            }
            case ')': {
                if (MVBOffMario.switches[0]) break;
                graphics2D.drawImage(GMedia.getImage("b"), n, n2, CELLSIZE, CELLSIZE, MVBOffMario.gp);
                break;
            }
            case '!': {
                if (MVBOffMario.switches[1]) break;
                graphics2D.drawImage(GMedia.getImage("b"), n, n2, CELLSIZE, CELLSIZE, MVBOffMario.gp);
                graphics2D.setColor(Color.blue);
                graphics2D.drawRect(n, n2, CELLSIZE, CELLSIZE);
                graphics2D.drawRect(n + 1, n2 + 1, CELLSIZE - 2, CELLSIZE - 2);
                break;
            }
            case '@': {
                if (MVBOffMario.switches[2]) break;
                graphics2D.drawImage(GMedia.getImage("b"), n, n2, CELLSIZE, CELLSIZE, MVBOffMario.gp);
                graphics2D.setColor(Color.yellow);
                graphics2D.drawRect(n, n2, CELLSIZE, CELLSIZE);
                graphics2D.drawRect(n + 1, n2 + 1, CELLSIZE - 2, CELLSIZE - 2);
                break;
            }
            case '#': {
                if (MVBOffMario.switches[3]) break;
                graphics2D.drawImage(GMedia.getImage("b"), n, n2, CELLSIZE, CELLSIZE, MVBOffMario.gp);
                graphics2D.setColor(Color.red);
                graphics2D.drawRect(n, n2, CELLSIZE, CELLSIZE);
                graphics2D.drawRect(n + 1, n2 + 1, CELLSIZE - 2, CELLSIZE - 2);
                break;
            }
            case '$': {
                if (MVBOffMario.switches[4]) break;
                graphics2D.drawImage(GMedia.getImage("b"), n, n2, CELLSIZE, CELLSIZE, MVBOffMario.gp);
                graphics2D.setColor(Color.yellow);
                graphics2D.drawRect(n, n2, CELLSIZE, CELLSIZE);
                graphics2D.drawRect(n + 1, n2 + 1, CELLSIZE - 2, CELLSIZE - 2);
                break;
            }
            case '%': {
                if (MVBOffMario.switches[5]) break;
                graphics2D.drawImage(GMedia.getImage("b"), n, n2, CELLSIZE, CELLSIZE, MVBOffMario.gp);
                graphics2D.setColor(Color.blue);
                graphics2D.drawRect(n, n2, CELLSIZE, CELLSIZE);
                graphics2D.drawRect(n + 1, n2 + 1, CELLSIZE - 2, CELLSIZE - 2);
                break;
            }
            case '^': {
                if (MVBOffMario.switches[6]) break;
                graphics2D.drawImage(GMedia.getImage("b"), n, n2, CELLSIZE, CELLSIZE, MVBOffMario.gp);
                graphics2D.setColor(Color.green);
                graphics2D.drawRect(n, n2, CELLSIZE, CELLSIZE);
                graphics2D.drawRect(n + 1, n2 + 1, CELLSIZE - 2, CELLSIZE - 2);
                break;
            }
            case '&': {
                if (!MVBOffMario.switches[7]) break;
                graphics2D.drawImage(GMedia.getImage("b"), n, n2, CELLSIZE, CELLSIZE, MVBOffMario.gp);
                graphics2D.setColor(Color.yellow);
                graphics2D.drawRect(n, n2, CELLSIZE, CELLSIZE);
                graphics2D.drawRect(n + 1, n2 + 1, CELLSIZE - 2, CELLSIZE - 2);
                break;
            }
            case '*': {
                if (!MVBOffMario.switches[8]) break;
                graphics2D.drawImage(GMedia.getImage("b"), n, n2, CELLSIZE, CELLSIZE, MVBOffMario.gp);
                graphics2D.setColor(Color.blue);
                graphics2D.drawRect(n, n2, CELLSIZE, CELLSIZE);
                graphics2D.drawRect(n + 1, n2 + 1, CELLSIZE - 2, CELLSIZE - 2);
                break;
            }
            case '(': {
                if (!MVBOffMario.switches[9]) break;
                graphics2D.drawImage(GMedia.getImage("b"), n, n2, CELLSIZE, CELLSIZE, MVBOffMario.gp);
                graphics2D.setColor(Color.green);
                graphics2D.drawRect(n, n2, CELLSIZE, CELLSIZE);
                graphics2D.drawRect(n + 1, n2 + 1, CELLSIZE - 2, CELLSIZE - 2);
                break;
            }
            case 'm': 
            case 'u': {
                graphics2D.setColor(Color.yellow);
                graphics2D.fillRect(n, n2, CELLSIZE, CELLSIZE);
                break;
            }
            case 'k': {
                graphics2D.setColor(Color.green);
                graphics2D.fillRect(n, n2, CELLSIZE, CELLSIZE);
                graphics2D.setColor(new Color(255, 255, 128));
                graphics2D.fillRect(n, n2, CELLSIZE, 2 * MULT);
                graphics2D.fillRect(n, n2, 2 * MULT, CELLSIZE);
                break;
            }
            case 'l': {
                graphics2D.fillRect(n, n2, CELLSIZE, CELLSIZE);
                graphics2D.setColor(new Color(255, 255, 128));
                graphics2D.fillRect(n, n2, CELLSIZE, 2 * MULT);
                break;
            }
            case ';': {
                graphics2D.setColor(Color.green);
                graphics2D.fillRect(n, n2, CELLSIZE, CELLSIZE);
                graphics2D.setColor(new Color(255, 255, 128));
                graphics2D.fillRect(n, n2, CELLSIZE, 2 * MULT);
                graphics2D.fillRect(n + CELLSIZE - 2 * MULT, n2, 2 * MULT, CELLSIZE);
                break;
            }
            case 'i': {
                graphics2D.setColor(new Color(160, 160, 96));
                graphics2D.fillRect(n + 2 * MULT, n2, CELLSIZE - 2 * MULT, CELLSIZE);
                break;
            }
            case 'o': {
                graphics2D.setColor(new Color(160, 160, 96));
                graphics2D.fillRect(n, n2, CELLSIZE, CELLSIZE);
                break;
            }
            case 'p': {
                graphics2D.setColor(new Color(160, 160, 96));
                graphics2D.fillRect(n, n2, CELLSIZE - 2 * MULT, CELLSIZE);
                break;
            }
            case 'h': {
                graphics2D.setColor(brown);
                graphics2D.fillRect(n, n2, CELLSIZE, CELLSIZE);
                break;
            }
            case 'c': {
                graphics2D.setColor(Color.white);
                graphics2D.fillRect(n, n2, CELLSIZE, CELLSIZE);
                break;
            }
            case 'b': 
            case 'd': {
                graphics2D.setColor(Color.black);
                graphics2D.fillRect(n, n2, CELLSIZE, CELLSIZE);
            }
        }
    }

    public void activate(int n, int n2, int n3, int n4) {
        for (int i = 0; i < n4 && n2 + i < this.map[this.curZ][0].length; ++i) {
            for (int j = 0; j < n3 && n + j < this.map[this.curZ].length; ++j) {
                this.activateCell(n + j, n2 + i);
            }
        }
    }

    private void activateCell(int n, int n2) {
        if (n < 0 || n > this.map[this.curZ].length || n2 < 0 || n2 > this.map[this.curZ][0].length) {
            return;
        }
        switch (this.map[this.curZ][n][n2]) {
            case 'M': {
                MVBOffMario.mario = new Mario(n, n2, this.curZ);
                MVBOffMario.gen.addSprite(MVBOffMario.mario);
                this.map[this.curZ][n][n2] = 44;
                break;
            }
            case 'C': {
                Cloud cloud = new Cloud(n, n2, this.curZ);
                MVBOffMario.gen.addSprite(cloud);
                this.map[this.curZ][n][n2] = 44;
                break;
            }
            case 'B': {
                Baddie baddie = new Baddie('B', n, n2, this.curZ);
                MVBOffMario.gen.addSprite(baddie);
                this.map[this.curZ][n][n2] = 44;
                break;
            }
            case 'X': {
                Baddie baddie = new Baddie('B', n, n2, this.curZ);
                MVBOffMario.gen.addSprite(baddie);
                this.map[this.curZ][n][n2] = 44;
            }
        }
    }

    public void restoreSpawn(char c, int n, int n2, int n3) {
        if (n >= 0 && n < this.map[n3].length && n2 >= 0 && n2 < this.map[n3][0].length && this.map[n3][n][n2] == ',') {
            this.map[n3][n][n2] = c;
        }
    }

    public HitInfo checkFloor(Rectangle rectangle, boolean bl, boolean bl2, int n, int n2) {
        int n3 = rectangle.x / 12;
        int n4 = rectangle.y / 12;
        int n5 = (rectangle.y + rectangle.height - 1) / 12;
        int n6 = (rectangle.x + rectangle.width - 1) / 12;
        if (n4 == n5) {
            return null;
        }
        HitInfo hitInfo = null;
        if (this.isFloor(n3, n5)) {
            hitInfo = new HitInfo(n4 * 12, bl2 ? HitInfo.FIRST : HitInfo.SECOND, this.isAction(n3, n5, HitInfo.FLOOR) && bl ? n3 : HitInfo.NO_ACTION, n5, HitInfo.FLOOR);
        } else if (this.isAction(n3, n5, HitInfo.FLOOR) && bl) {
            hitInfo = new HitInfo(HitInfo.NOT_SOLID, bl2 ? HitInfo.FIRST : HitInfo.SECOND, n3, n5, HitInfo.FLOOR);
        }
        if (this.isFloor(n6, n5)) {
            if (hitInfo == null || hitInfo.type != HitInfo.FIRST || hitInfo.newLoc == HitInfo.NOT_SOLID) {
                hitInfo = new HitInfo(n4 * 12, bl2 ? HitInfo.SECOND : HitInfo.FIRST, this.isAction(n6, n5, HitInfo.FLOOR) && bl ? n6 : HitInfo.NO_ACTION, n5, HitInfo.FLOOR);
            }
        } else if (this.isAction(n6, n5, HitInfo.FLOOR) && bl && (hitInfo == null || hitInfo.type != HitInfo.FIRST)) {
            hitInfo = new HitInfo(HitInfo.NOT_SOLID, bl2 ? HitInfo.SECOND : HitInfo.FIRST, n6, n5, HitInfo.FLOOR);
        }
        return hitInfo;
    }

    public HitInfo checkRoof(Rectangle rectangle, boolean bl, boolean bl2, int n, int n2) {
        int n3 = rectangle.x / 12;
        int n4 = rectangle.y / 12;
        int n5 = (rectangle.y + rectangle.height - 1) / 12;
        int n6 = (rectangle.x + rectangle.width - 1) / 12;
        if (n4 == n5) {
            return null;
        }
        if (n + rectangle.width - 1 <= n3 * 12 && n + 1 >= (n3 + 1) * 12 || n2 <= n4 * 12) {
            return null;
        }
        if (rectangle.height == 24) {
            --n5;
        }
        HitInfo hitInfo = null;
        if (this.isRoof(n3, n4)) {
            hitInfo = new HitInfo(n5 * 12, bl2 ? HitInfo.FIRST : HitInfo.SECOND, this.isAction(n3, n4, HitInfo.ROOF) && bl ? n3 : HitInfo.NO_ACTION, n4, HitInfo.ROOF);
        } else if (this.isAction(n3, n4, HitInfo.ROOF) && bl) {
            hitInfo = new HitInfo(HitInfo.NOT_SOLID, bl2 ? HitInfo.FIRST : HitInfo.SECOND, n3, n4, HitInfo.ROOF);
        }
        if (this.isRoof(n6, n4)) {
            if (hitInfo == null || hitInfo.type != HitInfo.FIRST || hitInfo.newLoc == HitInfo.NOT_SOLID) {
                hitInfo = new HitInfo(n5 * 12, bl2 ? HitInfo.SECOND : HitInfo.FIRST, this.isAction(n6, n4, HitInfo.ROOF) && bl ? n6 : HitInfo.NO_ACTION, n4, HitInfo.ROOF);
            }
        } else if (this.isAction(n6, n4, HitInfo.ROOF) && bl && (hitInfo == null || hitInfo.type != HitInfo.FIRST)) {
            hitInfo = new HitInfo(HitInfo.NOT_SOLID, bl2 ? HitInfo.SECOND : HitInfo.FIRST, n6, n4, HitInfo.ROOF);
        }
        return hitInfo;
    }

    public HitInfo checkLeftWall(Rectangle rectangle, boolean bl, boolean bl2, int n, int n2) {
        int n3 = rectangle.x / 12;
        int n4 = rectangle.y / 12;
        int n5 = (rectangle.y + rectangle.height - 1) / 12;
        int n6 = (rectangle.x + rectangle.width - 1) / 12;
        if (n3 == n6) {
            return null;
        }
        HitInfo hitInfo = null;
        if (this.isWall(n3, n4)) {
            hitInfo = new HitInfo(n6 * 12, bl2 ? HitInfo.FIRST : HitInfo.SECOND, this.isAction(n3, n4, HitInfo.LEFT_WALL) && bl ? n3 : HitInfo.NO_ACTION, n4, HitInfo.LEFT_WALL);
        } else if (this.isAction(n3, n4, HitInfo.LEFT_WALL) && bl) {
            hitInfo = new HitInfo(HitInfo.NOT_SOLID, bl2 ? HitInfo.FIRST : HitInfo.SECOND, n3, n4, HitInfo.LEFT_WALL);
        }
        if (this.isWall(n3, n5)) {
            if (hitInfo == null || hitInfo.type != HitInfo.FIRST || hitInfo.newLoc == HitInfo.NOT_SOLID) {
                hitInfo = new HitInfo(n6 * 12, bl2 ? HitInfo.SECOND : HitInfo.FIRST, this.isAction(n3, n5, HitInfo.LEFT_WALL) && bl ? n3 : HitInfo.NO_ACTION, n5, HitInfo.LEFT_WALL);
            }
        } else if (this.isAction(n3, n5, HitInfo.LEFT_WALL) && bl && (hitInfo == null || hitInfo.type != HitInfo.FIRST)) {
            hitInfo = new HitInfo(HitInfo.NOT_SOLID, bl2 ? HitInfo.SECOND : HitInfo.FIRST, n3, n5, HitInfo.LEFT_WALL);
        }
        return hitInfo;
    }

    public HitInfo checkRightWall(Rectangle rectangle, boolean bl, boolean bl2, int n, int n2) {
        int n3 = rectangle.x / 12;
        int n4 = rectangle.y / 12;
        int n5 = (rectangle.y + rectangle.height - 1) / 12;
        int n6 = (rectangle.x + rectangle.width - 1) / 12;
        if (n3 == n6) {
            return null;
        }
        HitInfo hitInfo = null;
        if (this.isWall(n6, n4)) {
            hitInfo = new HitInfo(n3 * 12, bl2 ? HitInfo.FIRST : HitInfo.SECOND, this.isAction(n6, n4, HitInfo.RIGHT_WALL) && bl ? n6 : HitInfo.NO_ACTION, n4, HitInfo.RIGHT_WALL);
        } else if (this.isAction(n6, n4, HitInfo.RIGHT_WALL) && bl) {
            hitInfo = new HitInfo(HitInfo.NOT_SOLID, bl2 ? HitInfo.FIRST : HitInfo.SECOND, n6, n4, HitInfo.RIGHT_WALL);
        }
        if (this.isWall(n6, n5)) {
            if (hitInfo == null || hitInfo.type != HitInfo.FIRST || hitInfo.newLoc == HitInfo.NOT_SOLID) {
                hitInfo = new HitInfo(n3 * 12, bl2 ? HitInfo.SECOND : HitInfo.FIRST, this.isAction(n6, n5, HitInfo.RIGHT_WALL) && bl ? n6 : HitInfo.NO_ACTION, n5, HitInfo.RIGHT_WALL);
            }
        } else if (this.isAction(n6, n5, HitInfo.RIGHT_WALL) && bl && (hitInfo == null || hitInfo.type != HitInfo.FIRST)) {
            hitInfo = new HitInfo(HitInfo.NOT_SOLID, bl2 ? HitInfo.SECOND : HitInfo.FIRST, n6, n5, HitInfo.RIGHT_WALL);
        }
        return hitInfo;
    }

    private boolean enterPortal(int n, int n2) {
        int n3 = (this.map[this.curZ][n][n2] & 0xF800) >> 11;
        if (n3 >= 0 && n3 <= 9) {
            this.curZ = n3;
            Point point = this.getPortalEntrance();
            MVBOffMario.mario.duckSelf();
            MVBOffMario.mario.moveTo(point.x * 12, point.y * 12);
            int n4 = (this.map[this.curZ][point.x][point.y] & 0x780) >> 7;
            MVBOffMario.mario.velX = n4 == 5 ? 5.0 : (n4 == 6 ? -5.0 : 0.0);
            MVBOffMario.mario.velY = n4 == 3 ? 5.0 : 0.01;
            MVBOffMario.mario.accelX = 0.0;
            MVBOffMario.mario.accelY = 0.0;
            MVBOffMario.gen.killAll();
            MVBOffMario.gen.addSprite(MVBOffMario.mario);
            this.activate(point.x - 4, 0, 19, this.mapHeight());
            MVBOffMario.gp.showMessage(this.sublevMsg[this.curZ], Color.yellow, 12, 2000L);
            return true;
        }
        return false;
    }

    public boolean checkDoor(int n, int n2) {
        if (n < 0 || n >= this.map[this.curZ].length || n2 < 0 || n2 >= this.map[this.curZ][0].length) {
            return false;
        }
        if ((char)(this.map[this.curZ][n][n2] & 0x7F) == 'G') {
            return this.enterPortal(n, n2);
        }
        return false;
    }

    private void showBrickBreak(int n, int n2) {
        Sprite sprite = new Sprite('\u0000', n, n2, this.curZ, n * 12, n2 * 12, 6, 6);
        sprite.img = GMedia.getImage("BrickPiece");
        sprite.velX = -5.0;
        sprite.velY = -5.0;
        sprite.lifespan = 20;
        MVBOffMario.gen.addSprite(sprite);
        sprite = new Sprite('\u0000', n, n2, this.curZ, n * 12 + 6, n2 * 12, 6, 6);
        sprite.img = GMedia.getImage("BrickPiece");
        sprite.velX = 5.0;
        sprite.velY = -5.0;
        sprite.lifespan = 20;
        MVBOffMario.gen.addSprite(sprite);
        sprite = new Sprite('\u0000', n, n2, this.curZ, n * 12 + 6, n2 * 12 + 6, 6, 6);
        sprite.img = GMedia.getImage("BrickPiece");
        sprite.velX = 5.0;
        sprite.velY = 0.5;
        sprite.lifespan = 20;
        MVBOffMario.gen.addSprite(sprite);
        sprite = new Sprite('\u0000', n, n2, this.curZ, n * 12, n2 * 12 + 6, 6, 6);
        sprite.img = GMedia.getImage("BrickPiece");
        sprite.velX = -5.0;
        sprite.velY = 0.5;
        sprite.lifespan = 20;
        MVBOffMario.gen.addSprite(sprite);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doAction(HitInfo hitInfo) {
        block26: {
            int n = hitInfo.actX;
            int n2 = hitInfo.actY;
            int n3 = hitInfo.actDir;
            if (n < 0 || n >= this.map[this.curZ].length || n2 < 0 || n2 >= this.map[this.curZ][0].length) {
                return;
            }
            switch ((char)(this.map[this.curZ][n][n2] & 0x7F)) {
                case 'b': 
                case 'e': {
                    if (n3 != HitInfo.ROOF) return;
                    this.map[this.curZ][n][n2] = 46;
                    this.showBrickBreak(n, n2);
                    MVBOffMario.gen.killInBounds(n * 12, (n2 - 1) * 12, 12, 12);
                    return;
                }
                case 'd': {
                    if (n3 != HitInfo.ROOF) return;
                    this.map[this.curZ][n][n2] = 101;
                    return;
                }
                case 'v': {
                    if (n3 != HitInfo.ROOF) return;
                    this.map[this.curZ][n][n2] = 122;
                    return;
                }
                case 'm': {
                    if (n3 != HitInfo.ROOF) return;
                    this.map[this.curZ][n][n2] = 46;
                    MVBOffMario.gen.addSprite(new Goodie('m', n, n2, this.curZ));
                    return;
                }
                case 'u': {
                    if (n3 != HitInfo.ROOF) return;
                    this.map[this.curZ][n][n2] = 46;
                    MVBOffMario.gen.addSprite(new Goodie('u', n, n2, this.curZ));
                    return;
                }
                case 'q': {
                    if (n3 != HitInfo.ROOF) return;
                    this.map[this.curZ][n][n2] = 46;
                    if (Math.random() > 0.6) {
                        MVBOffMario.gen.addSprite(new Goodie(Math.random() > 0.2 ? (char)'m' : 'u', n, n2, this.curZ));
                        return;
                    }
                    Sprite sprite = new Sprite('\u0000', n, n2, this.curZ);
                    sprite.img = GMedia.getImage("z");
                    sprite.lifespan = 10;
                    sprite.velY = -5.0;
                    MVBOffMario.addScore(1);
                    GMedia.playSound("coin");
                    MVBOffMario.gen.addSprite(sprite);
                    return;
                }
                case 'a': {
                    if (n3 != HitInfo.ROOF) return;
                    this.map[this.curZ][n][n2] = 46;
                    Sprite sprite = new Sprite('\u0000', n, n2, this.curZ);
                    sprite.img = GMedia.getImage("z");
                    sprite.lifespan = 10;
                    sprite.velY = -5.0;
                    MVBOffMario.addScore(1);
                    GMedia.playSound("coin");
                    MVBOffMario.gen.addSprite(sprite);
                    return;
                }
                case 'z': {
                    this.map[this.curZ][n][n2] = 46;
                    MVBOffMario.addScore(1);
                    GMedia.playSound("coin");
                    return;
                }
                case 'Z': {
                    MVBOffMario.mario.passLevel();
                    return;
                }
                case 'S': {
                    this.map[this.curZ][n][n2] = 44;
                    MVBOffMario.mario.cellX = n;
                    MVBOffMario.mario.cellY = n2;
                    MVBOffMario.mario.cellZ = this.curZ;
                    MVBOffMario.mario.saveLifespan = MVBOffMario.mario.lifespan;
                    MVBOffMario.gp.showMessage("Save Point", new Color(0, 0, 128), 9, 2000L);
                    return;
                }
                case 'Y': {
                    if (n3 != HitInfo.FLOOR) return;
                    int n4 = (this.map[this.curZ][n][n2] & 0xF800) >> 11;
                    this.map[this.curZ][n][n2] = 46;
                    this.showBrickBreak(n, n2);
                    if ((n4 <= 3 || n4 >= 10) && n4 != 0) return;
                    MVBOffMario.switches[n4] = !MVBOffMario.switches[n4];
                    System.out.println("Switch " + n4 + ": " + MVBOffMario.switches[n4]);
                    return;
                }
                case '|': {
                    switch ((this.map[this.curZ][n][n2] & 0x7FF) >> 7) {
                        case 4: {
                            if (n3 != HitInfo.ROOF || !MVBOffMario.mario.isUp()) return;
                            this.enterPortal(n, n2);
                            break block26;
                        }
                        case 3: {
                            if (n3 != HitInfo.FLOOR || !MVBOffMario.mario.isDown()) return;
                            this.enterPortal(n, n2);
                            break block26;
                        }
                        case 5: {
                            if (n3 != HitInfo.LEFT_WALL || !MVBOffMario.mario.isSmall()) return;
                            this.enterPortal(n, n2);
                            break block26;
                        }
                        case 6: {
                            if (n3 != HitInfo.RIGHT_WALL || !MVBOffMario.mario.isSmall()) return;
                            this.enterPortal(n, n2);
                        }
                    }
                }
            }
        }
    }

    public boolean isAction(int n, int n2, int n3) {
        if (n < 0 || n >= this.map[this.curZ].length || n2 < 0 || n2 >= this.map[this.curZ][0].length) {
            return false;
        }
        switch ((char)(this.map[this.curZ][n][n2] & 0x7F)) {
            case 'a': 
            case 'b': 
            case 'd': 
            case 'e': 
            case 'm': 
            case 'q': 
            case 'u': 
            case 'v': {
                return n3 == HitInfo.ROOF;
            }
            case 'Y': {
                return n3 == HitInfo.FLOOR;
            }
            case 'S': 
            case 'Z': 
            case 'z': {
                return true;
            }
            case '|': {
                int n4 = (this.map[this.curZ][n][n2] & 0xF800) >> 11;
                return n4 >= 0 && n4 <= 9;
            }
        }
        return false;
    }

    public boolean isFloor(int n, int n2) {
        if (n >= 0 && n < this.map[this.curZ].length && n2 >= 0 && n2 < this.map[this.curZ][0].length) {
            switch ((char)(this.map[this.curZ][n][n2] & 0x7F)) {
                case ';': 
                case 'Y': 
                case '\\': 
                case 'a': 
                case 'b': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'h': 
                case 'i': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'u': 
                case 'v': 
                case '|': {
                    return true;
                }
                case ')': {
                    return !MVBOffMario.switches[0];
                }
                case '!': {
                    return !MVBOffMario.switches[1];
                }
                case '@': {
                    return !MVBOffMario.switches[2];
                }
                case '#': {
                    return !MVBOffMario.switches[3];
                }
                case '$': {
                    return !MVBOffMario.switches[4];
                }
                case '%': {
                    return !MVBOffMario.switches[5];
                }
                case '^': {
                    return !MVBOffMario.switches[6];
                }
                case '&': {
                    return MVBOffMario.switches[7];
                }
                case '*': {
                    return MVBOffMario.switches[8];
                }
                case '(': {
                    return MVBOffMario.switches[9];
                }
            }
            return false;
        }
        return false;
    }

    public boolean isRoof(int n, int n2) {
        if (n >= 0 && n < this.map[this.curZ].length && n2 >= 0 && n2 < this.map[this.curZ][0].length) {
            switch ((char)(this.map[this.curZ][n][n2] & 0x7F)) {
                case 'Y': 
                case '\\': 
                case 'a': 
                case 'b': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'h': 
                case 'i': 
                case 'm': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'u': 
                case 'v': 
                case '|': {
                    return true;
                }
                case ')': {
                    return !MVBOffMario.switches[0];
                }
                case '!': {
                    return !MVBOffMario.switches[1];
                }
                case '@': {
                    return !MVBOffMario.switches[2];
                }
                case '#': {
                    return !MVBOffMario.switches[3];
                }
                case '$': {
                    return !MVBOffMario.switches[4];
                }
                case '%': {
                    return !MVBOffMario.switches[5];
                }
                case '^': {
                    return !MVBOffMario.switches[6];
                }
                case '&': {
                    return MVBOffMario.switches[7];
                }
                case '*': {
                    return MVBOffMario.switches[8];
                }
                case '(': {
                    return MVBOffMario.switches[9];
                }
            }
            return false;
        }
        return false;
    }

    public boolean isWall(int n, int n2) {
        if (n < 0) {
            return true;
        }
        if (n >= 0 && n < this.map[this.curZ].length && n2 >= 0 && n2 < this.map[this.curZ][0].length) {
            switch ((char)(this.map[this.curZ][n][n2] & 0x7F)) {
                case 'Y': 
                case '\\': 
                case 'a': 
                case 'b': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'h': 
                case 'i': 
                case 'm': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'u': 
                case 'v': 
                case '|': {
                    return true;
                }
                case ')': {
                    return !MVBOffMario.switches[0];
                }
                case '!': {
                    return !MVBOffMario.switches[1];
                }
                case '@': {
                    return !MVBOffMario.switches[2];
                }
                case '#': {
                    return !MVBOffMario.switches[3];
                }
                case '$': {
                    return !MVBOffMario.switches[4];
                }
                case '%': {
                    return !MVBOffMario.switches[5];
                }
                case '^': {
                    return !MVBOffMario.switches[6];
                }
                case '&': {
                    return MVBOffMario.switches[7];
                }
                case '*': {
                    return MVBOffMario.switches[8];
                }
                case '(': {
                    return MVBOffMario.switches[9];
                }
            }
            return false;
        }
        return false;
    }

    public static class HitInfo {
        int newLoc;
        int type;
        int actX;
        int actY;
        int actDir;
        public static int NOT_SOLID = -999;
        public static int FIRST = 1;
        public static int SECOND = 2;
        public static int NO_ACTION = -999;
        public static int FLOOR = 1;
        public static int ROOF = 2;
        public static int RIGHT_WALL = 3;
        public static int LEFT_WALL = 4;

        public HitInfo(int n, int n2, int n3, int n4, int n5) {
            this.newLoc = n;
            this.type = n2;
            this.actX = n3;
            this.actY = n4;
            this.actDir = n5;
        }

        public String toString() {
            return "Hit " + (this.type == NOT_SOLID ? "NOT SOLID" : (this.type == FIRST ? "FIRST" : "SECOND")) + " loc=" + this.newLoc + " act=" + (this.actX == NO_ACTION ? "NONE" : "" + this.actX + "," + this.actY + " " + (this.actDir == FLOOR ? "FLOOR" : (this.actDir == ROOF ? "ROOF" : (this.actDir == RIGHT_WALL ? "RIGHT" : "LEF"))));
        }
    }
}

