/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;

public class Mario
extends Sprite {
    private boolean right = false;
    private boolean left = false;
    private boolean jump = false;
    private boolean duck = false;
    private boolean run = false;
    private boolean fire = false;
    public boolean mayor = false;
    public boolean crouch = false;
    public static boolean suit = true;
    public static Image headImg = null;
    public int saveLifespan = 0;
    public int blinkTime = 0;
    private boolean blink = false;
    private boolean armed = false;
    private int reload = 0;
    public boolean fly = false;
    public boolean duckJump = false;

    public Mario(int n, int n2, int n3) {
        super('M', n, n2, n3);
        this.color = Color.red;
        this.img = GMedia.getImage("Msmall");
        if (headImg == null) {
            headImg = GMedia.getImage("PlayerHead");
        }
        this.lifespan = MVBOffMario.map.time;
        this.bops = true;
    }

    public void grow() {
        if (!this.mayor) {
            this.mayor = true;
            this.bounds.y -= 12;
            this.locY = this.bounds.y;
            this.bounds.height += 12;
            this.updateImg();
            MVBOffMario.gp.showMessage("Companero Mayor!", Color.yellow, 9, 2000L);
        } else if (!this.armed) {
            this.armed = true;
            MVBOffMario.gp.showMessage("BoM Ready", Color.yellow, 9, 2000L);
        }
    }

    public void shrink() {
        if (this.blinkTime > 0) {
            return;
        }
        if (this.mayor) {
            this.mayor = false;
            this.armed = false;
            if (!this.crouch) {
                this.bounds.y += 12;
                this.locY = this.bounds.y;
                this.bounds.height = 12;
            } else {
                this.crouch = false;
            }
            this.updateImg();
            this.blinkTime = 80;
            MVBOffMario.gp.showMessage("BAJARED!", Color.red, 24, 3000L);
        } else {
            this.die();
        }
    }

    public boolean isSmall() {
        return this.bounds.height == 12;
    }

    public void crouch() {
        if (this.mayor && !this.crouch) {
            if (this.bounds.height == 24) {
                this.bounds.y += 12;
                this.locY = this.bounds.y;
                this.bounds.height = 12;
            }
            this.crouch = true;
        }
    }

    public void standUp() {
        if (this.mayor && this.crouch) {
            if (this.bounds.height == 12) {
                this.bounds.y -= 12;
                this.locY = this.bounds.y;
                this.bounds.height = 24;
            }
            this.crouch = false;
        }
    }

    public void updateImg() {
        this.img = this.duck || this.crouch ? (this.mayor && suit ? GMedia.getImage("Mbigduck") : GMedia.getImage("Mduck")) : (this.mayor ? (this.getVelY() != 0.0 ? GMedia.getImage(suit ? "MbigJ" : "MnosuitJ") : (this.getVelX() > 0.0 ? GMedia.getImage(suit ? "MbigR" : "MnosuitR") : (this.getVelX() < 0.0 ? GMedia.getImage(suit ? "MbigL" : "MnosuitL") : GMedia.getImage(suit ? "Mbig" : "Mnosuit")))) : (this.getVelY() != 0.0 ? GMedia.getImage("MsmallJ") : (this.getVelX() > 0.0 ? GMedia.getImage("MsmallR") : (this.getVelX() < 0.0 ? GMedia.getImage("MsmallL") : GMedia.getImage("Msmall")))));
    }

    public void duckSelf() {
        this.color = Color.red.darker();
        if (this.mayor && this.bounds.height == 24) {
            this.bounds.y += 12;
            this.locY = this.bounds.y;
            this.bounds.height = 12;
        }
        if (this.getVelX() < 0.0) {
            this.accelX = 0.2;
            this.stopping = true;
        } else if (this.getVelX() > 0.0) {
            this.accelX = -0.2;
            this.stopping = true;
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.blink) {
            return;
        }
        if (!this.duck && !this.crouch && this.mayor && headImg != null) {
            graphics2D.drawImage(this.img, (this.bounds.x + GCanvas.offX) * Map.MULT, (this.bounds.y + GCanvas.offY + this.bounds.height / 2) * Map.MULT, this.bounds.width * Map.MULT, this.bounds.height / 2 * Map.MULT, MVBOffMario.gp);
            graphics2D.drawImage(headImg, (this.bounds.x + GCanvas.offX) * Map.MULT, (this.bounds.y + GCanvas.offY) * Map.MULT, this.bounds.width * Map.MULT, this.bounds.height / 2 * Map.MULT, MVBOffMario.gp);
        } else {
            super.paint(graphics2D);
        }
    }

    public void update() {
        if (this.blinkTime > 0) {
            --this.blinkTime;
            this.blink = !this.blink;
        } else {
            this.blink = false;
        }
        if (this.reload > 0) {
            --this.reload;
        }
        boolean bl = this.getVelY() != 0.0;
        int n = this.bounds.x / 12;
        int n2 = this.bounds.y / 12;
        int n3 = (this.bounds.y + this.bounds.height - 1) / 12;
        int n4 = (this.bounds.x + this.bounds.width - 1) / 12;
        if (this.right) {
            if (!this.duck) {
                this.accelX = 0.2;
                this.stopping = false;
            }
        } else if (!this.left && !bl && this.getVelX() > 0.0) {
            this.accelX = -0.3;
            this.stopping = true;
        }
        if (this.left) {
            if (!this.duck) {
                this.accelX = -0.2;
                this.stopping = false;
            }
        } else if (!this.right && !bl && this.getVelX() < 0.0) {
            this.accelX = 0.3;
            this.stopping = true;
        }
        if (this.jump) {
            if (!bl) {
                if (MVBOffMario.map.checkDoor(n, n3) || MVBOffMario.map.checkDoor(n4, n3)) {
                    this.accelY = 0.0;
                    this.accelX = 0.0;
                    this.velY = 0.0;
                    this.velX = 0.0;
                } else {
                    this.accelY = -9.0;
                    GMedia.playSound("jump");
                    this.duckJump = this.duck;
                    this.duck = false;
                }
            } else if (this.duckJump) {
                this.accelY = -5.0;
                this.duckJump = false;
            }
        }
        if (this.duck) {
            this.duckSelf();
        } else {
            this.color = Color.red;
            if (this.mayor && (MVBOffMario.map.isRoof(n, n2 - 1) || MVBOffMario.map.isRoof(n4, n2 - 1)) && (MVBOffMario.map.isFloor(n, n2 + 1) || MVBOffMario.map.isFloor(n4, n2 + 1))) {
                this.crouch();
            } else if (this.mayor && this.bounds.height != 24) {
                this.bounds.y -= 12;
                this.locY = this.bounds.y;
                this.bounds.height = 24;
                if (this.fly) {
                    this.accelY = -5.0;
                }
            }
        }
        if (this.run && !this.crouch) {
            this.maxVelX = 4.0;
        } else {
            double d = this.maxVelX = this.crouch ? 1.0 : 2.0;
        }
        if (this.fire && this.armed && this.reload == 0) {
            Shot shot = new Shot(this.bounds.x + (this.velX < 0.0 ? 0 : this.bounds.width), this.bounds.y + this.bounds.height / 2, this.velX + (double)(this.velX < 0.0 ? -5 : 5), this.velY, false);
            MVBOffMario.gen.addSprite(shot);
            this.reload = 20;
        }
        this.updateImg();
        int n5 = this.bounds.x;
        int n6 = this.bounds.y;
        super.update();
        if (this.genID == -1) {
            return;
        }
        this.accelY = 0.0;
        if (this.crouch) {
            n = this.bounds.x / 12;
            n2 = this.bounds.y / 12;
            n3 = (this.bounds.y + this.bounds.height - 1) / 12;
            n4 = (this.bounds.x + this.bounds.width - 1) / 12;
            if (!MVBOffMario.map.isRoof(n, n2 - 1) && !MVBOffMario.map.isRoof(n4, n2 - 1)) {
                this.standUp();
            }
        }
        MVBOffMario.gen.detectCollision(this, n5, n6);
        MVBOffMario.gp.adjustVisibleToMario();
    }

    public void passLevel() {
        super.die();
        MVBOffMario.gen.killAll();
        if (++MVBOffMario.level > 24) {
            MVBOffMario.gameWon();
            return;
        }
        MVBOffMario.gp.map = MVBOffMario.map = new Map("levels/level" + MVBOffMario.level + ".txt");
        MVBOffMario.map.activate(0, 0, 19, MVBOffMario.map.mapHeight());
        if (this.mayor) {
            MVBOffMario.mario.grow();
        }
        if (this.armed) {
            MVBOffMario.mario.grow();
        }
        MVBOffMario.gp.adjustVisibleToMario();
        MVBOffMario.gp.showMessage(MVBOffMario.map.getSubLevMsg(), Color.yellow, 10);
        GMedia.playSound("passlevel");
        MVBOffMario.initialPause = true;
        MVBOffMario.gen.stop();
    }

    public void die() {
        super.die();
        MVBOffMario.gen.killAll();
        if (--MVBOffMario.lives <= 0) {
            MVBOffMario.gameOver();
            return;
        }
        GMedia.playSound("death");
        if (this.lifespan <= 0) {
            MVBOffMario.gp.showMessage("\u00b0Mision Terminado!", new Color(160, 0, 0), 12, 3000L);
        } else {
            MVBOffMario.gp.showMessage("\u00b0M U E R T O!", new Color(160, 0, 0), 18, 3000L);
        }
        System.out.println("MUERTO cellXYZ=" + this.cellX + "," + this.cellY + "," + this.cellZ);
        if (this.cellX > 19 || this.cellZ != 0) {
            System.out.println("\tSave Point");
            MVBOffMario.map.restoreMapState(this.cellZ);
            MVBOffMario.map.activate(this.cellX - 4, 0, 19, MVBOffMario.map.mapHeight());
            MVBOffMario.mario.lifespan = this.saveLifespan;
            MVBOffMario.mario.saveLifespan = this.saveLifespan;
            MVBOffMario.mario.blinkTime = 80;
            MVBOffMario.mario.cellX = this.cellX;
            MVBOffMario.mario.cellY = this.cellY;
            MVBOffMario.mario.cellZ = this.cellZ;
        } else {
            System.out.println("\tReset Map");
            MVBOffMario.map.restoreMapState(this.cellZ);
            MVBOffMario.map.activate(0, 0, 19, MVBOffMario.map.mapHeight());
        }
        MVBOffMario.gp.adjustVisibleToMario();
    }

    public void pressedRight() {
        this.right = true;
    }

    public void releasedRight() {
        this.right = false;
    }

    public void pressedLeft() {
        this.left = true;
    }

    public void releasedLeft() {
        this.left = false;
    }

    public void pressedJump() {
        this.jump = true;
    }

    public void releasedJump() {
        this.jump = false;
    }

    public void pressedDuck() {
        this.duck = true;
    }

    public void releasedDuck() {
        this.duck = false;
    }

    public void pressedRun() {
        this.run = true;
    }

    public void releasedRun() {
        this.run = false;
    }

    public void pressedFire() {
        this.fire = true;
    }

    public void releasedFire() {
        this.fire = false;
    }

    public boolean isUp() {
        return this.jump;
    }

    public boolean isDown() {
        return this.duck;
    }
}

