/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;

public class Sprite {
    public boolean tangible = true;
    public boolean bops = MVBOffMario.BOPS;
    public Rectangle bounds;
    public int genID = -1;
    protected Image img = null;
    protected Color color = Color.yellow;
    public int cellX;
    public int cellY;
    public int cellZ;
    private char cellType;
    protected double maxVelX = 2.0;
    protected double maxVelY = 10.0;
    protected double gravity = 0.8;
    static boolean TEMPFLOOR = false;
    protected double bounce = 0.0;
    protected double accelX = 0.0;
    protected double accelY = 0.0;
    protected boolean stopping = false;
    protected double locX = 0.0;
    protected double locY = 0.0;
    protected double velX = 0.0;
    protected double velY = 0.0;
    public int lifespan = -1;

    public Sprite(char c, int n, int n2, int n3) {
        this.bounds = new Rectangle(n * 12, n2 * 12, 12, 12);
        this.locX = this.bounds.x;
        this.locY = this.bounds.y;
        this.cellX = n;
        this.cellY = n2;
        this.cellZ = n3;
        this.cellType = c;
    }

    public Sprite(char c, int n, int n2, int n3, int n4, int n5) {
        this.bounds = new Rectangle(n * 12, n2 * 12, n4, n5);
        this.locX = this.bounds.x;
        this.locY = this.bounds.y;
        this.cellX = n;
        this.cellY = n2;
        this.cellZ = n3;
        this.cellType = c;
    }

    public Sprite(char c, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.bounds = new Rectangle(n4, n5, n6, n7);
        this.locX = this.bounds.x;
        this.locY = this.bounds.y;
        this.cellX = n;
        this.cellY = n2;
        this.cellZ = n3;
        this.cellType = c;
    }

    public void update() {
        if (this.lifespan > 0 && --this.lifespan <= 0) {
            this.die();
            return;
        }
        if (this.stopping) {
            if ((this.accelX + this.velX) / this.velX < 0.0) {
                this.accelX = 0.0;
                this.velX = 0.0;
                this.stopping = false;
            } else {
                this.velX += this.accelX;
            }
        } else {
            this.velX += this.accelX;
        }
        this.velY += this.accelY + this.gravity;
        if (this.velX > this.maxVelX) {
            this.velX = this.maxVelX;
        }
        if (this.velX < -this.maxVelX) {
            this.velX = -this.maxVelX;
        }
        if (this.velY > this.maxVelY) {
            this.velY = this.maxVelY;
        }
        if (this.velY < -this.maxVelY) {
            this.velY = -this.maxVelY;
        }
        int n = this.bounds.x;
        int n2 = this.bounds.y;
        this.locX += this.velX;
        this.locY += this.velY;
        if (this.locY > (double)(MVBOffMario.map.mapHeight() * 12)) {
            if (TEMPFLOOR) {
                this.velY = 0.0;
                this.locY = MVBOffMario.map.mapHeight() * 11;
            } else {
                this.die();
                return;
            }
        }
        if (this.locX < 0.0) {
            this.locX = 0.0;
        }
        if (this.tangible && this.locX + (double)this.bounds.width > (double)(MVBOffMario.map.mapWidth() * 12)) {
            this.locX = MVBOffMario.map.mapWidth() * 12 - this.bounds.width;
        }
        this.bounds.x = (int)this.locX;
        this.bounds.y = (int)(this.locY + 0.5);
        if (this.tangible) {
            Map.HitInfo hitInfo = null;
            Map.HitInfo hitInfo2 = null;
            if (this.velX > 0.0) {
                hitInfo = MVBOffMario.map.checkRightWall(this.bounds, this.bops, this.velY > 0.0, n, n2);
            } else if (this.velX < 0.0) {
                hitInfo = MVBOffMario.map.checkLeftWall(this.bounds, this.bops, this.velY > 0.0, n, n2);
            }
            if (this.velY > 0.0) {
                hitInfo2 = MVBOffMario.map.checkFloor(this.bounds, this.bops, this.velX > 0.0, n, n2);
            } else if (this.velY < 0.0) {
                hitInfo2 = MVBOffMario.map.checkRoof(this.bounds, this.bops, this.velX > 0.0, n, n2);
            }
            if (hitInfo != null && hitInfo.type == Map.HitInfo.SECOND && hitInfo2 != null && hitInfo2.newLoc != Map.HitInfo.NOT_SOLID) {
                this.bounds.y = hitInfo2.newLoc;
                this.locY = this.bounds.y;
                this.velY = -this.bounce * this.velY + (this.velY < 0.0 ? 0.001 : 0.0);
                hitInfo = null;
            }
            if (hitInfo != null && hitInfo.newLoc != Map.HitInfo.NOT_SOLID) {
                this.bounds.x = hitInfo.newLoc;
                this.locX = this.bounds.x;
                this.velX = 0.0;
                if (hitInfo.type == Map.HitInfo.FIRST && (hitInfo2 == null || hitInfo2.type == Map.HitInfo.SECOND)) {
                    hitInfo2 = null;
                }
            }
            if (hitInfo2 != null && hitInfo2.newLoc != Map.HitInfo.NOT_SOLID) {
                this.bounds.y = hitInfo2.newLoc;
                this.locY = this.bounds.y;
                this.velY = -this.bounce * this.velY + (this.velY < 0.0 ? 0.001 : 0.0);
            }
            if (hitInfo != null && hitInfo.actX != Map.HitInfo.NO_ACTION) {
                MVBOffMario.map.doAction(hitInfo);
            }
            if (hitInfo2 != null && hitInfo2.actX != Map.HitInfo.NO_ACTION) {
                MVBOffMario.map.doAction(hitInfo2);
            }
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.img != null) {
            graphics2D.drawImage(this.img, (this.bounds.x + GCanvas.offX) * Map.MULT, (this.bounds.y + GCanvas.offY) * Map.MULT, this.bounds.width * Map.MULT, this.bounds.height * Map.MULT, MVBOffMario.gp);
        } else {
            graphics2D.setColor(this.color);
            graphics2D.fillRect((this.bounds.x + GCanvas.offX) * Map.MULT, (this.bounds.y + GCanvas.offY) * Map.MULT, this.bounds.width * Map.MULT, this.bounds.height * Map.MULT);
        }
    }

    public void die() {
        MVBOffMario.gen.removeSprite(this);
        if (this.cellType != '\u0000') {
            MVBOffMario.map.restoreSpawn(this.cellType, this.cellX, this.cellY, this.cellZ);
        }
    }

    public double getVelX() {
        return this.velX;
    }

    public double getVelY() {
        return this.velY;
    }

    public void moveTo(int n, int n2) {
        this.bounds.x = n;
        this.locX = this.bounds.x;
        this.bounds.y = n2;
        this.locY = this.bounds.y;
    }
}

