/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Point;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import lib.webj2.gui.AskDialog;

public class GameFrame
extends Frame
implements ActionListener {
    Main con;
    boolean turn = false;
    boolean gameOver = false;
    final boolean BLACK = false;
    final boolean WHITE = true;
    TileCanvas tileC;
    Label statL = new Label("Black: 2     White: 2     *Waiting for ready*");
    TextField chatTF = new TextField("Type in-game chat here", 30);
    MouseListener mouseL = new 1();

    public GameFrame(Main mn) {
        this.con = mn;
        this.setTitle("MyOthelo");
        this.tileC = new TileCanvas(this.con.width, this.con.height);
        this.tileC.addMouseListener(this.mouseL);
        this.chatTF.addActionListener(new 2());
        this.add("North", this.chatTF);
        this.add("Center", this.tileC);
        this.add("South", this.statL);
        MenuBar mbar = new MenuBar();
        Menu game = new Menu("Game");
        MenuItem m = new MenuItem("New Game", new MenuShortcut(78));
        m.addActionListener(this);
        game.add(m);
        m = new MenuItem("Abort Game", new MenuShortcut(65));
        m.addActionListener(this);
        game.add(m);
        game.addSeparator();
        m = new MenuItem("Exit", new MenuShortcut(88));
        m.addActionListener(this);
        game.add(m);
        mbar.add(game);
        this.setMenuBar(mbar);
        this.chatTF.selectAll();
    }

    public void actionPerformed(ActionEvent ae) {
        String args = ((MenuItem)ae.getSource()).getLabel();
        if (args.equals("New Game")) {
            AskDialog ad = new AskDialog((Frame)this, "Abort Game", "Are you sure you want to quit this game?", new Object[]{"Cancel", "Abort Game"}, 1);
            if (ad.ask().equals("Abort Game")) {
                this.gameOver();
                this.doGameOverClick();
            }
        } else if (args.equals("Abort Game")) {
            AskDialog ad = new AskDialog((Frame)this, "Abort Game", "Are you sure you want to quit this game?", new Object[]{"Cancel", "Abort Game"}, 1);
            if (ad.ask().equals("Abort Game")) {
                this.gameOver();
            }
        } else if (args.equals("Exit")) {
            this.con.disconnect();
            this.dispose();
            System.exit(0);
        }
    }

    public void startGame() {
        this.whiteTurn();
    }

    public void gameOver() {
        this.con.disconnect();
        this.gameOver = true;
        this.showStatus("*Game Over*");
        int w = this.tileC.getWhiteCount();
        int b = this.tileC.getBlackCount();
        if (w > b) {
            this.tileC.setMessage("White Wins!\n \nClick to start a new game");
        } else if (b > w) {
            this.tileC.setMessage("Black Wins!\n \nClick to start a new game");
        } else if (b == w) {
            this.tileC.setMessage("It's a Tie!\n \nClick to start a new game");
        }
    }

    public void doGameOverClick() {
        this.con.disconnect();
        SetupFrame sf = new SetupFrame(this.con);
        sf.addWindowListener(this.con.winL);
        sf.pack();
        Dimension s = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension d = sf.getSize();
        ((Component)sf).setLocation((s.width - d.width) / 2, (s.height - d.height) / 2);
        this.con.CHEATSOFF = false;
        this.con.CHEAT = false;
        this.con.setGameListener(null);
        ((Component)this).hide();
        this.dispose();
        sf.show();
    }

    public void doTurnClick(Point loc, boolean cheat) {
    }

    public void showStatus(String stat) {
        this.statL.setText("Black: " + this.tileC.getBlackCount() + "     White: " + this.tileC.getWhiteCount() + "     " + stat);
    }

    public void whiteTurn() {
        this.showStatus("*White's Turn*");
        this.turn = true;
    }

    public void blackTurn() {
        this.showStatus("*Black's Turn*");
        this.turn = false;
    }

    private final class 1
    extends MouseAdapter {
        public void mouseClicked(MouseEvent me) {
            if (GameFrame.this.gameOver) {
                GameFrame.this.doGameOverClick();
            } else if (me.isAltDown() && me.isControlDown()) {
                if (me.isShiftDown() && GameFrame.this.con.CHEAT) {
                    GameFrame.this.doTurnClick(me.getPoint(), true);
                } else {
                    GameFrame.this.gameOver();
                }
            } else {
                GameFrame.this.doTurnClick(me.getPoint(), false);
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            GameFrame.this.con.sendMsg(GameFrame.this.chatTF.getText());
            ((TextComponent)GameFrame.this.chatTF).setText("");
        }

        /* synthetic */ 2() {
        }
    }
}

