/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.Toolkit;

public class NetGameFrame
extends GameFrame
implements GameListener,
ReadyListener {
    boolean hosting = false;
    boolean color = false;

    public NetGameFrame(Main m, boolean hosting) {
        super(m);
        this.hosting = hosting;
    }

    public void startGame() {
        if (this.hosting) {
            this.con.checkReady(this);
        } else if (this.con.sendReady()) {
            this.con.checkReady(this);
        } else {
            this.con.disconnect();
            Toolkit.getDefaultToolkit().beep();
            this.gameOver();
            this.showStatus("*LOST CONNECTION*");
        }
    }

    public void doTurnClick(Point loc, boolean cheat) {
        if (this.turn != this.color) {
            return;
        }
        Point t = this.tileC.getTileAt(loc.x, loc.y);
        if (!(this.tileC.getStateOf(t) == 0 && this.tileC.hasNeighbor(t) || cheat)) {
            return;
        }
        this.con.sendTurn(t.x, t.y);
        this.tileC.setStateOf(t, !this.color ? 1 : 2);
        this.tileC.doFlipsFor(t);
        if (this.tileC.isFull()) {
            this.gameOver();
        } else if (!this.color) {
            this.whiteTurn();
        } else {
            this.blackTurn();
        }
    }

    public void recieveTurn(int tx, int ty) {
        Point t = new Point(tx, ty);
        this.tileC.setStateOf(t, this.color ? 1 : 2);
        this.tileC.doFlipsFor(t);
        if (this.tileC.isFull()) {
            this.gameOver();
        } else if (this.color) {
            this.whiteTurn();
        } else {
            this.blackTurn();
        }
    }

    public void recieveChat(String msg) {
        if (this.con.LOGGING) {
            System.out.println("got chat: " + msg);
        }
        this.tileC.addChat(msg);
    }

    public void recieveOther(int o) {
        if (this.con.LOGGING) {
            System.out.println("got other: " + o);
        }
        if (o == -1234) {
            this.con.CHEAT = false;
        } else if (o == -4321) {
            this.whiteTurn();
        } else if (o == -5432) {
            this.blackTurn();
        } else if (o == -909) {
            this.con.CHEATSOFF = true;
            this.con.CHEAT = false;
        }
    }

    public void ready() {
        if (this.hosting && !this.con.sendReady()) {
            this.con.disconnect();
            Toolkit.getDefaultToolkit().beep();
            this.gameOver();
            this.showStatus("*LOST CONNECTION*");
        }
        this.con.setGameListener(this);
        this.con.startReader();
        if (this.hosting) {
            this.color = true;
            this.setTitle("MyOthelo - White");
        } else {
            this.color = false;
            this.setTitle("MyOthelo - Black");
        }
        this.whiteTurn();
    }

    public void recieveError() {
        this.con.disconnect();
        Toolkit.getDefaultToolkit().beep();
        this.gameOver();
        this.showStatus("*LOST CONNECTION*");
    }
}

