/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Toolkit;
import java.util.StringTokenizer;

public class TileCanvas
extends Canvas {
    int gridWidth;
    int gridHeight;
    int[][] tiles;
    public static final int EMPTY = 0;
    public static final int BLACK = 1;
    public static final int WHITE = 2;
    Image emptyImg = null;
    Image blackImg = null;
    Image whiteImg = null;
    int tileWidth = 40;
    int tileHeight = 40;
    String message = null;
    String chat = null;

    public TileCanvas(int width, int height) {
        this.gridWidth = width;
        this.gridHeight = height;
        if (this.gridWidth < 6) {
            this.gridWidth = 6;
        }
        if (this.gridHeight < 6) {
            this.gridHeight = 6;
        }
        this.tiles = new int[this.gridWidth][this.gridHeight];
        int x = 0;
        while (x < this.gridWidth) {
            int y = 0;
            while (y < this.gridHeight) {
                this.tiles[x][y] = 0;
                ++y;
            }
            ++x;
        }
        int sx = this.gridWidth / 2 - 1;
        int sy = this.gridHeight / 2 - 1;
        this.tiles[sx][sy] = 2;
        this.tiles[sx + 1][sy] = 1;
        this.tiles[sx][sy + 1] = 1;
        this.tiles[sx + 1][sy + 1] = 2;
        MediaTracker mt = new MediaTracker(this);
        this.emptyImg = Toolkit.getDefaultToolkit().getImage("images/empty.gif");
        this.whiteImg = Toolkit.getDefaultToolkit().getImage("images/white.gif");
        this.blackImg = Toolkit.getDefaultToolkit().getImage("images/black.gif");
        mt.addImage(this.emptyImg, 0);
        mt.addImage(this.blackImg, 1);
        mt.addImage(this.whiteImg, 2);
        try {
            mt.waitForAll();
        }
        catch (InterruptedException interruptedException) {}
    }

    public void update(Graphics g) {
        Dimension size = this.getSize();
        Image buffer = this.createImage(size.width, size.height);
        Graphics bg = buffer.getGraphics();
        this.tileWidth = size.width / this.gridWidth;
        this.tileHeight = size.height / this.gridHeight;
        if (this.tileWidth < this.tileHeight) {
            this.tileHeight = this.tileWidth;
        } else {
            this.tileWidth = this.tileHeight;
        }
        this.paint(bg);
        bg.dispose();
        g.drawImage(buffer, 0, 0, size.width, size.height, this);
    }

    public void paint(Graphics g) {
        int y;
        int x;
        int lineHeight;
        String token;
        StringTokenizer st;
        Dimension size;
        FontMetrics fm;
        int x2 = 0;
        while (x2 < this.gridWidth) {
            int y2 = 0;
            while (y2 < this.gridHeight) {
                switch (this.tiles[x2][y2]) {
                    case 0: {
                        if (this.emptyImg != null) {
                            g.drawImage(this.emptyImg, x2 * this.tileWidth, y2 * this.tileHeight, this.tileWidth, this.tileHeight, this);
                            break;
                        }
                        g.setColor(Color.lightGray);
                        g.fillRect(x2 * this.tileWidth, y2 * this.tileHeight, this.tileWidth, this.tileHeight);
                        break;
                    }
                    case 1: {
                        if (this.emptyImg != null) {
                            g.drawImage(this.blackImg, x2 * this.tileWidth, y2 * this.tileHeight, this.tileWidth, this.tileHeight, this);
                            break;
                        }
                        g.setColor(Color.black);
                        g.fillRect(x2 * this.tileWidth, y2 * this.tileHeight, this.tileWidth, this.tileHeight);
                        break;
                    }
                    case 2: {
                        if (this.emptyImg != null) {
                            g.drawImage(this.whiteImg, x2 * this.tileWidth, y2 * this.tileHeight, this.tileWidth, this.tileHeight, this);
                            break;
                        }
                        g.setColor(Color.white);
                        g.fillRect(x2 * this.tileWidth, y2 * this.tileHeight, this.tileWidth, this.tileHeight);
                        break;
                    }
                }
                ++y2;
            }
            ++x2;
        }
        if (this.message != null) {
            Font f = new Font("SansSerif", 1, 18);
            g.setFont(f);
            g.setColor(Color.red);
            fm = g.getFontMetrics(f);
            size = this.getSize();
            st = new StringTokenizer(this.message, "\n");
            token = "";
            lineHeight = fm.getHeight();
            x = 0;
            y = (size.height - lineHeight * st.countTokens()) / 2;
            while (st.hasMoreTokens()) {
                token = st.nextToken();
                x = (size.width - fm.stringWidth(token)) / 2;
                g.drawString(token, x, y);
                y += lineHeight;
            }
        }
        if (this.chat != null) {
            Font f = new Font("SansSerif", 1, 12);
            g.setFont(f);
            g.setColor(new Color(10, 150, 10));
            fm = g.getFontMetrics(f);
            size = this.getSize();
            st = new StringTokenizer(this.chat, "\n");
            token = "";
            lineHeight = fm.getHeight();
            x = 5;
            y = lineHeight + 5;
            while (st.hasMoreTokens()) {
                token = st.nextToken();
                g.drawString(token, x, y);
                y += lineHeight;
            }
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.gridWidth * 40, this.gridHeight * 40);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.gridWidth * 20, this.gridHeight * 20);
    }

    public Dimension getMaximumSize() {
        return new Dimension(this.gridWidth * 100, this.gridHeight * 100);
    }

    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.repaint();
    }

    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.repaint();
    }

    public void setMessage(String s) {
        this.message = s;
        this.repaint();
    }

    public void addChat(String s) {
        this.chat = this.chat == null ? s : String.valueOf(this.chat) + "\n" + s;
        Thread t = new Thread(new 1());
        t.start();
        this.repaint();
    }

    public synchronized void removeTopChat() {
        int s = this.chat.indexOf("\n");
        if (s == -1) {
            this.chat = null;
            this.repaint();
            return;
        }
        this.chat = this.chat.substring(s + 1, this.chat.length());
        this.repaint();
    }

    public int getStateOf(Point t) {
        return this.tiles[t.x][t.y];
    }

    public void setStateOf(Point t, int s) {
        this.tiles[t.x][t.y] = s;
        this.repaint();
    }

    public int getBlackCount() {
        int c = 0;
        int x = 0;
        while (x < this.gridWidth) {
            int y = 0;
            while (y < this.gridHeight) {
                if (this.tiles[x][y] == 1) {
                    ++c;
                }
                ++y;
            }
            ++x;
        }
        return c;
    }

    public int getWhiteCount() {
        int c = 0;
        int x = 0;
        while (x < this.gridWidth) {
            int y = 0;
            while (y < this.gridHeight) {
                if (this.tiles[x][y] == 2) {
                    ++c;
                }
                ++y;
            }
            ++x;
        }
        return c;
    }

    public boolean isFull() {
        int c = 0;
        int x = 0;
        while (x < this.gridWidth) {
            int y = 0;
            while (y < this.gridHeight) {
                if (this.tiles[x][y] == 0) {
                    ++c;
                }
                ++y;
            }
            ++x;
        }
        return c == 0;
    }

    public Point getTileAt(int sx, int sy) {
        Dimension size = this.getSize();
        this.tileWidth = size.width / this.gridWidth;
        this.tileHeight = size.height / this.gridHeight;
        if (this.tileWidth < this.tileHeight) {
            this.tileHeight = this.tileWidth;
        } else {
            this.tileWidth = this.tileHeight;
        }
        Point p = new Point(sx / this.tileWidth, sy / this.tileHeight);
        if (p.x > this.gridWidth - 1) {
            p.x = this.gridWidth - 1;
        }
        if (p.x < 0) {
            p.x = 0;
        }
        if (p.y > this.gridHeight - 1) {
            p.y = this.gridHeight - 1;
        }
        if (p.y < 0) {
            p.y = 0;
        }
        return p;
    }

    public boolean hasNeighbor(Point t) {
        return t.y > 0 && this.tiles[t.x][t.y - 1] != 0 || t.x < this.gridWidth - 1 && t.y > 0 && this.tiles[t.x + 1][t.y - 1] != 0 || t.x < this.gridWidth - 1 && this.tiles[t.x + 1][t.y] != 0 || t.x < this.gridWidth - 1 && t.y < this.gridHeight - 1 && this.tiles[t.x + 1][t.y + 1] != 0 || t.y < this.gridHeight - 1 && this.tiles[t.x][t.y + 1] != 0 || t.x > 0 && t.y < this.gridHeight - 1 && this.tiles[t.x - 1][t.y + 1] != 0 || t.x > 0 && this.tiles[t.x - 1][t.y] != 0 || t.x > 0 && t.y > 0 && this.tiles[t.x - 1][t.y - 1] != 0;
    }

    public void doFlipsFor(Point t) {
        int color = this.tiles[t.x][t.y];
        int x = t.x;
        int y = t.y;
        while (--y >= 0) {
            if (this.tiles[x][y] == 0) break;
            if (this.tiles[x][y] != color) continue;
            while (++y < t.y) {
                int n = this.tiles[x][y] = color == 1 ? 1 : 2;
            }
            break block0;
        }
        y = t.y;
        while (++y < this.gridHeight) {
            if (this.tiles[x][y] == 0) break;
            if (this.tiles[x][y] != color) continue;
            while (--y > t.y) {
                int n = this.tiles[x][y] = color == 1 ? 1 : 2;
            }
            break block2;
        }
        y = t.y;
        while (++x < this.gridWidth) {
            if (this.tiles[x][y] == 0) break;
            if (this.tiles[x][y] != color) continue;
            while (--x > t.x) {
                int n = this.tiles[x][y] = color == 1 ? 1 : 2;
            }
            break block4;
        }
        x = t.x;
        while (--x >= 0) {
            if (this.tiles[x][y] == 0) break;
            if (this.tiles[x][y] != color) continue;
            while (++x < t.x) {
                int n = this.tiles[x][y] = color == 1 ? 1 : 2;
            }
            break block6;
        }
        x = t.x;
        while (--y >= 0 && ++x < this.gridWidth) {
            if (this.tiles[x][y] == 0) break;
            if (this.tiles[x][y] != color) continue;
            while (++y < t.y && --x > t.x) {
                int n = this.tiles[x][y] = color == 1 ? 1 : 2;
            }
            break block8;
        }
        x = t.x;
        y = t.y;
        while (--y >= 0 && --x >= 0) {
            if (this.tiles[x][y] == 0) break;
            if (this.tiles[x][y] != color) continue;
            while (++y < t.y && ++x < t.x) {
                int n = this.tiles[x][y] = color == 1 ? 1 : 2;
            }
            break block10;
        }
        x = t.x;
        y = t.y;
        while (++y < this.gridHeight && ++x < this.gridWidth) {
            if (this.tiles[x][y] == 0) break;
            if (this.tiles[x][y] != color) continue;
            while (--y > t.y && --x > t.x) {
                int n = this.tiles[x][y] = color == 1 ? 1 : 2;
            }
            break block12;
        }
        x = t.x;
        y = t.y;
        while (++y < this.gridHeight && --x >= 0) {
            if (this.tiles[x][y] == 0) break;
            if (this.tiles[x][y] != color) continue;
            while (--y > t.y && ++x < t.x) {
                int n = this.tiles[x][y] = color == 1 ? 1 : 2;
            }
            break block14;
        }
        this.repaint();
    }

    private final class 1
    implements Runnable {
        public void run() {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
            TileCanvas.this.removeTopChat();
        }

        /* synthetic */ 1() {
        }
    }
}

