/*
 * Decompiled with CFR 0.152.
 */
package lib.webj2.gui;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.StringTokenizer;

public class StaticTextArea
extends Canvas {
    private String text = "";
    private double tabInches = 0.5;
    private double lineSpacing = 1.0;
    private boolean wrap = true;
    private double topMargin = 0.0;
    private double bottomMargin = 0.0;
    private double leftMargin = 0.0;
    private double rightMargin = 0.0;
    private int width = 150;
    private int height = 50;
    private boolean autoresize = true;
    private int pixelsPI = Toolkit.getDefaultToolkit().getScreenResolution();

    public StaticTextArea() {
    }

    public StaticTextArea(String string, boolean bl) {
        this.autoresize = bl;
        this.setText(string);
    }

    public StaticTextArea(String string) {
        this.setText(string);
    }

    public StaticTextArea(String string, int n) {
        this.width = n;
        this.setText(string);
    }

    public StaticTextArea(String string, int n, boolean bl) {
        this.width = n;
        this.autoresize = bl;
        this.setText(string);
    }

    public StaticTextArea(String string, int n, int n2, boolean bl) {
        this.width = n;
        this.height = n2;
        this.autoresize = bl;
        this.setText(string);
    }

    public void update(Graphics graphics) {
        Dimension dimension = this.getSize();
        Image image = this.createImage(dimension.width, dimension.height);
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        Graphics graphics2 = image.getGraphics();
        this.paint(graphics2);
        graphics2.dispose();
        graphics.drawImage(image, 0, 0, dimension.width, dimension.height, this);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.getForeground());
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\n");
        String string = "";
        this.getSize();
        int n = (int)((double)fontMetrics.getHeight() * this.lineSpacing);
        int n2 = (int)(this.topMargin * (double)this.pixelsPI);
        int n3 = (int)(this.leftMargin * (double)this.pixelsPI);
        int n4 = (int)((double)this.width - this.rightMargin * (double)this.pixelsPI);
        int n5 = (int)(this.tabInches * (double)this.pixelsPI);
        if (n5 == 0) {
            n5 = 10;
            System.out.println("tabPixels was 0 pixelsPI=" + this.pixelsPI);
        }
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            if (!this.wrap) {
                graphics.drawString(string, n3, n2);
                n2 += n;
                continue;
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string, " ", true);
            String string2 = "";
            int n6 = n3;
            int n7 = fontMetrics.stringWidth(" ");
            boolean bl = false;
            while (stringTokenizer2.hasMoreTokens()) {
                string2 = stringTokenizer2.nextToken();
                int n8 = fontMetrics.stringWidth(string2);
                if (string2.endsWith("\t")) {
                    bl = true;
                    string2 = string2.substring(0, string2.length() - 1);
                }
                if (string2.equals(" ")) {
                    n6 += n7;
                } else if (n6 + n8 < n4) {
                    graphics.drawString(string2, n6, n2);
                    n6 += n8;
                } else {
                    n6 = n3;
                    graphics.drawString(string2, n6, n2 += n);
                    n6 += this.width;
                }
                if (!bl) continue;
                n6 = (n6 + n5) / n5 * n5;
                try {
                    stringTokenizer2.nextToken();
                }
                catch (Exception exception) {
                    System.out.println("Caught an exception in nextToken(): " + exception);
                }
            }
            n2 += n;
        }
    }

    protected void validateData() {
        if (!this.autoresize) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            return;
        }
        graphics.setFont(this.getFont());
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        int n = (int)((double)fontMetrics.getHeight() * this.lineSpacing);
        StringTokenizer stringTokenizer = new StringTokenizer(this.text, "\n");
        int n2 = (int)(this.topMargin * (double)this.pixelsPI);
        int n3 = (int)((double)this.width - this.leftMargin * (double)this.pixelsPI - this.rightMargin * (double)this.pixelsPI);
        String string = "";
        while (stringTokenizer.hasMoreTokens()) {
            string = stringTokenizer.nextToken();
            n2 += n;
            int n4 = fontMetrics.stringWidth(string);
            while (n4 > n3) {
                n2 += n;
                n4 -= n3;
            }
        }
        this.height = n2 + (int)this.bottomMargin * this.pixelsPI;
        this.setSize(this.width, this.height);
    }

    public void addNotify() {
        this.validateData();
        super.addNotify();
    }

    public void setText(String string) {
        this.text = string;
        this.text.replace('\r', '\n');
        int n = 0;
        int n2 = 0;
        while ((n2 = this.text.indexOf("\t", n)) != -1) {
            this.text = String.valueOf(this.text.substring(n, n2)) + "\t " + this.text.substring(n2 + 1, this.text.length());
            n = n2 + 1;
        }
        this.validateData();
        this.repaint();
    }

    public synchronized String getText() {
        return this.text;
    }

    public void setInchesPerTab(double d) {
        this.tabInches = d;
    }

    public synchronized double getInchesPerTab() {
        return this.tabInches;
    }

    public void setLineSpacing(double d) {
        this.lineSpacing = d;
        this.validateData();
        this.repaint();
    }

    public synchronized double getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLeftMargin(double d) {
        this.leftMargin = d;
        this.validateData();
        this.repaint();
    }

    public synchronized double getLeftMargin() {
        return this.leftMargin;
    }

    public void setRightMargin(double d) {
        this.rightMargin = d;
        this.validateData();
        this.repaint();
    }

    public synchronized double getRightMargin() {
        return this.rightMargin;
    }

    public void setTopMargin(double d) {
        this.topMargin = d;
        this.validateData();
        this.repaint();
    }

    public synchronized double getTopMargin() {
        return this.topMargin;
    }

    public void setBottomMargin(double d) {
        this.bottomMargin = d;
        this.validateData();
        this.repaint();
    }

    public synchronized double getBottomMargin() {
        return this.bottomMargin;
    }

    public void setWrap(boolean bl) {
        this.wrap = bl;
        this.validateData();
        this.repaint();
    }

    public synchronized boolean getWrap() {
        return this.wrap;
    }

    public void setWidth(int n) {
        this.width = n;
        this.validateData();
        this.repaint();
    }

    public synchronized int getWidth() {
        return this.width;
    }

    public void setAutoResize(boolean bl) {
        this.autoresize = bl;
        this.validateData();
        this.repaint();
    }

    public synchronized boolean getAutoResize() {
        return this.autoresize;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.width, this.height);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.width, this.height);
    }

    public synchronized void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.validateData();
        this.repaint();
    }

    public synchronized void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.validateData();
        this.repaint();
    }
}

