/*
 * Decompiled with CFR 0.152.
 */
package lib.webj2.gui;

import java.awt.CheckboxMenuItem;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.EventListener;
import java.util.StringTokenizer;
import lib.webj2.gui.AskDialog;

public class Tools {
    public static Menu makeMenu(Object object, Object[] objectArray, int[] nArray, EventListener eventListener) {
        Menu menu = null;
        if (object instanceof Menu) {
            menu = (Menu)object;
        } else if (object instanceof String) {
            menu = new Menu((String)object);
        } else {
            return null;
        }
        int n = 0;
        while (n < objectArray.length) {
            MenuItem menuItem;
            if (objectArray[n] instanceof String) {
                menuItem = nArray[n] != 0 ? new MenuItem((String)objectArray[n], new MenuShortcut(nArray[n])) : new MenuItem((String)objectArray[n]);
                if (eventListener != null && eventListener instanceof ActionListener) {
                    menuItem.addActionListener((ActionListener)eventListener);
                }
                menu.add(menuItem);
            } else if (objectArray[n] instanceof CheckboxMenuItem) {
                menuItem = (CheckboxMenuItem)objectArray[n];
                if (nArray[n] != 0) {
                    menuItem.setShortcut(new MenuShortcut(nArray[n]));
                }
                if (eventListener != null && eventListener instanceof ItemListener) {
                    ((CheckboxMenuItem)menuItem).addItemListener((ItemListener)eventListener);
                }
                menu.add(menuItem);
            } else if (objectArray[n] instanceof MenuItem) {
                menuItem = (MenuItem)objectArray[n];
                if (nArray[n] != 0) {
                    menuItem.setShortcut(new MenuShortcut(nArray[n]));
                }
                if (eventListener != null && eventListener instanceof ActionListener) {
                    menuItem.addActionListener((ActionListener)eventListener);
                }
                menu.add(menuItem);
            } else if (objectArray[n] == null) {
                menu.addSeparator();
            }
            ++n;
        }
        return menu;
    }

    public static Dimension getScreenSize() {
        return Toolkit.getDefaultToolkit().getScreenSize();
    }

    public static int inchesToPixels(int n) {
        return Toolkit.getDefaultToolkit().getScreenResolution() * n;
    }

    public static void paintString(String string, int n, int n2, Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            graphics.drawString(stringTokenizer.nextToken(), n, n2);
            n2 += fontMetrics.getHeight();
        }
    }

    public static void paintCenteredString(String string, Rectangle rectangle, Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics(graphics.getFont());
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n = stringTokenizer.countTokens() - 1;
        int n2 = (rectangle.height - n * fontMetrics.getHeight()) / 2;
        String string2 = stringTokenizer.nextToken();
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            n3 = (rectangle.width - fontMetrics.stringWidth(string2)) / 2;
            graphics.drawString(string2, n3, n2);
            n2 += fontMetrics.getHeight();
            string2 = stringTokenizer.nextToken();
            ++n4;
        }
    }

    public static void addToGrid(Component component, Container container, int n, int n2, int n3, int n4, int n5, int n6, double d, double d2, Insets insets) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.fill = n5;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.anchor = n6;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        if (insets != null) {
            gridBagConstraints.insets = insets;
        }
        container.add(component, gridBagConstraints);
    }

    public static void addToGrid(Component component, Container container, int n, int n2, int n3, int n4, GridBagConstraints gridBagConstraints) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        container.add(component, gridBagConstraints);
    }

    public static void showError(Frame frame, String string) {
        AskDialog askDialog = new AskDialog(frame, "Error", string, new String[]{"OK"}, 0);
        askDialog.show();
    }
}

