/*
 * Decompiled with CFR 0.152.
 */
package lib.webj2.util;

import java.io.Serializable;

public class LList
implements Serializable {
    private Link first;
    private Link last = this.mark = new Link();
    private Link effectivelast = null;
    private Link mark;
    private int length = 0;

    public LList() {
        this.first = this.mark;
    }

    public Object getFirst() {
        return this.first.hold;
    }

    public Link getFirstLink() {
        if (this.first.next == null) {
            return null;
        }
        return this.first;
    }

    public Object getLast() {
        return this.effectivelast.hold;
    }

    public Link getLastLink() {
        return this.effectivelast;
    }

    public void setMark(Link link) {
        this.mark = link;
    }

    public void resetMark() {
        this.mark = null;
    }

    public void setMark(int n) {
        this.mark = this.getLinkOfIndex(n);
    }

    public Object getMark() {
        if (this.mark == null) {
            return null;
        }
        return this.mark.hold;
    }

    public Link getMarkLink() {
        return this.mark;
    }

    public int length() {
        return this.length;
    }

    public boolean hasMoreElements() {
        if (this.mark == null) {
            return this.first != this.last;
        }
        return this.mark != this.last;
    }

    public Object getNextElement() {
        if (this.mark == null) {
            this.mark = this.first;
        } else if (this.mark.next != null) {
            this.mark = this.mark.next;
        } else {
            this.mark = null;
            return null;
        }
        return this.mark.hold;
    }

    public Link add(Object object) {
        this.last.hold = object;
        this.last.next = new Link();
        this.effectivelast = this.last;
        this.last = this.last.next;
        ++this.length;
        return this.effectivelast;
    }

    public void remove(Link link) {
        Link link2 = link.next;
        link.hold = link2.hold;
        link.next = link2.next;
        --this.length;
    }

    public void remove(Object object) {
        Link link = this.first;
        while (link != this.last) {
            if (link.hold == object) {
                this.remove(link);
                return;
            }
            link = link.getNext();
        }
    }

    public void removeAll() {
        this.first = null;
        this.mark = null;
        this.last = null;
        this.length = 0;
        this.last = this.mark = new Link();
        this.first = this.mark;
    }

    public Link insert(Object object, int n) {
        Link link;
        if (n < 0) {
            n = 0;
        }
        if (n >= this.length) {
            this.add(object);
            return this.last;
        }
        Link link2 = this.first;
        while (--n != 0) {
            link2 = link2.next;
        }
        link2.next = link = new Link(object, link2.next);
        ++this.length;
        return link;
    }

    public Link insertAfter(Object object, Link link) {
        Link link2;
        link.next = link2 = new Link(object, link.next);
        ++this.length;
        return link2;
    }

    public Object getElement(int n) {
        if (n > this.length - 1) {
            return this.last;
        }
        Link link = this.first;
        while (n-- > 0) {
            link = link.next;
        }
        return link.hold;
    }

    public int getIndexOf(Object object) {
        Link link = this.first;
        int n = 0;
        while (n < this.length) {
            if (link.hold == object) {
                return n;
            }
            link = link.next;
            ++n;
        }
        return -1;
    }

    public Link getLinkOf(Object object) {
        Link link = this.first;
        int n = 0;
        while (n < this.length) {
            if (link.hold == object) {
                return link;
            }
            link = link.next;
            ++n;
        }
        return null;
    }

    public Link getLinkOfIndex(int n) {
        if (n > this.length - 1) {
            return this.last;
        }
        Link link = this.first;
        while (n-- > 0) {
            link = link.next;
        }
        return link;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.length];
        Link link = this.first;
        int n = 0;
        while (n < this.length) {
            objectArray[n] = link.hold;
            link = link.next;
            ++n;
        }
        return objectArray;
    }

    public String toString() {
        String string = "LList:[ ";
        Link link = this.first;
        int n = 0;
        while (n < this.length) {
            string = String.valueOf(string) + link.toString();
            link = link.next;
            ++n;
        }
        return String.valueOf(string) + " ]";
    }

    public class Link
    implements Serializable {
        protected Object hold;
        protected Link next;

        Link() {
        }

        Link(Object object) {
            this.hold = object;
        }

        Link(Object object, Link link) {
            this.hold = object;
            this.next = link;
        }

        public Object get() {
            return this.hold;
        }

        public void set(Object object) {
            this.hold = object;
        }

        public Link getNext() {
            return this.next;
        }

        public void setNext(Link link) {
            this.next = link;
        }

        public String toString() {
            return "Link: has ( " + this.hold + " )";
        }
    }
}

