/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.GridOverlay;
import game.Maps;
import gui.GridPanel;
import gui.Main;
import gui.ThemeSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import util.GMedia;

public class GameGrid {
    public static boolean POWER_DOUBLE = true;
    public static boolean showChecks = false;
    public static boolean showScramble = true;
    private Main main;
    private String wName;
    private String bName;
    private String lastMsg = "";
    private String theme = "paper";
    private GridOverlay overlay = null;
    private GridPanel gridp;
    private int item = -1;
    private int mouseItem = -1;
    private int mouseX = 0;
    private int mouseY = 0;
    private Image[] itemImgs;
    private Image[] paperImgs;
    private Image[] spaceImgs;
    private Image[] woodImgs;
    private int[][] grid;
    private int[][] checkGrid;
    private boolean whiteTurn = true;
    private boolean mustSac = false;
    private boolean sacPart1 = false;
    private int whitePower = 0;
    private int blackPower = 0;
    private boolean playing = false;
    private boolean netMyTurn = true;
    public static final int EMPTY = 0;
    public static final int WHITE_POWER = 1;
    public static final int BLACK_POWER = 2;
    public static final int SCRAMBLE = 4;
    public static final int WHITE_INFLUENCE = 8;
    public static final int BLACK_INFLUENCE = 16;
    private static final int iNONE = 0;
    private static final int iEMPTY = 1;
    private static final int iBLOCK = 2;
    private static final int iPLUG = 3;
    private static final int iCORNER_PLUG = 30;
    private static final int iRUBBLE = 4;
    private static final int iFIRE = 5;
    private static final int iW_FLAG = 6;
    private static final int iW_SINGLE_N = 7;
    private static final int iW_SINGLE_S = 8;
    private static final int iW_SINGLE_E = 9;
    private static final int iW_SINGLE_W = 10;
    private static final int iW_DOUBLE_NS = 11;
    private static final int iW_DOUBLE_EW = 12;
    private static final int iW_QUAD = 13;
    private static final int iW_BOMB = 14;
    private static final int iW_POWER = 15;
    private static final int iW_SCRAMBLER_NS = 16;
    private static final int iW_SCRAMBLER_EW = 17;
    private static final int iB_FLAG = 18;
    private static final int iB_SINGLE_N = 19;
    private static final int iB_SINGLE_S = 20;
    private static final int iB_SINGLE_E = 21;
    private static final int iB_SINGLE_W = 22;
    private static final int iB_DOUBLE_NS = 23;
    private static final int iB_DOUBLE_EW = 24;
    private static final int iB_QUAD = 25;
    private static final int iB_BOMB = 26;
    private static final int iB_POWER = 27;
    private static final int iB_SCRAMBLER_NS = 28;
    private static final int iB_SCRAMBLER_EW = 29;

    public GameGrid(Main main, GridPanel gridPanel) {
        this.main = main;
        this.gridp = gridPanel;
        this.paperImgs = this.makeThemeImages("paper");
        this.spaceImgs = this.makeThemeImages("space");
        this.woodImgs = this.makeThemeImages("wood");
        this.setTheme("paper");
    }

    private Image[] makeThemeImages(String string) {
        Image[] imageArray = new Image[]{GMedia.getImage(string + "none"), GMedia.getImage(string + "empty"), GMedia.getImage(string + "block"), GMedia.getImage(string + "plug"), GMedia.getImage(string + "rubble"), GMedia.getImage(string + "fire"), GMedia.getImage(string + "Wflag"), GMedia.getImage(string + "WsingleN"), GMedia.getImage(string + "WsingleS"), GMedia.getImage(string + "WsingleE"), GMedia.getImage(string + "WsingleW"), GMedia.getImage(string + "WdoubleNS"), GMedia.getImage(string + "WdoubleEW"), GMedia.getImage(string + "Wquad"), GMedia.getImage(string + "Wbomb"), GMedia.getImage(string + "Wpower"), GMedia.getImage(string + "WscramblerNS"), GMedia.getImage(string + "WscramblerEW"), GMedia.getImage(string + "Bflag"), GMedia.getImage(string + "BsingleN"), GMedia.getImage(string + "BsingleS"), GMedia.getImage(string + "BsingleE"), GMedia.getImage(string + "BsingleW"), GMedia.getImage(string + "BdoubleNS"), GMedia.getImage(string + "BdoubleEW"), GMedia.getImage(string + "Bquad"), GMedia.getImage(string + "Bbomb"), GMedia.getImage(string + "Bpower"), GMedia.getImage(string + "BscramblerNS"), GMedia.getImage(string + "BscramblerEW"), GMedia.getImage(string + "cornerplug")};
        for (int i = 0; i < imageArray.length; ++i) {
            if (imageArray[i] != null && imageArray[i].getWidth(null) != -1) continue;
            BufferedImage bufferedImage = new BufferedImage(24, 24, 1);
            Graphics graphics = bufferedImage.getGraphics();
            graphics.setColor(Color.black);
            graphics.fillRect(0, 0, 24, 24);
            graphics.setColor(Color.red);
            graphics.drawRect(3, 3, 18, 18);
            if (i == 0) {
                graphics.setColor(Color.gray);
            } else if (i >= 6 && i <= 17) {
                graphics.setColor(Color.yellow);
            } else if (i >= 18 && i <= 29) {
                graphics.setColor(Color.green);
            } else {
                graphics.setColor(Color.blue);
            }
            graphics.drawString("" + i, i > 9 ? 4 : 8, 18);
            imageArray[i] = bufferedImage;
        }
        return imageArray;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void setTheme(String string) {
        this.theme = string;
        if (string.equals("space")) {
            this.itemImgs = this.spaceImgs;
        } else if (string.equals("paper")) {
            this.itemImgs = this.paperImgs;
        } else if (string.equals("wood")) {
            this.itemImgs = this.woodImgs;
        }
        this.wName = ThemeSettings.whiteName[ThemeSettings.getThemeId(string)];
        this.bName = ThemeSettings.blackName[ThemeSettings.getThemeId(string)];
        this.showMessage(this.lastMsg);
        if (this.overlay != null) {
            this.overlay.setTheme(string);
        }
    }

    public void paint(Graphics graphics, Component component) {
        int n;
        Dimension dimension = component.getSize();
        if (this.grid == null) {
            graphics.drawImage(GMedia.getImage("splash"), 0, 0, dimension.width, dimension.height, component);
            return;
        }
        int n2 = 0;
        for (n = 0; n < this.grid.length; ++n) {
            for (n2 = 0; n2 < this.grid[0].length; ++n2) {
                graphics.drawImage(this.itemImgs[this.grid[n][n2]], n * 24, n2 * 24, 24, 24, component);
                if (!Main.DEBUG_GRID) continue;
                if ((this.checkGrid[n][n2] & 1) != 0) {
                    graphics.setColor(new Color(128, 128, 255));
                    graphics.fillOval(n * 24 + 8, n2 * 24 + 8, 6, 6);
                }
                if ((this.checkGrid[n][n2] & 2) != 0) {
                    graphics.setColor(Color.blue);
                    graphics.fillOval(n * 24 + 10, n2 * 24 + 10, 6, 6);
                }
                if ((this.checkGrid[n][n2] & 8) != 0) {
                    graphics.setColor(new Color(128, 128, 255));
                    graphics.drawLine(n * 24 + 11, n2 * 24, n * 24 + 11, n2 * 24 + 24);
                    graphics.drawLine(n * 24, n2 * 24 + 11, n * 24 + 24, n2 * 24 + 11);
                }
                if ((this.checkGrid[n][n2] & 0x10) != 0) {
                    graphics.setColor(Color.blue);
                    graphics.drawLine(n * 24 + 13, n2 * 24, n * 24 + 13, n2 * 24 + 24);
                    graphics.drawLine(n * 24, n2 * 24 + 13, n * 24 + 24, n2 * 24 + 13);
                }
                if ((this.checkGrid[n][n2] & 4) == 0) continue;
                graphics.setColor(Color.red);
                graphics.drawLine(n * 24, n2 * 24, n * 24 + 24, n2 * 24 + 24);
                graphics.drawLine(n * 24 + 24, n2 * 24, n * 24, n2 * 24 + 24);
            }
            while (n2 * 24 < dimension.height) {
                graphics.drawImage(this.itemImgs[0], n * 24, n2 * 24, 24, 24, component);
                ++n2;
            }
        }
        while (n * 24 < dimension.width) {
            n2 = 0;
            while (n2 * 24 < dimension.height) {
                graphics.drawImage(this.itemImgs[0], n * 24, n2 * 24, 24, 24, component);
                ++n2;
            }
            ++n;
        }
        if (this.mouseItem != -1) {
            graphics.drawImage(this.itemImgs[this.mouseItem], this.mouseX * 24, this.mouseY * 24, 24, 24, component);
        }
    }

    public void showMessage(String string) {
        this.lastMsg = string;
        if (this.playing) {
            this.main.showStatus(this.wName + ": " + this.whitePower + "   " + this.bName + ": " + this.blackPower + "     " + string);
        } else {
            this.main.showStatus("Select New Game from the Game menu to begin");
        }
    }

    public void checkItem() {
        this.mouseItem = -1;
        if (!this.playing || this.mouseX == -1 || this.mouseY == -1) {
            return;
        }
        if (this.grid[this.mouseX][this.mouseY] >= (this.whiteTurn ? 6 : 18) && this.grid[this.mouseX][this.mouseY] <= (this.whiteTurn ? 17 : 29)) {
            this.mouseItem = 4;
            return;
        }
        if (this.mustSac) {
            this.mouseItem = -1;
            return;
        }
        if (this.whiteTurn && (this.checkGrid[this.mouseX][this.mouseY] & 8) == 0) {
            return;
        }
        if (!this.whiteTurn && (this.checkGrid[this.mouseX][this.mouseY] & 0x10) == 0) {
            return;
        }
        if (this.grid[this.mouseX][this.mouseY] >= (this.whiteTurn ? 18 : 6) && this.grid[this.mouseX][this.mouseY] <= (this.whiteTurn ? 29 : 17)) {
            return;
        }
        if (this.grid[this.mouseX][this.mouseY] == 4) {
            if (this.mouseX != 0 && this.grid[this.mouseX - 1][this.mouseY] >= 6 && this.grid[this.mouseX - 1][this.mouseY] <= 29 || this.mouseY != 0 && this.grid[this.mouseX][this.mouseY - 1] >= 6 && this.grid[this.mouseX][this.mouseY - 1] <= 29 || this.mouseX != this.grid.length - 1 && this.grid[this.mouseX + 1][this.mouseY] >= 6 && this.grid[this.mouseX + 1][this.mouseY] <= 29 || this.mouseY != this.grid[0].length - 1 && this.grid[this.mouseX][this.mouseY + 1] >= 6 && this.grid[this.mouseX][this.mouseY + 1] <= 29) {
                this.mouseItem = 5;
            }
            return;
        }
        if (this.grid[this.mouseX][this.mouseY] == 0 || this.grid[this.mouseX][this.mouseY] == 2) {
            return;
        }
        int n = this.item;
        if (n > 18) {
            n -= 12;
        }
        if (this.grid[this.mouseX][this.mouseY] == 3) {
            if (n == 15) {
                this.mouseItem = this.item;
            }
            return;
        }
        int n2 = this.whiteTurn ? this.whitePower : this.blackPower;
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                if (n2 < 1) {
                    this.showMessage("Insufficient Power");
                    return;
                }
                this.mouseItem = this.item;
                break;
            }
            case 11: 
            case 12: {
                if (n2 < 2) {
                    this.showMessage("Insufficient Power");
                    return;
                }
                this.mouseItem = this.item;
                break;
            }
            case 13: {
                if (n2 < 4) {
                    this.showMessage("Insufficient Power");
                    return;
                }
                this.mouseItem = this.item;
                break;
            }
            case 14: {
                if (n2 < 2) {
                    this.showMessage("Insufficient Power");
                    return;
                }
                this.mouseItem = this.item;
                break;
            }
            case 15: {
                if (!(this.grid[this.mouseX][this.mouseY] == 30 || this.mouseX != 0 && this.grid[this.mouseX - 1][this.mouseY] == (this.whiteTurn ? 15 : 27) || this.mouseY != 0 && this.grid[this.mouseX][this.mouseY - 1] == (this.whiteTurn ? 15 : 27) || this.mouseX != this.grid.length - 1 && this.grid[this.mouseX + 1][this.mouseY] == (this.whiteTurn ? 15 : 27)) && (this.mouseY == this.grid[0].length - 1 || this.grid[this.mouseX][this.mouseY + 1] != (this.whiteTurn ? 15 : 27))) break;
                this.mouseItem = this.item;
                break;
            }
            case 16: 
            case 17: {
                if (n2 < 4) {
                    this.showMessage("Insufficient Power");
                    return;
                }
                this.mouseItem = this.item;
            }
        }
    }

    private boolean makeCheckGrid() {
        int n;
        int n2;
        this.whitePower = 0;
        this.blackPower = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (n2 = 0; n2 < this.grid.length; ++n2) {
            for (n = 0; n < this.grid[0].length; ++n) {
                this.checkGrid[n2][n] = 0;
            }
        }
        for (n2 = 0; n2 < this.grid.length; ++n2) {
            for (n = 0; n < this.grid[0].length; ++n) {
                if (this.checkGrid[n2][n] == 4) continue;
                if (this.grid[n2][n] == 16 || this.grid[n2][n] == 28) {
                    int[] nArray = this.checkGrid[n2];
                    int n3 = n;
                    nArray[n3] = nArray[n3] | 4;
                    this.scrambleGridN(n2, n);
                    this.scrambleGridS(n2, n);
                    continue;
                }
                if (this.grid[n2][n] != 17 && this.grid[n2][n] != 29) continue;
                int[] nArray = this.checkGrid[n2];
                int n4 = n;
                nArray[n4] = nArray[n4] | 4;
                this.scrambleGridE(n2, n);
                this.scrambleGridW(n2, n);
            }
        }
        for (n2 = 0; n2 < this.grid.length; ++n2) {
            block32: for (n = 0; n < this.grid[0].length; ++n) {
                switch (this.grid[n2][n]) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 30: {
                        continue block32;
                    }
                    case 6: {
                        bl = true;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n5 = n;
                        nArray[n5] = nArray[n5] | 8;
                        this.orGridE(n2, n, 8);
                        this.orGridW(n2, n, 8);
                        continue block32;
                    }
                    case 7: {
                        --this.whitePower;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n6 = n;
                        nArray[n6] = nArray[n6] | 8;
                        this.orGridN(n2, n, 8);
                        continue block32;
                    }
                    case 8: {
                        --this.whitePower;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n7 = n;
                        nArray[n7] = nArray[n7] | 8;
                        this.orGridS(n2, n, 8);
                        continue block32;
                    }
                    case 9: {
                        --this.whitePower;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n8 = n;
                        nArray[n8] = nArray[n8] | 8;
                        this.orGridE(n2, n, 8);
                        continue block32;
                    }
                    case 10: {
                        --this.whitePower;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n9 = n;
                        nArray[n9] = nArray[n9] | 8;
                        this.orGridW(n2, n, 8);
                        continue block32;
                    }
                    case 11: {
                        this.whitePower -= 2;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n10 = n;
                        nArray[n10] = nArray[n10] | 8;
                        this.orGridN(n2, n, 8);
                        this.orGridS(n2, n, 8);
                        continue block32;
                    }
                    case 12: {
                        this.whitePower -= 2;
                        int[] nArray = this.checkGrid[n2];
                        int n11 = n;
                        nArray[n11] = nArray[n11] | 8;
                        this.orGridE(n2, n, 8);
                        this.orGridW(n2, n, 8);
                        continue block32;
                    }
                    case 13: {
                        this.whitePower -= 4;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n12 = n;
                        nArray[n12] = nArray[n12] | 8;
                        this.orGridN(n2, n, 8);
                        this.orGridS(n2, n, 8);
                        this.orGridE(n2, n, 8);
                        this.orGridW(n2, n, 8);
                        continue block32;
                    }
                    case 14: {
                        this.whitePower -= 2;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n13 = n;
                        nArray[n13] = nArray[n13] | 8;
                        continue block32;
                    }
                    case 15: {
                        int n14;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n15 = n;
                        nArray[n15] = nArray[n15] | 8;
                        if (POWER_DOUBLE) {
                            n14 = this.scanWhitePower(n2, n);
                            if (n14 == 0) continue block32;
                            this.whitePower = (int)((double)this.whitePower + Math.pow(2.0, n14));
                            continue block32;
                        }
                        this.whitePower += 4 * this.scanWhitePower(n2, n);
                        continue block32;
                    }
                    case 16: {
                        this.whitePower -= 4;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n16 = n;
                        nArray[n16] = nArray[n16] | 8;
                        continue block32;
                    }
                    case 17: {
                        this.whitePower -= 4;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n17 = n;
                        nArray[n17] = nArray[n17] | 8;
                        continue block32;
                    }
                    case 18: {
                        bl2 = true;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n18 = n;
                        nArray[n18] = nArray[n18] | 0x10;
                        this.orGridE(n2, n, 16);
                        this.orGridW(n2, n, 16);
                        continue block32;
                    }
                    case 19: {
                        --this.blackPower;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n19 = n;
                        nArray[n19] = nArray[n19] | 0x10;
                        this.orGridN(n2, n, 16);
                        continue block32;
                    }
                    case 20: {
                        --this.blackPower;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n20 = n;
                        nArray[n20] = nArray[n20] | 0x10;
                        this.orGridS(n2, n, 16);
                        continue block32;
                    }
                    case 21: {
                        --this.blackPower;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n21 = n;
                        nArray[n21] = nArray[n21] | 0x10;
                        this.orGridE(n2, n, 16);
                        continue block32;
                    }
                    case 22: {
                        --this.blackPower;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n22 = n;
                        nArray[n22] = nArray[n22] | 0x10;
                        this.orGridW(n2, n, 16);
                        continue block32;
                    }
                    case 23: {
                        this.blackPower -= 2;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n23 = n;
                        nArray[n23] = nArray[n23] | 0x10;
                        this.orGridN(n2, n, 16);
                        this.orGridS(n2, n, 16);
                        continue block32;
                    }
                    case 24: {
                        this.blackPower -= 2;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        this.orGridE(n2, n, 16);
                        this.orGridW(n2, n, 16);
                        continue block32;
                    }
                    case 25: {
                        this.blackPower -= 4;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n24 = n;
                        nArray[n24] = nArray[n24] | 0x10;
                        this.orGridN(n2, n, 16);
                        this.orGridS(n2, n, 16);
                        this.orGridE(n2, n, 16);
                        this.orGridW(n2, n, 16);
                        continue block32;
                    }
                    case 26: {
                        this.blackPower -= 2;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n25 = n;
                        nArray[n25] = nArray[n25] | 0x10;
                        continue block32;
                    }
                    case 27: {
                        int n14;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n26 = n;
                        nArray[n26] = nArray[n26] | 0x10;
                        if (POWER_DOUBLE) {
                            n14 = this.scanBlackPower(n2, n);
                            if (n14 == 0) continue block32;
                            this.blackPower = (int)((double)this.blackPower + Math.pow(2.0, n14));
                            continue block32;
                        }
                        this.blackPower += 4 * this.scanBlackPower(n2, n);
                        continue block32;
                    }
                    case 28: {
                        this.blackPower -= 4;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n27 = n;
                        nArray[n27] = nArray[n27] | 0x10;
                        continue block32;
                    }
                    case 29: {
                        this.blackPower -= 4;
                        if ((this.checkGrid[n2][n] & 4) != 0) continue block32;
                        int[] nArray = this.checkGrid[n2];
                        int n28 = n;
                        nArray[n28] = nArray[n28] | 0x10;
                    }
                }
            }
        }
        if (!bl) {
            this.showMessage(this.bName + " Wins!");
            return true;
        }
        if (!bl2) {
            this.showMessage(this.wName + " Wins!");
            return true;
        }
        return false;
    }

    private int scanWhitePower(int n, int n2) {
        if (n < 0 || n >= this.checkGrid.length || n2 < 0 || n2 >= this.checkGrid[0].length) {
            return 0;
        }
        if ((this.checkGrid[n][n2] & 1) != 0 || this.grid[n][n2] != 15) {
            return 0;
        }
        int[] nArray = this.checkGrid[n];
        int n3 = n2;
        nArray[n3] = nArray[n3] | 1;
        return ((this.checkGrid[n][n2] & 4) == 0 ? 1 : 0) + this.scanWhitePower(n, n2 - 1) + this.scanWhitePower(n, n2 + 1) + this.scanWhitePower(n + 1, n2) + this.scanWhitePower(n - 1, n2);
    }

    private int scanBlackPower(int n, int n2) {
        if (n < 0 || n >= this.checkGrid.length || n2 < 0 || n2 >= this.checkGrid[0].length) {
            return 0;
        }
        if ((this.checkGrid[n][n2] & 2) != 0 || this.grid[n][n2] != 27) {
            return 0;
        }
        int[] nArray = this.checkGrid[n];
        int n3 = n2;
        nArray[n3] = nArray[n3] | 2;
        return ((this.checkGrid[n][n2] & 4) == 0 ? 1 : 0) + this.scanBlackPower(n, n2 - 1) + this.scanBlackPower(n, n2 + 1) + this.scanBlackPower(n + 1, n2) + this.scanBlackPower(n - 1, n2);
    }

    private void orGridN(int n, int n2, int n3) {
        if (n2 == 0) {
            return;
        }
        if (this.grid[n][n2] == 4 && this.grid[n][n2 - 1] != 4) {
            return;
        }
        if (this.grid[n][--n2] == 3 || this.grid[n][n2] == 30) {
            int[] nArray = this.checkGrid[n];
            int n4 = n2;
            nArray[n4] = nArray[n4] | n3;
            return;
        }
        if (this.grid[n][n2] != 1 && this.grid[n][n2] != 4 || (this.checkGrid[n][n2] & 4) != 0) {
            return;
        }
        int[] nArray = this.checkGrid[n];
        int n5 = n2;
        nArray[n5] = nArray[n5] | n3;
        this.orGridN(n, n2, n3);
    }

    private void orGridS(int n, int n2, int n3) {
        if (++n2 == this.grid[0].length) {
            return;
        }
        if (this.grid[n][n2 - 1] == 4 && this.grid[n][n2] != 4) {
            return;
        }
        if (this.grid[n][n2] == 3 || this.grid[n][n2] == 30) {
            int[] nArray = this.checkGrid[n];
            int n4 = n2;
            nArray[n4] = nArray[n4] | n3;
            return;
        }
        if (this.grid[n][n2] != 1 && this.grid[n][n2] != 4 || (this.checkGrid[n][n2] & 4) != 0) {
            return;
        }
        int[] nArray = this.checkGrid[n];
        int n5 = n2;
        nArray[n5] = nArray[n5] | n3;
        this.orGridS(n, n2, n3);
    }

    private void orGridE(int n, int n2, int n3) {
        if (++n == this.grid.length) {
            return;
        }
        if (this.grid[n - 1][n2] == 4 && this.grid[n][n2] != 4) {
            return;
        }
        if (this.grid[n][n2] == 3 || this.grid[n][n2] == 30) {
            int[] nArray = this.checkGrid[n];
            int n4 = n2;
            nArray[n4] = nArray[n4] | n3;
            return;
        }
        if (this.grid[n][n2] != 1 && this.grid[n][n2] != 4 || (this.checkGrid[n][n2] & 4) != 0) {
            return;
        }
        int[] nArray = this.checkGrid[n];
        int n5 = n2;
        nArray[n5] = nArray[n5] | n3;
        this.orGridE(n, n2, n3);
    }

    private void orGridW(int n, int n2, int n3) {
        if (n == 0) {
            return;
        }
        if (this.grid[n][n2] == 4 && this.grid[n - 1][n2] != 4) {
            return;
        }
        if (this.grid[--n][n2] == 3 || this.grid[n][n2] == 30) {
            int[] nArray = this.checkGrid[n];
            int n4 = n2;
            nArray[n4] = nArray[n4] | n3;
            return;
        }
        if (this.grid[n][n2] != 1 && this.grid[n][n2] != 4 || (this.checkGrid[n][n2] & 4) != 0) {
            return;
        }
        int[] nArray = this.checkGrid[n];
        int n5 = n2;
        nArray[n5] = nArray[n5] | n3;
        this.orGridW(n, n2, n3);
    }

    private void scrambleGridN(int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (this.grid[n][--n2] != 1) {
            if (this.grid[n][n2] != 4 && this.grid[n][n2] != 2 && this.grid[n][n2] != 0) {
                int[] nArray = this.checkGrid[n];
                int n3 = n2;
                nArray[n3] = nArray[n3] | 4;
            }
            return;
        }
        int[] nArray = this.checkGrid[n];
        int n4 = n2;
        nArray[n4] = nArray[n4] | 4;
        this.scrambleGridN(n, n2);
    }

    private void scrambleGridS(int n, int n2) {
        if (++n2 == this.grid[0].length) {
            return;
        }
        if (this.grid[n][n2] != 1) {
            if (this.grid[n][n2] != 4 && this.grid[n][n2] != 2 && this.grid[n][n2] != 0) {
                int[] nArray = this.checkGrid[n];
                int n3 = n2;
                nArray[n3] = nArray[n3] | 4;
            }
            return;
        }
        int[] nArray = this.checkGrid[n];
        int n4 = n2;
        nArray[n4] = nArray[n4] | 4;
        this.scrambleGridS(n, n2);
    }

    private void scrambleGridE(int n, int n2) {
        if (++n == this.grid.length) {
            return;
        }
        if (this.grid[n][n2] != 1) {
            if (this.grid[n][n2] != 4 && this.grid[n][n2] != 2 && this.grid[n][n2] != 0) {
                int[] nArray = this.checkGrid[n];
                int n3 = n2;
                nArray[n3] = nArray[n3] | 4;
            }
            return;
        }
        int[] nArray = this.checkGrid[n];
        int n4 = n2;
        nArray[n4] = nArray[n4] | 4;
        this.scrambleGridE(n, n2);
    }

    private void scrambleGridW(int n, int n2) {
        if (n == 0) {
            return;
        }
        if (this.grid[--n][n2] != 1) {
            if (this.grid[n][n2] != 4 && this.grid[n][n2] != 2 && this.grid[n][n2] != 0) {
                int[] nArray = this.checkGrid[n];
                int n3 = n2;
                nArray[n3] = nArray[n3] | 4;
            }
            return;
        }
        int[] nArray = this.checkGrid[n];
        int n4 = n2;
        nArray[n4] = nArray[n4] | 4;
        this.scrambleGridW(n, n2);
    }

    public void notifyMyTurn() {
        Main.playThemeSoundAfterPause(this.theme, "NetMyTurn", 1000L);
        this.netMyTurn = true;
    }

    public void notifyNotMyTurn() {
        this.netMyTurn = false;
    }

    public boolean placeItem() {
        if (!this.playing) {
            return false;
        }
        if (this.mouseItem != -1) {
            this.placeItem(this.mouseX, this.mouseY, this.mouseItem);
            return true;
        }
        return false;
    }

    public void placeItem(int n, int n2, int n3) {
        this.grid[n][n2] = n3;
        String string = null;
        if (n3 == 5) {
            this.grid[n][n2] = 4;
            if (n2 != 0 && this.grid[n][n2 - 1] >= 6 && this.grid[n][n2 - 1] <= 29) {
                this.grid[n][n2 - 1] = 4;
            }
            if (n2 != this.grid[0].length - 1 && this.grid[n][n2 + 1] >= 6 && this.grid[n][n2 + 1] <= 29) {
                this.grid[n][n2 + 1] = 4;
            }
            if (n != this.grid.length - 1 && this.grid[n + 1][n2] >= 6 && this.grid[n + 1][n2] <= 29) {
                this.grid[n + 1][n2] = 4;
            }
            if (n != 0 && this.grid[n - 1][n2] >= 6 && this.grid[n - 1][n2] <= 29) {
                this.grid[n - 1][n2] = 4;
            }
            string = "Ignite";
        } else if (n3 == 14) {
            string = "PlaceBomb";
            if (n2 != 0 && this.grid[n][n2 - 1] >= 18 && this.grid[n][n2 - 1] <= 29 && this.grid[n][n2 - 1] != 26) {
                this.grid[n][n2 - 1] = 4;
                string = "Bomb";
            }
            if (n2 != this.grid[0].length - 1 && this.grid[n][n2 + 1] >= 18 && this.grid[n][n2 + 1] <= 29 && this.grid[n][n2 + 1] != 26) {
                this.grid[n][n2 + 1] = 4;
                string = "Bomb";
            }
            if (n != this.grid.length - 1 && this.grid[n + 1][n2] >= 18 && this.grid[n + 1][n2] <= 29 && this.grid[n + 1][n2] != 26) {
                this.grid[n + 1][n2] = 4;
                string = "Bomb";
            }
            if (n != 0 && this.grid[n - 1][n2] >= 18 && this.grid[n - 1][n2] <= 29 && this.grid[n - 1][n2] != 26) {
                this.grid[n - 1][n2] = 4;
                string = "Bomb";
            }
        } else if (n3 == 26) {
            string = "PlaceBomb";
            if (n2 != 0 && this.grid[n][n2 - 1] >= 6 && this.grid[n][n2 - 1] <= 17 && this.grid[n][n2 - 1] != 14) {
                this.grid[n][n2 - 1] = 4;
                string = "Bomb";
            }
            if (n2 != this.grid[0].length - 1 && this.grid[n][n2 + 1] >= 6 && this.grid[n][n2 + 1] <= 17 && this.grid[n][n2 + 1] != 14) {
                this.grid[n][n2 + 1] = 4;
                string = "Bomb";
            }
            if (n != this.grid.length - 1 && this.grid[n + 1][n2] >= 6 && this.grid[n + 1][n2] <= 17 && this.grid[n + 1][n2] != 14) {
                this.grid[n + 1][n2] = 4;
                string = "Bomb";
            }
            if (n != 0 && this.grid[n - 1][n2] >= 6 && this.grid[n - 1][n2] <= 17 && this.grid[n - 1][n2] != 14) {
                this.grid[n - 1][n2] = 4;
                string = "Bomb";
            }
        } else if (this.grid[n][n2] >= 6 && this.grid[n][n2] <= 17 && this.grid[n][n2] != 14) {
            if (n2 != 0 && this.grid[n][n2 - 1] == 26 && (this.checkGrid[n][n2 - 1] & 4) == 0) {
                this.grid[n][n2] = 4;
                string = "Burnt";
            } else if (n2 != this.grid[0].length - 1 && this.grid[n][n2 + 1] == 26 && (this.checkGrid[n][n2 + 1] & 4) == 0) {
                this.grid[n][n2] = 4;
                string = "Burnt";
            } else if (n != this.grid.length - 1 && this.grid[n + 1][n2] == 26 && (this.checkGrid[n + 1][n2] & 4) == 0) {
                this.grid[n][n2] = 4;
                string = "Burnt";
            } else if (n != 0 && this.grid[n - 1][n2] == 26 && (this.checkGrid[n - 1][n2] & 4) == 0) {
                this.grid[n][n2] = 4;
                string = "Burnt";
            }
        } else if (this.grid[n][n2] >= 18 && this.grid[n][n2] <= 29 && this.grid[n][n2] != 26) {
            if (n2 != 0 && this.grid[n][n2 - 1] == 14 && (this.checkGrid[n][n2 - 1] & 4) == 0) {
                this.grid[n][n2] = 4;
                string = "Burnt";
            } else if (n2 != this.grid[0].length - 1 && this.grid[n][n2 + 1] == 14 && (this.checkGrid[n][n2 + 1] & 4) == 0) {
                this.grid[n][n2] = 4;
                string = "Burnt";
            } else if (n != this.grid.length - 1 && this.grid[n + 1][n2] == 14 && (this.checkGrid[n + 1][n2] & 4) == 0) {
                this.grid[n][n2] = 4;
                string = "Burnt";
            } else if (n != 0 && this.grid[n - 1][n2] == 14 && (this.checkGrid[n - 1][n2] & 4) == 0) {
                this.grid[n][n2] = 4;
                string = "Burnt";
            }
        }
        if (string == null) {
            if (n3 >= 7 && n3 <= 13 || n3 >= 19 && n3 <= 25) {
                string = "PlacePiece";
            } else if (n3 == 16 || n3 == 17 || n3 == 28 || n3 == 29) {
                string = "PlaceScrambler";
            } else if (n3 == 15 || n3 == 27) {
                string = "PlacePower";
            } else if (n3 == 4) {
                string = "Burnt";
            }
        }
        if (string != null) {
            Main.playThemeSound(this.theme, string);
        }
        this.item = -1;
        this.mouseItem = -1;
        boolean bl = this.makeCheckGrid();
        this.overlay.updateOverlay(this.checkGrid, this.grid, n, n2);
        if (bl) {
            if (!this.main.isNetworkGame() || !this.netMyTurn) {
                Main.playThemeSoundAfterPause(this.theme, "GameOver", 1200L);
            } else {
                Main.playThemeSoundAfterPause(this.theme, "NetGameLost", 1200L);
            }
            Main.restartMusic(3000L);
            this.playing = false;
            this.main.menusNotPlaying();
            return;
        }
        boolean bl2 = false;
        if (this.whiteTurn && this.whitePower < 0) {
            this.showMessage(this.wName + " must sac an item");
            bl2 = true;
        } else if (!this.whiteTurn && this.blackPower < 0) {
            this.showMessage(this.bName + " must sac an item");
            bl2 = true;
        }
        if (bl2) {
            if (!this.mustSac) {
                this.sacPart1 = true;
                this.mustSac = true;
            }
        } else if (this.sacPart1 || !this.mustSac) {
            this.whiteTurn = !this.whiteTurn;
            this.sacPart1 = false;
            bl2 = false;
            if (this.whiteTurn && this.whitePower < 0) {
                this.showMessage(this.wName + " must sac an item");
                bl2 = true;
            } else if (!this.whiteTurn && this.blackPower < 0) {
                this.showMessage(this.bName + " must sac an item");
                bl2 = true;
            }
            this.mustSac = bl2;
        } else {
            this.mustSac = false;
        }
        if (!this.mustSac) {
            this.showMessage((this.whiteTurn ? this.wName : this.bName) + "'s Turn");
            this.main.menusItemsForPower(this.whiteTurn ? this.whitePower : this.blackPower);
            this.main.menusForPlayer(this.whiteTurn);
        } else {
            this.main.menusItemsForPower(-1);
        }
        this.checkItem();
    }

    public boolean setMouseLocation(int n, int n2) {
        if (!this.playing) {
            return false;
        }
        if (n > this.grid.length - 1) {
            n = this.grid.length - 1;
        }
        if (n2 > this.grid[0].length - 1) {
            n2 = this.grid[0].length - 1;
        }
        if (n == this.mouseX && n2 == this.mouseY) {
            return false;
        }
        this.mouseX = n;
        this.mouseY = n2;
        this.checkItem();
        return true;
    }

    public boolean selectItem(char c) {
        if (!this.playing) {
            return false;
        }
        switch (c) {
            case '1': {
                int n = this.item = this.whiteTurn ? 7 : 19;
                if (this.mustSac) break;
                this.showMessage("-Single North-");
                break;
            }
            case '2': {
                int n = this.item = this.whiteTurn ? 8 : 20;
                if (this.mustSac) break;
                this.showMessage("-Single South-");
                break;
            }
            case '3': {
                int n = this.item = this.whiteTurn ? 9 : 21;
                if (this.mustSac) break;
                this.showMessage("-Single East-");
                break;
            }
            case '4': {
                int n = this.item = this.whiteTurn ? 10 : 22;
                if (this.mustSac) break;
                this.showMessage("-Single West-");
                break;
            }
            case '5': {
                int n = this.item = this.whiteTurn ? 11 : 23;
                if (this.mustSac) break;
                this.showMessage("-Double N/S-");
                break;
            }
            case '6': {
                int n = this.item = this.whiteTurn ? 12 : 24;
                if (this.mustSac) break;
                this.showMessage("-Double E/W-");
                break;
            }
            case '7': {
                int n = this.item = this.whiteTurn ? 13 : 25;
                if (this.mustSac) break;
                this.showMessage("-Quad-");
                break;
            }
            case '8': {
                int n = this.item = this.whiteTurn ? 14 : 26;
                if (this.mustSac) break;
                this.showMessage("-Bomb-");
                break;
            }
            case '9': {
                int n = this.item = this.whiteTurn ? 15 : 27;
                if (this.mustSac) break;
                this.showMessage("-Power Plant-");
                break;
            }
            case '0': {
                int n = this.item = this.whiteTurn ? 16 : 28;
                if (this.mustSac) break;
                this.showMessage("-Scrambler N/S-");
                break;
            }
            case '-': {
                int n = this.item = this.whiteTurn ? 17 : 29;
                if (this.mustSac) break;
                this.showMessage("-Scrambler E/W-");
                break;
            }
            default: {
                return false;
            }
        }
        int n = this.mouseItem;
        this.checkItem();
        return this.mouseItem != n;
    }

    public int getSelectedItem() {
        return this.mouseItem;
    }

    public int getItemX() {
        return this.mouseX;
    }

    public int getItemY() {
        return this.mouseY;
    }

    public boolean isWhiteTurn() {
        return this.whiteTurn;
    }

    public void beginGame() {
        if (this.playing) {
            return;
        }
        this.selectMap();
        this.beginGameOnMap();
    }

    public int[][] selectMap() {
        this.grid = Maps.getMap(Maps.showMapSelect());
        return this.grid;
    }

    public void useMap(int[][] nArray) {
        if (this.playing) {
            return;
        }
        this.grid = nArray;
    }

    public void beginGameOnMap() {
        if (this.playing) {
            return;
        }
        this.checkGrid = new int[this.grid.length][this.grid[0].length];
        this.playing = true;
        this.whitePower = 0;
        this.blackPower = 0;
        this.mustSac = false;
        this.sacPart1 = false;
        this.whiteTurn = true;
        this.showMessage(this.wName + "'s Turn");
        this.makeCheckGrid();
        this.overlay = new GridOverlay(this.gridp, this.checkGrid, this.grid);
        this.overlay.setTheme(this.theme);
        this.gridp.setOverlay(this.overlay);
        this.main.menusPlaying();
        this.main.menusItemsForPower(0);
    }

    public void abortGame() {
        this.playing = false;
        this.mouseItem = -1;
        this.item = -1;
        this.showMessage("Game Aborted");
        this.main.menusNotPlaying();
    }
}

