/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.GameGrid;
import game.OverlayAnimation;
import gui.GridPanel;
import gui.Main;
import gui.ThemeSettings;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Iterator;

public class GridOverlay
implements Runnable {
    private int[][] overlay;
    private Color whiteColor;
    private Color blackColor;
    private Color scrambleColor;
    private GridPanel gui;
    private OverlayAnimation[][] pendingAnimations;
    private ArrayList<OverlayAnimation> currentAnimations = new ArrayList();
    private Thread runner = null;
    private BasicStroke influenceStroke = new BasicStroke(2.0f, 1, 1);
    protected BasicStroke scrambleStroke = new BasicStroke(16.0f, 0, 1, 8.0f, new float[]{2.0f, 3.0f, 1.0f, 2.0f}, 0.0f);
    private AlphaComposite transparent = AlphaComposite.getInstance(1, 0.0f);
    private AlphaComposite opaque = AlphaComposite.getInstance(3, 1.0f);
    private static final int WHITE_MASK = 255;
    private static final int BLACK_MASK = 65280;
    private static final int SCRAMBLE_MASK = 0xFF0000;
    private static final int EMPTY = 0;
    private static final int WHITE_POWER = 1;
    private static final int WHITE_PIECE = 2;
    private static final int WHITE_NS = 3;
    private static final int WHITE_EW = 4;
    private static final int WHITE_BOTH = 5;
    private static final int WHITE_N_END = 6;
    private static final int WHITE_S_END = 7;
    private static final int WHITE_E_END = 8;
    private static final int WHITE_W_END = 9;
    private static final int BLACK_POWER = 256;
    private static final int BLACK_PIECE = 512;
    private static final int BLACK_NS = 768;
    private static final int BLACK_EW = 1024;
    private static final int BLACK_BOTH = 1280;
    private static final int BLACK_N_END = 1536;
    private static final int BLACK_S_END = 1792;
    private static final int BLACK_E_END = 2048;
    private static final int BLACK_W_END = 2304;
    private static final int SCRAMBLE_NS = 196608;
    private static final int SCRAMBLE_EW = 262144;
    private static final int SCRAMBLE_BOTH = 327680;
    private static final int SCRAMBLE_N_END = 393216;
    private static final int SCRAMBLE_S_END = 458752;
    private static final int SCRAMBLE_E_END = 524288;
    private static final int SCRAMBLE_W_END = 589824;
    private static final int WHITE_SHIFT = 0;
    private static final int BLACK_SHIFT = 8;
    private static final int SCRAMBLE_SHIFT = 16;
    private static final int DIR_NS = 3;
    private static final int DIR_EW = 4;
    private static final int DIR_BOTH = 5;
    private static final int DIR_N_END = 6;
    private static final int DIR_S_END = 7;
    private static final int DIR_E_END = 8;
    private static final int DIR_W_END = 9;

    public GridOverlay(GridPanel gridPanel, int[][] nArray, int[][] nArray2) {
        this.gui = gridPanel;
        int n = nArray.length;
        int n2 = nArray[0].length;
        this.overlay = new int[n][n2];
        this.pendingAnimations = new OverlayAnimation[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.overlay[i][j] = this.constructOverlayTile(nArray, i, j, nArray2[i][j]);
            }
        }
    }

    public void setTheme(String string) {
        this.whiteColor = ThemeSettings.getWhiteOverlayColor(string);
        this.blackColor = ThemeSettings.getBlackOverlayColor(string);
        this.scrambleColor = ThemeSettings.getScrambleOverlayColor(string);
    }

    public void updateOverlay(int[][] nArray, int[][] nArray2, int n, int n2) {
        for (int i = 0; i < this.overlay.length; ++i) {
            for (int j = 0; j < this.overlay[0].length; ++j) {
                int n3 = this.constructOverlayTile(nArray, i, j, nArray2[i][j]);
                if (this.overlay[i][j] == n3) continue;
                this.addAnimationsFor(i, j, n3);
            }
        }
        if (this.pendingAnimations[n][n2] != null) {
            this.pendingAnimations[n][n2].setDirection(6);
            this.startAnimation(this.pendingAnimations[n][n2]);
            this.pendingAnimations[n][n2] = null;
        } else {
            this.startAnimationsNextTo(n, n2);
        }
    }

    private int constructOverlayTile(int[][] nArray, int n, int n2, int n3) {
        int n4 = 0;
        if ((nArray[n][n2] & 1) != 0) {
            n4 |= 1;
        } else if ((nArray[n][n2] & 8) != 0) {
            n4 = this.isPiece(n3) ? (n4 |= 2) : (n4 |= this.checkDir(nArray, n, n2, 8, 0));
        }
        if ((nArray[n][n2] & 2) != 0) {
            n4 |= 0x100;
        } else if ((nArray[n][n2] & 0x10) != 0) {
            n4 = this.isPiece(n3) ? (n4 |= 0x200) : (n4 |= this.checkDir(nArray, n, n2, 16, 8));
        }
        if ((nArray[n][n2] & 4) != 0) {
            n4 |= this.checkDir(nArray, n, n2, 4, 16);
        }
        return n4;
    }

    private boolean isPiece(int n) {
        return n >= 6 && n <= 29;
    }

    private int checkDir(int[][] nArray, int n, int n2, int n3, int n4) {
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (n2 > 0 && (nArray[n][n2 - 1] & n3) != 0) {
            bl = true;
        }
        if (n2 < this.overlay[0].length - 1 && (nArray[n][n2 + 1] & n3) != 0) {
            bl2 = true;
        }
        if (n < this.overlay.length - 1 && (nArray[n + 1][n2] & n3) != 0) {
            bl3 = true;
        }
        if (n > 0 && (nArray[n - 1][n2] & n3) != 0) {
            bl4 = true;
        }
        if (bl3 && bl4) {
            n5 = 4;
            if (n4 != -1 && (bl && this.fromNorth(nArray, n, n2, n3) || bl2 && this.fromSouth(nArray, n, n2, n3))) {
                n5 = 5;
            }
        } else if (bl && bl2) {
            n5 = bl3 && bl4 ? 5 : 3;
        } else if (bl3) {
            n5 = 8;
            if (n4 != -1) {
                if (bl && this.fromNorth(nArray, n, n2, n3)) {
                    n5 = 6;
                } else if (bl2 && this.fromSouth(nArray, n, n2, n3)) {
                    n5 = 6;
                }
            }
        } else if (bl4) {
            n5 = 9;
            if (n4 != -1) {
                if (bl && this.fromNorth(nArray, n, n2, n3)) {
                    n5 = 6;
                } else if (bl2 && this.fromSouth(nArray, n, n2, n3)) {
                    n5 = 6;
                }
            }
        } else if (bl) {
            n5 = 6;
        } else if (bl2) {
            n5 = 7;
        }
        if (n4 == -1) {
            n4 = 0;
        }
        return n5 << n4;
    }

    private boolean fromNorth(int[][] nArray, int n, int n2, int n3) {
        int n4 = this.checkDir(nArray, n, n2 - 1, n3, -1);
        return n4 == 7 || n4 == 3 || n4 == 5;
    }

    private boolean fromSouth(int[][] nArray, int n, int n2, int n3) {
        int n4 = this.checkDir(nArray, n, n2 + 1, n3, -1);
        return n4 == 6 || n4 == 3 || n4 == 5;
    }

    private void addAnimationsFor(int n, int n2, int n3) {
        int n4 = this.overlay[n][n2] & 0xFF;
        int n5 = this.overlay[n][n2] & 0xFF00;
        int n6 = this.overlay[n][n2] & 0xFF0000;
        int n7 = n3 & 0xFF;
        int n8 = n3 & 0xFF00;
        int n9 = n3 & 0xFF0000;
        int[] nArray = new int[]{n7, n8, n9};
        boolean[] blArray = new boolean[]{n7 != 0, n8 != 0, n9 != 0};
        boolean bl = false;
        if (n4 == n7) {
            nArray[0] = -1;
        } else {
            bl = true;
            if (!blArray[0]) {
                nArray[0] = n4;
            }
        }
        if (n5 == n8) {
            nArray[1] = -1;
        } else {
            bl = true;
            if (!blArray[1]) {
                nArray[1] = n5;
            }
        }
        if (n6 == n9) {
            nArray[2] = -1;
        } else {
            bl = true;
            if (!blArray[2]) {
                nArray[2] = n6;
            }
        }
        if (bl) {
            this.pendingAnimations[n][n2] = new OverlayAnimation(n, n2, nArray, blArray);
        }
    }

    private synchronized void startAnimation(OverlayAnimation overlayAnimation) {
        this.currentAnimations.add(overlayAnimation);
        int[] nArray = this.overlay[overlayAnimation.getX()];
        int n = overlayAnimation.getY();
        nArray[n] = nArray[n] & ~overlayAnimation.getMask();
        if (this.runner == null) {
            this.startAnimationLoop();
        }
    }

    private void startAnimationsNextTo(int n, int n2) {
        OverlayAnimation overlayAnimation;
        if (n2 > 0 && this.pendingAnimations[n][n2 - 1] != null) {
            overlayAnimation = this.pendingAnimations[n][n2 - 1];
            this.pendingAnimations[n][n2 - 1] = null;
            overlayAnimation.setDirection(6);
            this.startAnimation(overlayAnimation);
        }
        if (n2 < this.overlay[0].length - 1 && this.pendingAnimations[n][n2 + 1] != null) {
            overlayAnimation = this.pendingAnimations[n][n2 + 1];
            this.pendingAnimations[n][n2 + 1] = null;
            overlayAnimation.setDirection(7);
            this.startAnimation(overlayAnimation);
        }
        if (n < this.overlay.length - 1 && this.pendingAnimations[n + 1][n2] != null) {
            overlayAnimation = this.pendingAnimations[n + 1][n2];
            this.pendingAnimations[n + 1][n2] = null;
            overlayAnimation.setDirection(8);
            this.startAnimation(overlayAnimation);
        }
        if (n > 0 && this.pendingAnimations[n - 1][n2] != null) {
            overlayAnimation = this.pendingAnimations[n - 1][n2];
            this.pendingAnimations[n - 1][n2] = null;
            overlayAnimation.setDirection(9);
            this.startAnimation(overlayAnimation);
        }
    }

    public void run() {
        while (this.keepRunning()) {
            this.doLoop();
            try {
                Thread.sleep(40L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private synchronized void doLoop() {
        this.updateAnimations();
        this.paintAnimations();
    }

    private synchronized boolean keepRunning() {
        if (this.currentAnimations.isEmpty()) {
            this.runner = null;
            return false;
        }
        return true;
    }

    private synchronized void startAnimationLoop() {
        if (this.runner == null) {
            this.runner = new Thread(this);
            this.runner.start();
        }
    }

    private void updateAnimations() {
        Iterator<OverlayAnimation> iterator = this.currentAnimations.iterator();
        ArrayList<Point> arrayList = new ArrayList<Point>();
        int n = 0;
        while (iterator.hasNext()) {
            OverlayAnimation overlayAnimation = iterator.next();
            if (overlayAnimation.update()) {
                iterator.remove();
                if (overlayAnimation.isEntering(0) && overlayAnimation.getType(0) != -1) {
                    int[] nArray = this.overlay[overlayAnimation.getX()];
                    int n2 = overlayAnimation.getY();
                    nArray[n2] = nArray[n2] | overlayAnimation.getType(0);
                }
                if (overlayAnimation.isEntering(1) && overlayAnimation.getType(1) != -1) {
                    int[] nArray = this.overlay[overlayAnimation.getX()];
                    int n3 = overlayAnimation.getY();
                    nArray[n3] = nArray[n3] | overlayAnimation.getType(1);
                }
                if (overlayAnimation.isEntering(2) && overlayAnimation.getType(2) != -1) {
                    int[] nArray = this.overlay[overlayAnimation.getX()];
                    int n4 = overlayAnimation.getY();
                    nArray[n4] = nArray[n4] | overlayAnimation.getType(2);
                }
                arrayList.add(new Point(overlayAnimation.getX(), overlayAnimation.getY()));
            }
            ++n;
        }
        for (Point point : arrayList) {
            this.startAnimationsNextTo(point.x, point.y);
        }
        while (n < this.currentAnimations.size()) {
            this.currentAnimations.get(n).update();
            ++n;
        }
    }

    private void paintAnimations() {
        Graphics2D graphics2D = this.gui.getOverlayGraphics();
        this.paint(graphics2D);
        for (OverlayAnimation overlayAnimation : this.currentAnimations) {
            overlayAnimation.paint(graphics2D, this);
        }
        this.gui.updateOverlay();
    }

    public void paint(Graphics2D graphics2D) {
        graphics2D.setComposite(this.transparent);
        graphics2D.fillRect(0, 0, 480, 480);
        graphics2D.setComposite(this.opaque);
        for (int i = 0; i < this.overlay.length; ++i) {
            for (int j = 0; j < this.overlay[0].length; ++j) {
                this.drawTile(graphics2D, i * 24, j * 24, this.overlay[i][j]);
                if (!Main.DEBUG_GRID || this.pendingAnimations[i][j] == null) continue;
                graphics2D.setColor(Color.yellow);
                graphics2D.fillOval(i * 24, j * 24, 5, 5);
            }
        }
    }

    private void drawTile(Graphics2D graphics2D, int n, int n2, int n3) {
        int n4 = n3 & 0xFF;
        int n5 = n3 & 0xFF00;
        int n6 = n3 & 0xFF0000;
        if (GameGrid.showChecks) {
            if (n4 != 0) {
                graphics2D.setColor(this.whiteColor);
                if (n4 == 2) {
                    return;
                }
                if (n4 == 1) {
                    return;
                }
                this.drawInfluence(graphics2D, n, n2, n4, 1);
            }
            if (n5 != 0) {
                graphics2D.setColor(this.blackColor);
                if (n5 == 512) {
                    return;
                }
                if (n5 == 256) {
                    return;
                }
                this.drawInfluence(graphics2D, n, n2, n5 >> 8, -1);
            }
        }
        if (GameGrid.showScramble && n6 != 0) {
            graphics2D.setColor(this.scrambleColor);
            this.drawScramble(graphics2D, n, n2, n6 >> 16);
        }
    }

    private void drawInfluence(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        graphics2D.setStroke(this.influenceStroke);
        this.drawDir(graphics2D, n, n2, n3, n4);
    }

    private void drawScramble(Graphics2D graphics2D, int n, int n2, int n3) {
        graphics2D.setStroke(this.scrambleStroke);
        this.drawDir(graphics2D, n, n2, n3, 0);
    }

    private void drawDir(Graphics2D graphics2D, int n, int n2, int n3, int n4) {
        switch (n3) {
            case 3: {
                graphics2D.drawLine(n + 12 + n4, n2 + n4, n + 12 + n4, n2 + 24 + n4);
                break;
            }
            case 4: {
                graphics2D.drawLine(n + n4, n2 + 12 + n4, n + 24 + n4, n2 + 12 + n4);
                break;
            }
            case 5: {
                graphics2D.drawLine(n + 12 + n4, n2 + n4, n + 12 + n4, n2 + 24 + n4);
                graphics2D.drawLine(n + n4, n2 + 12 + n4, n + 24 + n4, n2 + 12 + n4);
                break;
            }
            case 6: {
                graphics2D.drawLine(n + 12 + n4, n2 + n4, n + 12 + n4, n2 + 16 + n4);
                break;
            }
            case 7: {
                graphics2D.drawLine(n + 12 + n4, n2 + 8 + n4, n + 12 + n4, n2 + 24 + n4);
                break;
            }
            case 8: {
                graphics2D.drawLine(n + 8 + n4, n2 + 12 + n4, n + 24 + n4, n2 + 12 + n4);
                break;
            }
            case 9: {
                graphics2D.drawLine(n + n4, n2 + 12 + n4, n + 16 + n4, n2 + 12 + n4);
            }
        }
    }

    public void drawTilePartial(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        if (n4 == 0) {
            return;
        }
        n *= 24;
        n2 *= 24;
        if (GameGrid.showChecks) {
            if ((n3 & 0xFF) != 0) {
                graphics2D.setColor(this.whiteColor);
                if (n3 == 2) {
                    if (n4 == 1) {
                        graphics2D.fillRect(n + 12, n2 + 12, 6, 6);
                    } else if (n4 == 2) {
                        graphics2D.drawRect(n + 7, n2 + 7, 10, 10);
                    } else if (n4 == 3) {
                        graphics2D.drawRect(n + 2, n2 + 2, 20, 20);
                    }
                } else if (n3 == 1) {
                    if (n4 == 1) {
                        graphics2D.fillOval(n + 12, n2 + 12, 6, 6);
                    } else if (n4 == 2) {
                        graphics2D.drawOval(n + 4, n2 + 4, 16, 16);
                    } else if (n4 == 3) {
                        graphics2D.drawOval(n + 1, n2 + 1, 22, 22);
                    }
                } else if (n4 >= 3) {
                    this.drawTile(graphics2D, n, n2, n3);
                } else {
                    this.drawInfluencePartial(graphics2D, n, n2, n3, 1, n4, n5);
                }
            }
            if ((n3 & 0xFF00) != 0) {
                graphics2D.setColor(this.blackColor);
                if (n3 == 512) {
                    if (n4 == 1) {
                        graphics2D.fillRect(n + 12, n2 + 12, 6, 6);
                    } else if (n4 == 2) {
                        graphics2D.drawRect(n + 7, n2 + 7, 10, 10);
                    } else if (n4 == 3) {
                        graphics2D.drawRect(n + 2, n2 + 2, 20, 20);
                    }
                } else if (n3 == 256) {
                    if (n4 == 1) {
                        graphics2D.fillOval(n + 12, n2 + 12, 6, 6);
                    } else if (n4 == 2) {
                        graphics2D.drawOval(n + 4, n2 + 4, 16, 16);
                    } else if (n4 == 3) {
                        graphics2D.drawOval(n + 1, n2 + 1, 22, 22);
                    }
                } else if (n4 >= 3) {
                    this.drawTile(graphics2D, n, n2, n3);
                } else {
                    this.drawInfluencePartial(graphics2D, n, n2, n3 >> 8, -1, n4, n5);
                }
            }
        }
        if (GameGrid.showScramble) {
            if (n4 >= 3) {
                this.drawTile(graphics2D, n, n2, n3);
                return;
            }
            if ((n3 & 0xFF0000) != 0) {
                graphics2D.setColor(this.scrambleColor);
                this.drawScramble(graphics2D, n, n2, n3 >> 16, n4, n5);
            }
        }
    }

    private void drawInfluencePartial(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        graphics2D.setStroke(this.influenceStroke);
        this.drawDirPartial(graphics2D, n, n2, n3, n4, n5, n6);
    }

    private void drawScramble(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5) {
        graphics2D.setStroke(this.scrambleStroke);
        this.drawDirPartial(graphics2D, n, n2, n3, 0, n4, n5);
    }

    private void drawDirPartial(Graphics2D graphics2D, int n, int n2, int n3, int n4, int n5, int n6) {
        switch (n3) {
            case 3: {
                if (n6 == 8 || n6 == 9) {
                    this.drawPartialFrom(6, graphics2D, n, n2, n4, n5);
                    break;
                }
                this.drawPartialFrom(n6, graphics2D, n, n2, n4, n5);
                break;
            }
            case 4: {
                if (n6 == 6 || n6 == 7) {
                    this.drawPartialFrom(8, graphics2D, n, n2, n4, n5);
                    break;
                }
                this.drawPartialFrom(n6, graphics2D, n, n2, n4, n5);
                break;
            }
            case 5: {
                this.drawPartialFrom(n6 == 7 ? 7 : 6, graphics2D, n, n2, n4, n5);
                this.drawPartialFrom(n6 == 9 ? 9 : 8, graphics2D, n, n2, n4, n5);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.drawPartialFrom(n3, graphics2D, n, n2, n4, n5);
            }
        }
    }

    private void drawPartialFrom(int n, Graphics2D graphics2D, int n2, int n3, int n4, int n5) {
        switch (n) {
            case 6: {
                graphics2D.drawLine(n2 + 12 + n4, n3 + (24 - 8 * n5) + n4, n2 + 12 + n4, n3 + 24 + n4);
                break;
            }
            case 7: {
                graphics2D.drawLine(n2 + 12 + n4, n3 + n4, n2 + 12 + n4, n3 + 8 * n5 + n4);
                break;
            }
            case 8: {
                graphics2D.drawLine(n2 + n4, n3 + 12 + n4, n2 + 8 * n5 + n4, n3 + 12 + n4);
                break;
            }
            case 9: {
                graphics2D.drawLine(n2 + (24 - 8 * n5) + n4, n3 + 12 + n4, n2 + 24 + n4, n3 + 12 + n4);
            }
        }
    }
}

