/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.GridOverlay;
import java.awt.Graphics2D;

public class OverlayAnimation {
    private int[] type;
    private int[] frame;
    private int x;
    private int y;
    private boolean[] entering;
    private int dir = 0;

    public OverlayAnimation(int n, int n2, int[] nArray, boolean[] blArray) {
        this.x = n;
        this.y = n2;
        this.type = nArray;
        this.entering = blArray;
        this.frame = new int[3];
        this.frame[0] = blArray[0] ? 0 : 3;
        this.frame[1] = blArray[1] ? 0 : 3;
        this.frame[2] = blArray[2] ? 0 : 3;
    }

    public int getType(int n) {
        return this.type[n];
    }

    public int getMask() {
        int n = 0;
        if (this.type[0] != -1) {
            n |= 0xFF;
        }
        if (this.type[1] != -1) {
            n |= 0xFF00;
        }
        if (this.type[2] != -1) {
            n |= 0xFF0000;
        }
        return n;
    }

    public boolean isEntering(int n) {
        return this.entering[n];
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public void setDirection(int n) {
        this.dir = n;
    }

    public boolean update() {
        boolean bl = false;
        if (this.entering[0]) {
            this.frame[0] = this.frame[0] + 1;
            if (this.frame[0] > 3) {
                bl = true;
            }
        } else {
            this.frame[0] = this.frame[0] - 1;
            if (this.frame[0] < 0) {
                bl = true;
            }
        }
        if (this.entering[1]) {
            this.frame[1] = this.frame[1] + 1;
            if (this.frame[1] > 3) {
                bl = true;
            }
        } else {
            this.frame[1] = this.frame[1] - 1;
            if (this.frame[1] < 0) {
                bl = true;
            }
        }
        if (this.entering[2]) {
            this.frame[2] = this.frame[2] + 1;
            if (this.frame[2] > 3) {
                bl = true;
            }
        } else {
            this.frame[2] = this.frame[2] - 1;
            if (this.frame[2] < 0) {
                bl = true;
            }
        }
        return bl;
    }

    public void paint(Graphics2D graphics2D, GridOverlay gridOverlay) {
        if (this.type[0] != -1) {
            gridOverlay.drawTilePartial(graphics2D, this.x, this.y, this.type[0], this.frame[0], this.entering[0] ? this.dir : this.oposite(this.dir));
        }
        if (this.type[1] != -1) {
            gridOverlay.drawTilePartial(graphics2D, this.x, this.y, this.type[1], this.frame[1], this.entering[1] ? this.dir : this.oposite(this.dir));
        }
        if (this.type[2] != -1) {
            gridOverlay.drawTilePartial(graphics2D, this.x, this.y, this.type[2], this.frame[2], this.entering[2] ? this.dir : this.oposite(this.dir));
        }
    }

    private int oposite(int n) {
        if (n == 6) {
            return 7;
        }
        if (n == 7) {
            return 6;
        }
        if (n == 8) {
            return 9;
        }
        if (n == 9) {
            return 8;
        }
        return n;
    }
}

