/*
 * Decompiled with CFR 0.152.
 */
package gui;

import game.GameGrid;
import game.GridOverlay;
import gui.Main;
import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import net.NetGame;

public class GridPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener {
    private GameGrid grid;
    private GridOverlay overlay = null;
    private NetGame net = null;
    private BufferedImage gameBuffer = new BufferedImage(480, 480, 1);
    private BufferedImage overlayBuffer = new BufferedImage(480, 480, 2);
    private AlphaComposite overlayBlend = AlphaComposite.getInstance(3, 0.5f);

    public GridPanel() {
        this.setPreferredSize(new Dimension(480, 480));
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void setGameGrid(GameGrid gameGrid) {
        this.grid = gameGrid;
    }

    public void setNetGame(NetGame netGame) {
        this.net = netGame;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        this.grid.paint(this.gameBuffer.getGraphics(), this);
        graphics.drawImage(this.gameBuffer, 0, 0, this);
        if (this.overlay != null) {
            this.overlay.paint((Graphics2D)this.overlayBuffer.getGraphics());
            ((Graphics2D)graphics).setComposite(this.overlayBlend);
            graphics.drawImage(this.overlayBuffer, 0, 0, this);
        }
    }

    public Graphics2D getOverlayGraphics() {
        return (Graphics2D)this.overlayBuffer.getGraphics();
    }

    public void updateOverlay() {
        Graphics graphics = this.getGraphics();
        graphics.drawImage(this.gameBuffer, 0, 0, this);
        if (this.overlay != null) {
            ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, 0.5f));
            graphics.drawImage(this.overlayBuffer, 0, 0, this);
        }
    }

    public void setOverlay(GridOverlay gridOverlay) {
        this.overlay = gridOverlay;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.net != null && !this.net.myTurn()) {
            return;
        }
        int n = this.grid.getItemX();
        int n2 = this.grid.getItemY();
        int n3 = this.grid.getSelectedItem();
        if (this.grid.placeItem()) {
            if (this.net != null) {
                this.net.sendPlaceItem(n3, n, n2);
            }
            this.repaint();
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        if (this.net != null && !this.net.myTurn()) {
            return;
        }
        int n2 = mouseEvent.getX() / 24;
        if (this.grid.setMouseLocation(n2, n = mouseEvent.getY() / 24)) {
            this.repaint();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (this.net != null && !this.net.myTurn()) {
            return;
        }
        char c = keyEvent.getKeyChar();
        if (this.grid.selectItem(c)) {
            this.repaint();
        }
        if (c == 'D') {
            Main.DEBUG_GRID = !Main.DEBUG_GRID;
            this.repaint();
        }
    }

    public void selectItem(char c) {
        if (this.net != null && !this.net.myTurn()) {
            return;
        }
        if (this.grid.selectItem(c)) {
            this.repaint();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (this.net != null && !this.net.myTurn()) {
            return;
        }
        int n = keyEvent.getKeyCode();
        if (n == 38) {
            if (this.grid.selectItem('1')) {
                this.repaint();
            }
        } else if (n == 40) {
            if (this.grid.selectItem('2')) {
                this.repaint();
            }
        } else if (n == 39) {
            if (this.grid.selectItem('3')) {
                this.repaint();
            }
        } else if (n == 37 && this.grid.selectItem('4')) {
            this.repaint();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

