/*
 * Decompiled with CFR 0.152.
 */
package gui;

import game.Maps;
import gui.Main;
import gui.NetPanel;
import gui.NumericTextInputVerifier;
import gui.PeerList;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.NetConnector;
import net.NetGame;

public class HostPane
extends JPanel
implements ActionListener {
    private PeerList peerList = new PeerList();
    private JComboBox mapName = new JComboBox<String>(Maps.getMapList());
    private JTextField portF = new JTextField("2379", 5);
    private JCheckBox firstCB = new JCheckBox("I go first", true);
    private JTextField pwdF = new JTextField("", 10);
    private JButton startB;
    private JButton cancelB;
    private Main reportTo;
    private NetConnector netConnector;
    private NetPanel netPanel;
    private NetGame hostingNetGame = null;

    public HostPane(Main main, NetPanel netPanel, NetConnector netConnector) {
        this.setLayout(new BoxLayout(this, 1));
        this.reportTo = main;
        this.netConnector = netConnector;
        this.netPanel = netPanel;
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(new JLabel("Map: "));
        jPanel.add(this.mapName);
        this.add(jPanel);
        this.portF.setInputVerifier(new NumericTextInputVerifier(1, 65535));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel("Port: "));
        jPanel2.add(this.portF);
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(this.firstCB);
        this.add(jPanel3);
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.add(new JLabel("Pwd: "));
        jPanel4.add(this.pwdF);
        this.add(jPanel4);
        JPanel jPanel5 = new JPanel(new FlowLayout(2));
        this.cancelB = new JButton("Cancel");
        this.cancelB.setEnabled(false);
        jPanel5.add(this.cancelB);
        this.startB = new JButton("Host");
        jPanel5.add(this.startB);
        this.add(jPanel5);
        this.cancelB.addActionListener(this);
        this.startB.addActionListener(this);
        this.mapName.addActionListener(this);
        this.portF.setText("" + netConnector.getGamePort());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.cancelB) {
            this.cancelPressed();
        } else if (object == this.startB) {
            this.startPressed();
        } else if (object == this.mapName) {
            this.netConnector.setMapName((String)this.mapName.getSelectedItem());
        }
    }

    private void startPressed() {
        int n = 0;
        try {
            n = Integer.parseInt(this.portF.getText());
        }
        catch (NumberFormatException numberFormatException) {
            Toolkit.getDefaultToolkit().beep();
            this.portF.selectAll();
            this.portF.requestFocus();
            return;
        }
        this.netConnector.setGamePort(n);
        this.netConnector.setHostGoesFirst(this.firstCB.isSelected());
        this.disableHostFields();
        this.netConnector.open();
        this.netConnector.setStatusHosting();
        this.hostingNetGame = this.reportTo.makeHostGame();
        new Thread(){

            public void run() {
                String string = HostPane.this.pwdF.getText();
                if (string.equals("")) {
                    string = null;
                }
                if (HostPane.this.reportTo.startHostedGame(HostPane.this.netConnector.getMapName(), HostPane.this.netConnector.getGamePort(), HostPane.this.netConnector.getHostGoesFirst(), string)) {
                    HostPane.this.netConnector.setStatusPlaying();
                } else {
                    HostPane.this.netConnector.setStatusWaiting();
                    HostPane.this.enableHostFields();
                }
            }
        }.start();
    }

    private void cancelPressed() {
        this.netConnector.setStatusWaiting();
        if (this.hostingNetGame != null) {
            this.hostingNetGame.cancelConnection();
        }
        this.enableHostFields();
    }

    private void disableHostFields() {
        this.mapName.setEnabled(false);
        this.portF.setEnabled(false);
        this.pwdF.setEnabled(false);
        this.firstCB.setEnabled(false);
        this.startB.setEnabled(false);
        this.cancelB.setEnabled(true);
        this.netPanel.setStateHosting();
    }

    private void enableHostFields() {
        this.mapName.setEnabled(true);
        this.portF.setEnabled(true);
        this.pwdF.setEnabled(true);
        this.firstCB.setEnabled(true);
        this.startB.setEnabled(true);
        this.cancelB.setEnabled(false);
        this.netPanel.setStateWaiting();
    }
}

