/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.GridPanel;
import gui.ThemeSettings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import util.GMedia;

public class ItemsToolbar
extends JToolBar
implements ActionListener {
    private JButton singleN;
    private JButton singleS;
    private JButton singleE;
    private JButton singleW;
    private JButton doubleNS;
    private JButton doubleEW;
    private JButton quad;
    private JButton bomb;
    private JButton power;
    private JButton scramblerNS;
    private JButton scramblerEW;
    private GridPanel gridp;
    private String theme = "space";
    private String player = "W";

    public ItemsToolbar(GridPanel gridPanel) {
        super("Items", 1);
        this.gridp = gridPanel;
        this.setFloatable(false);
        this.setBackground(ThemeSettings.getGUIColor(this.theme));
        this.singleN = new JButton(new ImageIcon(GMedia.getImage("spaceWsingleN")));
        this.singleN.setToolTipText("Single North");
        this.singleN.addActionListener(this);
        this.add(this.singleN);
        this.singleS = new JButton(new ImageIcon(GMedia.getImage("spaceWsingleS")));
        this.singleS.setToolTipText("Single South");
        this.singleS.addActionListener(this);
        this.add(this.singleS);
        this.singleE = new JButton(new ImageIcon(GMedia.getImage("spaceWsingleE")));
        this.singleE.setToolTipText("Single East");
        this.singleE.addActionListener(this);
        this.add(this.singleE);
        this.singleW = new JButton(new ImageIcon(GMedia.getImage("spaceWsingleW")));
        this.singleW.setToolTipText("Single West");
        this.singleW.addActionListener(this);
        this.add(this.singleW);
        this.doubleNS = new JButton(new ImageIcon(GMedia.getImage("spaceWdoubleNS")));
        this.doubleNS.setToolTipText("Double North-South");
        this.doubleNS.addActionListener(this);
        this.add(this.doubleNS);
        this.doubleEW = new JButton(new ImageIcon(GMedia.getImage("spaceWdoubleEW")));
        this.doubleEW.setToolTipText("Double East-West");
        this.doubleEW.addActionListener(this);
        this.add(this.doubleEW);
        this.quad = new JButton(new ImageIcon(GMedia.getImage("spaceWquad")));
        this.quad.setToolTipText("Quad");
        this.quad.addActionListener(this);
        this.add(this.quad);
        this.bomb = new JButton(new ImageIcon(GMedia.getImage("spaceWbomb")));
        this.bomb.setToolTipText("Bomb");
        this.bomb.addActionListener(this);
        this.add(this.bomb);
        this.power = new JButton(new ImageIcon(GMedia.getImage("spaceWpower")));
        this.power.setToolTipText("Power Plant");
        this.power.addActionListener(this);
        this.add(this.power);
        this.scramblerNS = new JButton(new ImageIcon(GMedia.getImage("spaceWscramblerNS")));
        this.scramblerNS.setToolTipText("Scrambler North-South");
        this.scramblerNS.addActionListener(this);
        this.add(this.scramblerNS);
        this.scramblerEW = new JButton(new ImageIcon(GMedia.getImage("spaceWscramblerEW")));
        this.scramblerEW.setToolTipText("Scrambler East-West");
        this.scramblerEW.addActionListener(this);
        this.add(this.scramblerEW);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.singleN) {
            this.gridp.selectItem('1');
        } else if (object == this.singleS) {
            this.gridp.selectItem('2');
        } else if (object == this.singleE) {
            this.gridp.selectItem('3');
        } else if (object == this.singleW) {
            this.gridp.selectItem('4');
        } else if (object == this.doubleNS) {
            this.gridp.selectItem('5');
        } else if (object == this.doubleEW) {
            this.gridp.selectItem('6');
        } else if (object == this.quad) {
            this.gridp.selectItem('7');
        } else if (object == this.bomb) {
            this.gridp.selectItem('8');
        } else if (object == this.power) {
            this.gridp.selectItem('9');
        } else if (object == this.scramblerNS) {
            this.gridp.selectItem('0');
        } else if (object == this.scramblerEW) {
            this.gridp.selectItem('-');
        }
        this.gridp.requestFocus();
    }

    public void enableForPower(int n) {
        this.singleN.setEnabled(n >= 1);
        this.singleS.setEnabled(n >= 1);
        this.singleE.setEnabled(n >= 1);
        this.singleW.setEnabled(n >= 1);
        this.doubleNS.setEnabled(n >= 2);
        this.doubleEW.setEnabled(n >= 2);
        this.bomb.setEnabled(n >= 2);
        this.quad.setEnabled(n >= 4);
        this.scramblerNS.setEnabled(n >= 4);
        this.scramblerEW.setEnabled(n >= 4);
        this.power.setEnabled(n >= 0);
    }

    public void setTheme(String string) {
        this.theme = string;
        this.setBackground(ThemeSettings.getGUIColor(string));
        this.updateIcons();
    }

    public void setPlayer(boolean bl) {
        this.player = bl ? "W" : "B";
        this.updateIcons();
    }

    private void updateIcons() {
        this.singleN.setIcon(new ImageIcon(GMedia.getImage(this.theme + this.player + "singleN")));
        this.singleS.setIcon(new ImageIcon(GMedia.getImage(this.theme + this.player + "singleS")));
        this.singleE.setIcon(new ImageIcon(GMedia.getImage(this.theme + this.player + "singleE")));
        this.singleW.setIcon(new ImageIcon(GMedia.getImage(this.theme + this.player + "singleW")));
        this.doubleNS.setIcon(new ImageIcon(GMedia.getImage(this.theme + this.player + "doubleNS")));
        this.doubleEW.setIcon(new ImageIcon(GMedia.getImage(this.theme + this.player + "doubleEW")));
        this.quad.setIcon(new ImageIcon(GMedia.getImage(this.theme + this.player + "quad")));
        this.bomb.setIcon(new ImageIcon(GMedia.getImage(this.theme + this.player + "bomb")));
        this.power.setIcon(new ImageIcon(GMedia.getImage(this.theme + this.player + "power")));
        this.scramblerNS.setIcon(new ImageIcon(GMedia.getImage(this.theme + this.player + "scramblerNS")));
        this.scramblerEW.setIcon(new ImageIcon(GMedia.getImage(this.theme + this.player + "scramblerEW")));
    }
}

