/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Main;
import gui.NonNullTextInputVerifier;
import gui.NumericTextInputVerifier;
import java.awt.FlowLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.NetConnector;
import net.PeerInfo;

public class JoinPane
extends JPanel
implements ActionListener,
ListSelectionListener,
Observer {
    private JTextField hostF = new JTextField("127.0.0.1", 10);
    private JTextField portF = new JTextField("2379", 5);
    private JLabel mapL = new JLabel("Map: --none--");
    private JTextField pwdF = new JTextField("", 10);
    private JButton joinB = new JButton("Join");
    private Main reportTo;
    private NetConnector netConnector;
    private PeerInfo currentPeer = null;

    public JoinPane(Main main, NetConnector netConnector) {
        this.setLayout(new BoxLayout(this, 1));
        this.reportTo = main;
        this.netConnector = netConnector;
        this.hostF.setInputVerifier(new NonNullTextInputVerifier(20));
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(new JLabel("Host: "));
        jPanel.add(this.hostF);
        this.add(jPanel);
        this.portF.setInputVerifier(new NumericTextInputVerifier(1, 65535));
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel("Port: "));
        jPanel2.add(this.portF);
        this.add(jPanel2);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(new JLabel("Pwd: "));
        jPanel3.add(this.pwdF);
        this.add(jPanel3);
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.add(this.mapL);
        this.add(jPanel4);
        JPanel jPanel5 = new JPanel(new FlowLayout(2));
        jPanel5.add(this.joinB);
        this.add(jPanel5);
        this.joinB.addActionListener(this);
        netConnector.addObserver(this);
        this.portF.setText("" + netConnector.getGamePort());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.joinB) {
            this.joinPressed();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        PeerInfo peerInfo = (PeerInfo)((JList)listSelectionEvent.getSource()).getSelectedValue();
        if (peerInfo == null) {
            this.clearPeerInfo();
        } else {
            this.netConnector.sendGetInfo(peerInfo);
            this.showPeerInfo(peerInfo);
        }
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof NetConnector && object instanceof PeerInfo && this.currentPeer == object) {
            this.showPeerInfo((PeerInfo)object);
        }
    }

    private void joinPressed() {
        new Thread(){

            public void run() {
                int n = 0;
                try {
                    n = Integer.parseInt(JoinPane.this.portF.getText());
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    JoinPane.this.portF.selectAll();
                    JoinPane.this.portF.requestFocus();
                    return;
                }
                String string = JoinPane.this.hostF.getText();
                String string2 = JoinPane.this.pwdF.getText();
                if (string2.equals("")) {
                    string2 = null;
                }
                if (JoinPane.this.reportTo.startJoinedGame(string, n, string2)) {
                    JoinPane.this.netConnector.setStatusPlaying();
                }
            }
        }.start();
    }

    private void clearPeerInfo() {
        this.mapL.setText("Map: --none--");
        this.currentPeer = null;
    }

    private void showPeerInfo(PeerInfo peerInfo) {
        this.currentPeer = peerInfo;
        this.hostF.setText("");
        this.portF.setText("");
        this.hostF.setText(peerInfo.addr.getHostName());
        this.portF.setText("" + peerInfo.game.gamePort);
        this.mapL.setText("Map: " + peerInfo.game.mapName);
    }

    public void setGUIEnabled(boolean bl) {
        this.hostF.setEnabled(bl);
        this.portF.setEnabled(bl);
        this.pwdF.setEnabled(bl);
        this.joinB.setEnabled(bl);
    }
}

