/*
 * Decompiled with CFR 0.152.
 */
package gui;

import game.GameGrid;
import gui.AppletWrapper;
import gui.GridPanel;
import gui.InGameChatPanel;
import gui.ItemsMenu;
import gui.ItemsToolbar;
import gui.NetPanel;
import gui.OptionDialog;
import gui.SidePanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import net.NetConnector;
import net.NetGame;
import util.GMedia;

public class Main
extends JFrame
implements ActionListener,
ItemListener {
    private static String mediaRoot = "Media/";
    private GridPanel gridp;
    private GameGrid grid;
    private NetGame net = null;
    private NetConnector netConnector = null;
    private static boolean musicEnabled = false;
    public static boolean DEBUG_GRID = false;
    private JLabel statL = new JLabel("Select New Game from the Game menu to begin");
    private OptionDialog optsD = new OptionDialog(this);
    private JFrame helpF = null;
    private JPanel contentP;
    private SidePanel sidePanel;
    private JMenuItem newGameMI;
    private JMenuItem netGameMI;
    private JMenuItem abortGameMI;
    private JMenuItem quitMI;
    private ItemsMenu itemsM;
    private ItemsToolbar itemsTB;
    private JMenuItem optionsMI;
    private JMenuItem helpMI;
    private JCheckBoxMenuItem gridMI;
    private JCheckBoxMenuItem scrambleMI;
    private JCheckBoxMenuItem soundsMI;
    private JCheckBoxMenuItem musicMI;
    private JRadioButtonMenuItem spaceMI;
    private JRadioButtonMenuItem paperMI;
    private JRadioButtonMenuItem woodMI;
    private boolean hasSetTheme = false;
    private static Frame f = null;
    private static final String[] soundFileNames = new String[]{"NetMyTurn.wav", "GameOver.wav", "NetGameLost.wav", "Ignite.wav", "PlaceBomb.wav", "Bomb.wav", "Burnt.wav", "PlacePiece.wav", "PlaceScrambler.wav", "PlacePower.wav"};

    public static void main(String[] stringArray) {
        if (stringArray.length > 0) {
            mediaRoot = stringArray[0];
        }
        Main.showWaitFrame("Paper Grid", "  Loading . . .  ", null);
        Main main = new Main();
        Main.hideWaitFrame();
        main.setVisible(true);
        if (musicEnabled) {
            GMedia.loopSound("music");
        }
    }

    public static void showWaitFrame(String string, String string2, ActionListener actionListener) {
        Serializable serializable;
        Serializable serializable2;
        if (f != null) {
            return;
        }
        f = new Frame(string);
        JLabel jLabel = new JLabel(string2);
        f.setBackground(Color.black);
        jLabel.setForeground(Color.green);
        jLabel.setHorizontalAlignment(0);
        jLabel.setFont(new Font("Dialog", 48, 0));
        f.add("Center", jLabel);
        if (actionListener != null) {
            serializable2 = new JPanel(new FlowLayout(2));
            ((JComponent)serializable2).setBackground(Color.black);
            serializable = new JButton("Cancel");
            ((JComponent)serializable).setOpaque(false);
            ((Container)serializable2).add((Component)serializable);
            f.add("South", (Component)serializable2);
            ((AbstractButton)serializable).addActionListener(actionListener);
        }
        f.setSize(300, 100);
        f.setResizable(false);
        serializable2 = Toolkit.getDefaultToolkit().getScreenSize();
        serializable = f.getSize();
        f.setLocation((((Dimension)serializable2).width - ((Dimension)serializable).width) / 2, (((Dimension)serializable2).height - ((Dimension)serializable).height) / 2);
        f.setVisible(true);
    }

    public static void hideWaitFrame() {
        if (f == null) {
            return;
        }
        f.setVisible(false);
        f.dispose();
        f = null;
    }

    public Main() {
        super("Paper Grid");
        JMenuItem jMenuItem;
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (AppletWrapper.applet != null) {
            GMedia.applet = AppletWrapper.applet;
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Main.this.doQuit();
            }
        });
        GMedia.beginLoadImages(this);
        GMedia.addImage((Object)"splash", mediaRoot + "splash.jpg");
        GMedia.addImage((Object)"NetClose", mediaRoot + "close.jpg");
        this.loadThemeImages("space");
        this.loadThemeImages("paper");
        this.loadThemeImages("wood");
        if (!GMedia.finishLoadImages()) {
            this.showMessage("Couldn't load all graphics, some items may apear incorrectly.");
        }
        this.loadDefaultSounds();
        this.loadThemeSounds("space");
        this.loadThemeSounds("paper");
        this.loadThemeSounds("wood");
        this.contentP = new JPanel(new BorderLayout());
        this.getContentPane().add("Center", this.contentP);
        this.contentP.add("North", this.statL);
        this.gridp = new GridPanel();
        this.grid = new GameGrid(this, this.gridp);
        this.gridp.setGameGrid(this.grid);
        this.contentP.add("Center", this.gridp);
        JMenuBar jMenuBar = new JMenuBar();
        int n = 2;
        if (System.getProperty("os.name").indexOf("Mac") >= 0) {
            n = 4;
        }
        JMenu jMenu = new JMenu("Game");
        jMenu.setMnemonic('g');
        this.newGameMI = new JMenuItem("New Game...", 78);
        this.newGameMI.setAccelerator(KeyStroke.getKeyStroke(78, n));
        this.newGameMI.addActionListener(this);
        jMenu.add(this.newGameMI);
        this.netGameMI = new JMenuItem("Net Game...", 71);
        this.netGameMI.setAccelerator(KeyStroke.getKeyStroke(71, n));
        this.netGameMI.addActionListener(this);
        jMenu.add(this.netGameMI);
        jMenu.addSeparator();
        this.abortGameMI = new JMenuItem("Abort Game", 65);
        this.abortGameMI.setAccelerator(KeyStroke.getKeyStroke(65, n));
        this.abortGameMI.addActionListener(this);
        this.abortGameMI.setEnabled(false);
        jMenu.add(this.abortGameMI);
        if (!System.getProperty("os.name").equals("Mac OS X")) {
            jMenu.addSeparator();
            jMenuItem = new JMenuItem("Quit", 81);
            jMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, n));
            jMenuItem.addActionListener(this);
            jMenu.add(jMenuItem);
        }
        this.itemsM = new ItemsMenu(this.gridp);
        this.itemsM.setEnabled(false);
        jMenuItem = new JMenu("Options");
        jMenuItem.setMnemonic('o');
        this.optionsMI = new JMenuItem("Options...", 79);
        this.optionsMI.setAccelerator(KeyStroke.getKeyStroke(79, n));
        this.optionsMI.addActionListener(this);
        ((JMenu)jMenuItem).add(this.optionsMI);
        this.gridMI = new JCheckBoxMenuItem("Show Influence");
        this.gridMI.setAccelerator(KeyStroke.getKeyStroke(73, n));
        this.gridMI.setMnemonic('i');
        this.gridMI.setSelected(GameGrid.showChecks);
        this.gridMI.addItemListener(this);
        ((JMenu)jMenuItem).add(this.gridMI);
        this.scrambleMI = new JCheckBoxMenuItem("Show Scramble");
        this.scrambleMI.setAccelerator(KeyStroke.getKeyStroke(82, n));
        this.scrambleMI.setMnemonic('r');
        this.scrambleMI.setSelected(GameGrid.showScramble);
        this.scrambleMI.addItemListener(this);
        ((JMenu)jMenuItem).add(this.scrambleMI);
        ((JMenu)jMenuItem).addSeparator();
        JMenu jMenu2 = new JMenu("Themes");
        jMenu2.setMnemonic('t');
        ButtonGroup buttonGroup = new ButtonGroup();
        this.paperMI = new JRadioButtonMenuItem("Paper");
        this.paperMI.setMnemonic('p');
        this.paperMI.addActionListener(this);
        this.paperMI.setSelected("paper".equals("paper"));
        buttonGroup.add(this.paperMI);
        jMenu2.add(this.paperMI);
        this.spaceMI = new JRadioButtonMenuItem("Space");
        this.spaceMI.setMnemonic('s');
        this.spaceMI.setSelected("paper".equals("space"));
        this.spaceMI.addActionListener(this);
        buttonGroup.add(this.spaceMI);
        jMenu2.add(this.spaceMI);
        this.woodMI = new JRadioButtonMenuItem("Wood");
        this.woodMI.setMnemonic('w');
        this.woodMI.addActionListener(this);
        this.woodMI.setSelected("paper".equals("wood"));
        buttonGroup.add(this.woodMI);
        jMenu2.add(this.woodMI);
        ((JMenu)jMenuItem).add(jMenu2);
        this.soundsMI = new JCheckBoxMenuItem("Sound Enabled");
        this.soundsMI.setAccelerator(KeyStroke.getKeyStroke(83, n));
        this.soundsMI.setMnemonic('s');
        this.soundsMI.setSelected(GMedia.soundsEnabled);
        this.soundsMI.addItemListener(this);
        ((JMenu)jMenuItem).add(this.soundsMI);
        this.musicMI = new JCheckBoxMenuItem("Music Enabled");
        this.musicMI.setAccelerator(KeyStroke.getKeyStroke(77, n));
        this.musicMI.setMnemonic('m');
        this.musicMI.setSelected(musicEnabled);
        this.musicMI.addItemListener(this);
        ((JMenu)jMenuItem).add(this.musicMI);
        ((JMenu)jMenuItem).addSeparator();
        this.helpMI = new JMenuItem("Help", 72);
        this.helpMI.setAccelerator(KeyStroke.getKeyStroke(47, n));
        this.helpMI.addActionListener(this);
        ((JMenu)jMenuItem).add(this.helpMI);
        jMenuBar.add(jMenu);
        jMenuBar.add(this.itemsM);
        jMenuBar.add((JMenu)jMenuItem);
        this.setJMenuBar(jMenuBar);
        this.itemsTB = new ItemsToolbar(this.gridp);
        this.getContentPane().add("West", this.itemsTB);
        this.itemsTB.addKeyListener(this.gridp);
        this.contentP.addKeyListener(this.gridp);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.pack();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        this.setResizable(false);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.newGameMI) {
            this.doNewGame();
        } else if (object == this.netGameMI) {
            this.doNetGame();
        } else if (object == this.abortGameMI) {
            this.doAbort();
        } else if (object == this.quitMI) {
            this.doQuit();
        } else if (object == this.optionsMI) {
            this.doOptions();
        } else if (object == this.helpMI) {
            this.doHelp();
        } else if (object == this.spaceMI) {
            this.grid.setTheme("space");
            this.itemsTB.setTheme("space");
            this.hasSetTheme = true;
            this.gridp.repaint();
        } else if (object == this.paperMI) {
            this.grid.setTheme("paper");
            this.itemsTB.setTheme("paper");
            this.hasSetTheme = true;
            this.gridp.repaint();
        } else if (object == this.woodMI) {
            this.grid.setTheme("wood");
            this.itemsTB.setTheme("wood");
            this.hasSetTheme = true;
            this.gridp.repaint();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        if (object == this.gridMI) {
            GameGrid.showChecks = !GameGrid.showChecks;
            this.gridp.repaint();
        } else if (object == this.scrambleMI) {
            GameGrid.showScramble = !GameGrid.showScramble;
            this.gridp.repaint();
        } else if (object == this.soundsMI) {
            GMedia.soundsEnabled = this.soundsMI.getState();
        } else if (object == this.musicMI) {
            Main.setMusicEnabled(this.musicMI.getState());
        }
    }

    protected void doNewGame() {
        this.gridp.setNetGame(null);
        this.net = null;
        if (this.netConnector != null) {
            this.netConnector.close();
        }
        this.setSidePanel(null);
        if (!this.hasSetTheme) {
            this.itemsTB.setTheme("paper");
            this.grid.setTheme("paper");
            this.hasSetTheme = true;
        }
        this.grid.beginGame();
        this.gridp.repaint();
        this.gridp.requestFocus();
        Main.restartMusic(500L);
    }

    protected void doNetGame() {
        if (this.netConnector == null) {
            this.netConnector = new NetConnector();
        }
        this.setSidePanel(new NetPanel(this, this.netConnector));
        if (!this.hasSetTheme) {
            this.itemsTB.setTheme("paper");
            this.grid.setTheme("paper");
            this.hasSetTheme = true;
        }
    }

    public NetGame makeHostGame() {
        this.net = new NetGame(this.grid, this.gridp);
        return this.net;
    }

    public boolean startHostedGame(String string, int n, boolean bl, String string2) {
        if (this.net == null) {
            this.net = new NetGame(this.grid, this.gridp);
        }
        this.net.setPassword(string2);
        if (this.net.openHostGame(string, n, bl)) {
            this.setSidePanel(new InGameChatPanel(this.net));
            this.gridp.setNetGame(this.net);
            this.grid.beginGameOnMap();
            this.gridp.repaint();
            this.gridp.requestFocus();
            if (this.netConnector != null) {
                this.netConnector.setStatusPlaying();
            }
            Main.restartMusic(500L);
            return true;
        }
        this.net = null;
        return false;
    }

    public boolean startJoinedGame(String string, int n, String string2) {
        this.net = new NetGame(this.grid, this.gridp);
        this.net.setPassword(string2);
        if (this.net.openJoinGame(string, n)) {
            this.setSidePanel(new InGameChatPanel(this.net));
            this.gridp.setNetGame(this.net);
            this.grid.beginGameOnMap();
            this.gridp.repaint();
            this.gridp.requestFocus();
            if (this.netConnector != null) {
                this.netConnector.setStatusPlaying();
            }
            Main.restartMusic(500L);
            return true;
        }
        this.net = null;
        return false;
    }

    public boolean isNetworkGame() {
        return this.net != null;
    }

    protected void doAbort() {
        this.grid.abortGame();
        if (this.net != null) {
            this.net.closeGame();
            this.net = null;
            this.gridp.setNetGame(null);
        }
        this.gridp.repaint();
    }

    protected void doOptions() {
        if (this.grid.isPlaying()) {
            this.showMessage("Can't change options during a game");
        } else {
            this.optsD.show();
        }
    }

    protected void doHelp() {
        if (this.helpF != null) {
            this.helpF.setVisible(true);
            this.helpF.toFront();
            return;
        }
        try {
            Serializable serializable;
            this.helpF = new JFrame("Paper Grid Help");
            URL uRL = null;
            if (AppletWrapper.applet != null) {
                uRL = new URL(AppletWrapper.applet.getCodeBase(), "Readme.html");
            } else {
                serializable = new File("Readme.html");
                uRL = new URL("file://" + ((File)serializable).getAbsolutePath());
            }
            serializable = new JEditorPane(uRL);
            ((JTextComponent)serializable).setEditable(false);
            JScrollPane jScrollPane = new JScrollPane((Component)serializable, 22, 30);
            this.helpF.getContentPane().add("Center", jScrollPane);
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            this.helpF.setSize(dimension.width > 900 ? 800 : 600, dimension.height > 900 ? 800 : 600);
            Dimension dimension2 = this.helpF.getSize();
            this.helpF.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
            this.helpF.setVisible(true);
        }
        catch (Exception exception) {
            this.showMessage("Couldn't load Readme.html");
        }
    }

    protected void doQuit() {
        if (this.grid.isPlaying()) {
            this.doAbort();
        }
        if (this.netConnector != null) {
            this.netConnector.close();
        }
        AppletWrapper.end();
        try {
            System.exit(0);
        }
        catch (SecurityException securityException) {
            this.dispose();
        }
    }

    public void showMessage(String string) {
        JOptionPane.showMessageDialog(null, string, "Notice", -1);
    }

    public void showStatus(String string) {
        this.statL.setText(string);
    }

    public void setSidePanel(SidePanel sidePanel) {
        if (this.sidePanel != null) {
            this.contentP.remove(this.sidePanel);
        }
        if (sidePanel != null) {
            this.contentP.add("East", sidePanel);
        }
        this.sidePanel = sidePanel;
        this.pack();
    }

    public void menusPlaying() {
        this.itemsM.setEnabled(true);
        this.abortGameMI.setEnabled(true);
        this.newGameMI.setEnabled(false);
        this.netGameMI.setEnabled(false);
        this.optionsMI.setEnabled(false);
    }

    public void menusNotPlaying() {
        this.itemsM.setEnabled(false);
        this.abortGameMI.setEnabled(false);
        this.newGameMI.setEnabled(true);
        this.netGameMI.setEnabled(true);
        this.optionsMI.setEnabled(true);
        if (this.netConnector != null) {
            this.netConnector.setStatusWaiting();
        }
        if (this.sidePanel instanceof InGameChatPanel) {
            this.doNetGame();
        }
    }

    public void menusItemsForPower(int n) {
        if (this.net != null && !this.net.myTurn()) {
            n = -1;
        }
        this.itemsM.enableForPower(n);
        this.itemsTB.enableForPower(n);
    }

    public void menusForPlayer(boolean bl) {
        this.itemsTB.setPlayer(bl);
    }

    private void loadThemeImages(String string) {
        String string2 = mediaRoot + string + "/";
        GMedia.addImage((Object)(string + "Wflag"), string2 + "Wflag.jpg");
        GMedia.addImage((Object)(string + "WsingleN"), string2 + "WsingleN.jpg");
        GMedia.addImage((Object)(string + "WsingleS"), string2 + "WsingleS.jpg");
        GMedia.addImage((Object)(string + "WsingleE"), string2 + "WsingleE.jpg");
        GMedia.addImage((Object)(string + "WsingleW"), string2 + "WsingleW.jpg");
        GMedia.addImage((Object)(string + "WdoubleNS"), string2 + "WdoubleNS.jpg");
        GMedia.addImage((Object)(string + "WdoubleEW"), string2 + "WdoubleEW.jpg");
        GMedia.addImage((Object)(string + "Wquad"), string2 + "Wquad.jpg");
        GMedia.addImage((Object)(string + "Wbomb"), string2 + "Wbomb.jpg");
        GMedia.addImage((Object)(string + "Wpower"), string2 + "Wpower.jpg");
        GMedia.addImage((Object)(string + "WscramblerNS"), string2 + "WscramblerNS.jpg");
        GMedia.addImage((Object)(string + "WscramblerEW"), string2 + "WscramblerEW.jpg");
        GMedia.addImage((Object)(string + "Bflag"), string2 + "Bflag.jpg");
        GMedia.addImage((Object)(string + "BsingleN"), string2 + "BsingleN.jpg");
        GMedia.addImage((Object)(string + "BsingleS"), string2 + "BsingleS.jpg");
        GMedia.addImage((Object)(string + "BsingleE"), string2 + "BsingleE.jpg");
        GMedia.addImage((Object)(string + "BsingleW"), string2 + "BsingleW.jpg");
        GMedia.addImage((Object)(string + "BdoubleNS"), string2 + "BdoubleNS.jpg");
        GMedia.addImage((Object)(string + "BdoubleEW"), string2 + "BdoubleEW.jpg");
        GMedia.addImage((Object)(string + "Bquad"), string2 + "Bquad.jpg");
        GMedia.addImage((Object)(string + "Bbomb"), string2 + "Bbomb.jpg");
        GMedia.addImage((Object)(string + "Bpower"), string2 + "Bpower.jpg");
        GMedia.addImage((Object)(string + "BscramblerNS"), string2 + "BscramblerNS.jpg");
        GMedia.addImage((Object)(string + "BscramblerEW"), string2 + "BscramblerEW.jpg");
        GMedia.addImage((Object)(string + "empty"), string2 + "empty.jpg");
        GMedia.addImage((Object)(string + "none"), string2 + "none.jpg");
        GMedia.addImage((Object)(string + "block"), string2 + "block.jpg");
        GMedia.addImage((Object)(string + "plug"), string2 + "plug.jpg");
        GMedia.addImage((Object)(string + "cornerplug"), string2 + "cornerplug.jpg");
        GMedia.addImage((Object)(string + "rubble"), string2 + "rubble.jpg");
        GMedia.addImage((Object)(string + "fire"), string2 + "fire.jpg");
    }

    public static void setMusicEnabled(boolean bl) {
        if (!musicEnabled && bl) {
            GMedia.loopSound("music");
        } else if (musicEnabled && !bl) {
            GMedia.stopSound("music");
        }
        musicEnabled = bl;
    }

    public static void restartMusic(final long l) {
        GMedia.stopSound("music");
        if (!musicEnabled) {
            return;
        }
        new Thread(){

            public void run() {
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                GMedia.loopSound("music");
            }
        }.start();
    }

    private void loadDefaultSounds() {
        for (String string : soundFileNames) {
            String string2 = string.substring(0, string.indexOf("."));
            this.loadSoundIfExists(string2, mediaRoot + string);
        }
        GMedia.addSound((Object)"music", mediaRoot + "music.mp3");
    }

    private void loadThemeSounds(String string) {
        String string2 = mediaRoot + string + "/";
        for (String string3 : soundFileNames) {
            String string4 = string3.substring(0, string3.indexOf("."));
            this.loadSoundIfExists(string + string4, string2 + string3);
        }
    }

    private void loadSoundIfExists(String string, String string2) {
        File file = new File(string2);
        if (file.exists()) {
            GMedia.addSound((Object)string, string2);
        }
    }

    public static void playThemeSound(String string, String string2) {
        if (GMedia.hasSound(string + string2)) {
            GMedia.playSound(string + string2);
        } else {
            GMedia.playSound(string2);
        }
    }

    public static void playThemeSoundAfterPause(final String string, final String string2, final long l) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Main.playThemeSound(string, string2);
            }
        });
        thread.start();
    }
}

