/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.ChatPane;
import gui.HostPane;
import gui.JoinPane;
import gui.Main;
import gui.NonNullTextInputVerifier;
import gui.PeerList;
import gui.SidePanel;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.NetConnector;
import util.GMedia;

public class NetPanel
extends SidePanel
implements ActionListener,
FocusListener,
ChangeListener {
    private PeerList peerList = new PeerList();
    private JTextField nameF = new JTextField("Player", 10);
    private JButton closeB = new JButton(new ImageIcon(GMedia.getImage("NetClose")));
    private JTabbedPane panes = new JTabbedPane(3);
    private HostPane hostPane;
    private JoinPane joinPane;
    private ChatPane chatPane;
    private NetConnector netConnector;
    private Main reportTo;

    public NetPanel(Main main, NetConnector netConnector) {
        this.setLayout(new BoxLayout(this, 1));
        this.reportTo = main;
        this.netConnector = netConnector;
        netConnector.addObserver(this.peerList);
        this.add(this.peerList);
        this.nameF.setInputVerifier(new NonNullTextInputVerifier(29));
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(new JLabel("Name: "));
        jPanel.add(this.nameF);
        jPanel.add(this.closeB);
        this.add(jPanel);
        this.chatPane = new ChatPane(this, netConnector);
        this.panes.add("Chat", this.chatPane);
        this.hostPane = new HostPane(main, this, netConnector);
        this.panes.add("Host", this.hostPane);
        this.joinPane = new JoinPane(main, netConnector);
        this.panes.add("Join", this.joinPane);
        this.add(this.panes);
        this.nameF.addFocusListener(this);
        this.nameF.addActionListener(this);
        this.panes.addChangeListener(this);
        this.closeB.addActionListener(this);
        this.peerList.addListSelectionListener(this.joinPane);
        this.nameF.setText(netConnector.getPlayerName());
        netConnector.setStatusWaiting();
        netConnector.open();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.nameF) {
            this.nameChanged();
        } else if (object == this.closeB) {
            this.close();
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        Object object = focusEvent.getSource();
        if (object == this.nameF) {
            this.nameChanged();
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.panes.getSelectedIndex() == 0) {
            this.panes.setTitleAt(0, "Chat");
        }
    }

    public void close() {
        this.netConnector.close();
        this.reportTo.setSidePanel(null);
    }

    public void notifyHasMessage() {
        if (this.panes.getSelectedIndex() != 0) {
            this.panes.setTitleAt(0, "Chat*");
        }
    }

    private void nameChanged() {
        this.netConnector.setPlayerName(this.nameF.getText());
    }

    public void setStateHosting() {
        this.joinPane.setGUIEnabled(false);
    }

    public void setStateWaiting() {
        this.joinPane.setGUIEnabled(true);
    }
}

