/*
 * Decompiled with CFR 0.152.
 */
package gui;

import game.GameGrid;
import game.Maps;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class OptionDialog
extends JDialog {
    private JCheckBox powerCB = new JCheckBox("Power Doubling", GameGrid.POWER_DOUBLE);
    private JTextField blockF = new JTextField("" + Maps.BLOCK_RAND, 5);
    private JTextField plugF = new JTextField("" + Maps.PLUG_RAND, 5);

    public OptionDialog(Frame frame) {
        super(frame, "Paper Grid Options", true);
        Container container = this.getContentPane();
        container.setLayout(new BoxLayout(container, 1));
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(this.powerCB);
        container.add(jPanel);
        JLabel jLabel = new JLabel("<html>Power doubles from clumps of plants for each plant vs. constant 4 power per plant.</html>");
        jLabel.setHorizontalAlignment(4);
        jLabel.setFont(new Font("Dialog", 12, 0));
        container.add(jLabel);
        JPanel jPanel2 = new JPanel(new GridLayout(2, 2));
        jPanel2.setBorder(new TitledBorder("Generated Map Settings"));
        jPanel2.add(new JLabel("Block frequency: "));
        jPanel2.add(this.blockF);
        jPanel2.add(new JLabel("Plug frequency: "));
        jPanel2.add(this.plugF);
        container.add(jPanel2);
        JPanel jPanel3 = new JPanel(new FlowLayout(2));
        JButton jButton = new JButton("Cancel");
        jPanel3.add(jButton);
        JButton jButton2 = new JButton("OK");
        jPanel3.add(jButton2);
        container.add(jPanel3);
        this.setSize(350, 200);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        this.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionDialog.this.setVisible(false);
            }
        });
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                double d;
                GameGrid.POWER_DOUBLE = OptionDialog.this.powerCB.isSelected();
                try {
                    d = Double.parseDouble(OptionDialog.this.blockF.getText());
                    if (d > 0.5 || d < 0.0) {
                        throw new NumberFormatException("Out of bounds");
                    }
                    Maps.BLOCK_RAND = d;
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    OptionDialog.this.blockF.requestFocus();
                    OptionDialog.this.blockF.selectAll();
                    return;
                }
                try {
                    d = Double.parseDouble(OptionDialog.this.plugF.getText());
                    if (d > 0.5 || d < 0.0) {
                        throw new NumberFormatException("Out of bounds");
                    }
                    Maps.PLUG_RAND = d;
                }
                catch (NumberFormatException numberFormatException) {
                    Toolkit.getDefaultToolkit().beep();
                    OptionDialog.this.plugF.requestFocus();
                    OptionDialog.this.plugF.selectAll();
                    return;
                }
                OptionDialog.this.setVisible(false);
            }
        });
    }

    public void show() {
        this.powerCB.setSelected(GameGrid.POWER_DOUBLE);
        this.blockF.setText("" + Maps.BLOCK_RAND);
        this.plugF.setText("" + Maps.PLUG_RAND);
        super.show();
    }
}

