/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.BorderLayout;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.NetConnector;
import net.PeerInfo;

public class PeerList
extends JPanel
implements Observer,
ListSelectionListener {
    private DefaultListModel listData = new DefaultListModel();
    private JList list = new JList(this.listData);
    private JLabel peerIpLabel = new JLabel(" IP: ");

    public PeerList() {
        super(new BorderLayout());
        this.list.setVisibleRowCount(7);
        this.add("Center", this.list);
        this.add("South", this.peerIpLabel);
        this.list.addListSelectionListener(this);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        PeerInfo peerInfo = (PeerInfo)this.list.getSelectedValue();
        if (peerInfo == null) {
            this.peerIpLabel.setText(" IP:");
        } else {
            this.peerIpLabel.setText(" IP: " + peerInfo.addr.getHostName() + " (" + peerInfo.addr.getPort() + ")");
        }
    }

    public void addListSelectionListener(ListSelectionListener listSelectionListener) {
        this.list.addListSelectionListener(listSelectionListener);
    }

    public PeerInfo getSelectedValue() {
        return (PeerInfo)this.list.getSelectedValue();
    }

    public void update(Observable observable, Object object) {
        if (observable instanceof NetConnector) {
            if (object instanceof PeerInfo) {
                if (this.list.getSelectedValue() == object) {
                    PeerInfo peerInfo = (PeerInfo)object;
                    this.peerIpLabel.setText("IP: " + peerInfo.addr.getHostName() + " (" + peerInfo.addr.getPort() + ")");
                }
            } else {
                this.listData.clear();
                for (PeerInfo peerInfo : ((NetConnector)observable).getPeers()) {
                    this.listData.addElement(peerInfo);
                }
            }
        }
    }
}

