/*
 * Decompiled with CFR 0.152.
 */
package net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observable;
import javax.swing.JOptionPane;
import net.ChatListener;
import net.PeerInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetConnector
extends Observable
implements Runnable {
    private static final int[] LISTENING_PORTS = new int[]{2999, 7146};
    private int listeningPort = -1;
    private DatagramSocket sock;
    private Thread runner = null;
    private InetAddress localHost = null;
    private ArrayList<PeerInfo> peers = new ArrayList();
    private HashMap<PeerInfo, String> messages = new HashMap();
    private String playerName = "Player1";
    private GameStatus gameStatus = new GameStatus();
    private ArrayList<ChatListener> chatListeners = new ArrayList();

    public NetConnector() {
        try {
            this.localHost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("Problems identifying local host: " + unknownHostException);
        }
    }

    public boolean isOpen() {
        return this.sock != null;
    }

    public void open() {
        if (this.sock == null) {
            if (this.connect()) {
                this.runner = new Thread(this);
                this.runner.start();
            } else {
                return;
            }
        }
        this.sendAnnounce(null);
        this.sendSeek();
    }

    public void close() {
        if (this.sock != null) {
            this.sendDisconnect();
            this.sock.close();
            this.sock = null;
            this.listeningPort = -1;
            this.runner = null;
            this.peers.clear();
            this.messages.clear();
        }
    }

    @Override
    public void run() {
        DatagramPacket datagramPacket = new DatagramPacket(new byte[32], 32);
        while (this.sock != null) {
            try {
                this.sock.receive(datagramPacket);
                if (datagramPacket.getAddress().equals(this.localHost) && datagramPacket.getPort() == this.listeningPort) continue;
                this.processIncoming(datagramPacket);
            }
            catch (IOException iOException) {}
        }
    }

    private boolean connect() {
        for (int i = 0; i < LISTENING_PORTS.length; ++i) {
            try {
                this.listeningPort = LISTENING_PORTS[i];
                this.sock = new DatagramSocket(this.listeningPort);
                break;
            }
            catch (SocketException socketException) {
                this.listeningPort = -1;
                this.sock = null;
                continue;
            }
        }
        if (this.sock == null) {
            JOptionPane.showMessageDialog(null, "Could not bind to a listening port", "Socket Failure", 0);
            return false;
        }
        return true;
    }

    private void processIncoming(DatagramPacket datagramPacket) {
        byte[] byArray = datagramPacket.getData();
        byte by = byArray[0];
        InetSocketAddress inetSocketAddress = (InetSocketAddress)datagramPacket.getSocketAddress();
        PeerInfo peerInfo = null;
        switch (by) {
            case 0: {
                peerInfo = this.getPeerFromAddress(inetSocketAddress);
                if (peerInfo == null) {
                    peerInfo = new PeerInfo(inetSocketAddress, this.readString(byArray, 2));
                    this.peers.add(peerInfo);
                } else {
                    peerInfo.name = this.readString(byArray, 2);
                }
                if (byArray[1] == 0) {
                    peerInfo.game.state = GameState.WAITING;
                } else if (byArray[1] == 1) {
                    peerInfo.game.state = GameState.HOSTING;
                } else if (byArray[1] == 2) {
                    peerInfo.game.state = GameState.PLAYING;
                }
                this.setChanged();
                this.notifyObservers();
                break;
            }
            case 1: {
                this.sendAnnounce(inetSocketAddress);
                break;
            }
            case 2: {
                peerInfo = this.getPeerFromAddress(inetSocketAddress);
                if (peerInfo == null) break;
                if (byArray[1] == 0) {
                    peerInfo.game.state = GameState.WAITING;
                } else if (byArray[1] == 1) {
                    peerInfo.game.state = GameState.HOSTING;
                } else if (byArray[1] == 2) {
                    peerInfo.game.state = GameState.PLAYING;
                }
                this.setChanged();
                this.notifyObservers(peerInfo);
                break;
            }
            case 3: {
                this.sendInfo(inetSocketAddress);
                break;
            }
            case 4: {
                peerInfo = this.getPeerFromAddress(inetSocketAddress);
                if (peerInfo == null) {
                    peerInfo = new PeerInfo(inetSocketAddress, "unknown");
                    this.peers.add(peerInfo);
                    this.sendGetInfo(peerInfo);
                }
                peerInfo.game.gamePort = (byArray[1] << 8) + (byArray[2] & 0xFF);
                peerInfo.game.hostFirst = byArray[3] == 1;
                peerInfo.game.mapName = this.readString(byArray, 4);
                this.setChanged();
                this.notifyObservers(peerInfo);
                break;
            }
            case 5: {
                peerInfo = this.getPeerFromAddress(inetSocketAddress);
                if (peerInfo == null) {
                    peerInfo = new PeerInfo(inetSocketAddress, "unknown");
                    this.peers.add(peerInfo);
                    this.sendGetInfo(peerInfo);
                }
                String string = this.readString(byArray, 1);
                String string2 = this.messages.get(peerInfo);
                string2 = string2 == null ? string : string2 + string;
                if (string2.charAt(string2.length() - 1) == '\n') {
                    this.messages.remove(peerInfo);
                    this.deliverMessage(peerInfo, string2);
                    break;
                }
                this.messages.put(peerInfo, string2);
                break;
            }
            case 6: {
                peerInfo = this.getPeerFromAddress(inetSocketAddress);
                if (peerInfo == null) break;
                this.peers.remove(peerInfo);
                this.setChanged();
                this.notifyObservers();
                break;
            }
            default: {
                System.out.println("Got unknown message: " + by);
            }
        }
    }

    private void deliverMessage(PeerInfo peerInfo, String string) {
        for (ChatListener chatListener : this.chatListeners) {
            chatListener.messageReceived(peerInfo, string);
        }
    }

    public void addChatListener(ChatListener chatListener) {
        this.chatListeners.add(chatListener);
    }

    public void removeChatListener(ChatListener chatListener) {
        this.chatListeners.remove(chatListener);
    }

    public void setPlayerName(String string) {
        this.playerName = string;
        this.sendAnnounce(null);
    }

    public void setGamePort(int n) {
        this.gameStatus.gamePort = n;
        this.sendInfo(null);
    }

    public void setMapName(String string) {
        this.gameStatus.mapName = string;
        this.sendInfo(null);
    }

    public void setHostGoesFirst(boolean bl) {
        this.gameStatus.hostFirst = bl;
        this.sendInfo(null);
    }

    public void setStatusPlaying() {
        this.gameStatus.state = GameState.PLAYING;
        this.sendStatus();
    }

    public void setStatusHosting() {
        this.gameStatus.state = GameState.HOSTING;
        this.sendStatus();
    }

    public void setStatusWaiting() {
        this.gameStatus.state = GameState.WAITING;
        this.sendStatus();
    }

    public String getPlayerName() {
        return this.playerName;
    }

    public String getMapName() {
        return this.gameStatus.mapName;
    }

    public boolean getHostGoesFirst() {
        return this.gameStatus.hostFirst;
    }

    public int getGamePort() {
        return this.gameStatus.gamePort;
    }

    public ArrayList<PeerInfo> getPeers() {
        return this.peers;
    }

    private PeerInfo getPeerFromAddress(InetSocketAddress inetSocketAddress) {
        for (PeerInfo peerInfo : this.peers) {
            if (!peerInfo.addr.equals(inetSocketAddress)) continue;
            return peerInfo;
        }
        return null;
    }

    public void sendAnnounce(InetSocketAddress inetSocketAddress) {
        byte[] byArray = new byte[32];
        byArray[0] = (byte)MessageCode.ANNOUNCE.ordinal();
        byArray[1] = (byte)this.gameStatus.state.ordinal();
        int n = this.buildString(this.playerName, byArray, 2);
        if (inetSocketAddress != null) {
            this.sendTo(inetSocketAddress, byArray, n + 2);
        } else {
            this.broadcast(byArray, n + 2);
        }
    }

    public void sendSeek() {
        byte[] byArray = new byte[]{(byte)MessageCode.SEEK.ordinal()};
        this.broadcast(byArray, 1);
    }

    public void sendStatus() {
        byte[] byArray = new byte[]{(byte)MessageCode.STATUS.ordinal(), (byte)this.gameStatus.state.ordinal()};
        this.broadcast(byArray, 2);
    }

    public void sendGetInfo(PeerInfo peerInfo) {
        byte[] byArray = new byte[]{(byte)MessageCode.GETINFO.ordinal()};
        this.sendTo(peerInfo.addr, byArray, 1);
    }

    public void sendInfo(InetSocketAddress inetSocketAddress) {
        byte[] byArray = new byte[32];
        byArray[0] = (byte)MessageCode.INFO.ordinal();
        byArray[1] = (byte)(this.gameStatus.gamePort >> 8);
        byArray[2] = (byte)(this.gameStatus.gamePort & 0xFF);
        byArray[3] = (byte)(this.gameStatus.hostFirst ? 1 : 0);
        int n = this.buildString(this.gameStatus.mapName, byArray, 4);
        if (inetSocketAddress != null) {
            this.sendTo(inetSocketAddress, byArray, n + 4);
        } else {
            this.broadcast(byArray, n + 4);
        }
    }

    public void sendDisconnect() {
        byte[] byArray = new byte[]{(byte)MessageCode.DISCONNECT.ordinal()};
        this.broadcast(byArray, 1);
    }

    public void sendMessage(String string) {
        byte[] byArray = new byte[32];
        if (string.charAt(string.length() - 1) != '\n') {
            string = string + "\n";
        }
        byArray[0] = (byte)MessageCode.CHAT.ordinal();
        while (string.length() > 0) {
            int n = this.buildString(string, byArray, 1) - 1;
            string = string.substring(n);
            this.broadcast(byArray, n + 2);
        }
    }

    private void sendTo(InetSocketAddress inetSocketAddress, byte[] byArray, int n) {
        if (this.sock == null) {
            return;
        }
        try {
            DatagramPacket datagramPacket = new DatagramPacket(byArray, n, inetSocketAddress);
            this.sock.send(datagramPacket);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void broadcast(byte[] byArray, int n) {
        if (this.sock == null) {
            return;
        }
        try {
            InetAddress inetAddress = InetAddress.getByName("255.255.255.255");
            DatagramPacket datagramPacket = new DatagramPacket(byArray, n, inetAddress, LISTENING_PORTS[0]);
            for (int i = 0; i < LISTENING_PORTS.length; ++i) {
                datagramPacket.setPort(LISTENING_PORTS[i]);
                try {
                    this.sock.send(datagramPacket);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            System.out.println("Couldn't multicast: " + unknownHostException);
        }
    }

    private String readString(byte[] byArray, int n) {
        int n2 = byArray[n];
        if (n2 + n + 1 > byArray.length) {
            System.out.println("Got string length too large: " + n2);
            n2 = (byte)(byArray.length - n - 1);
            System.out.println("\treduced to " + n2);
        }
        String string = "";
        for (int i = 0; i < n2; ++i) {
            string = string + (char)byArray[i + n + 1];
        }
        return string;
    }

    private int buildString(String string, byte[] byArray, int n) {
        int n2 = string.length();
        if (n2 > byArray.length - n - 1) {
            n2 = byArray.length - n - 1;
        }
        byArray[n] = (byte)n2;
        for (int i = 0; i < n2; ++i) {
            byArray[i + n + 1] = (byte)string.charAt(i);
        }
        return n2 + 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum MessageCode {
        ANNOUNCE,
        SEEK,
        STATUS,
        GETINFO,
        INFO,
        CHAT,
        DISCONNECT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GameState {
        WAITING,
        HOSTING,
        PLAYING;

    }

    public static class GameStatus {
        public String mapName = "Random";
        public GameState state = GameState.WAITING;
        public boolean hostFirst = true;
        public int gamePort = 2237;
    }
}

