/*
 * Decompiled with CFR 0.152.
 */
package net;

import game.GameGrid;
import game.Maps;
import gui.GridPanel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import net.ChatListener;
import net.PeerInfo;

public class NetGame
implements Runnable {
    private GameGrid grid;
    private GridPanel gridp;
    private Socket sock = null;
    private InputStream in = null;
    private OutputStream out = null;
    private ArrayList<ChatListener> chatListeners = new ArrayList();
    private Thread listener = null;
    private boolean listening = false;
    private boolean meFirst = true;
    private boolean cancelled = false;
    private String password = null;
    private static final int PLACE_ITEM = 33;
    private static final int CHAT_MESSAGE = 34;

    public NetGame(GameGrid gameGrid, GridPanel gridPanel) {
        this.grid = gameGrid;
        this.gridp = gridPanel;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void cancelConnection() {
        this.cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean openHostGame(String string, int n, boolean bl) {
        this.cancelled = false;
        ServerSocket serverSocket = null;
        try {
            boolean bl2;
            Object object;
            serverSocket = new ServerSocket(n);
            serverSocket.setSoTimeout(2000);
            do {
                block33: {
                    try {
                        this.sock = serverSocket.accept();
                        if (this.cancelled) {
                            this.closeGame();
                            boolean bl3 = false;
                            return bl3;
                        }
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        // empty catch block
                        break block33;
                    }
                    {
                        this.in = this.sock.getInputStream();
                        this.out = this.sock.getOutputStream();
                        if (this.in.read() == 23) {
                            if (this.password != null) {
                                this.out.write(96);
                                this.out.flush();
                                object = this.readString(this.in);
                                if (!((String)object).equals(this.password)) {
                                    this.out.write(0);
                                    this.out.flush();
                                    this.closeGame();
                                    break block33;
                                } else {
                                    this.out.write(1);
                                }
                                break block33;
                            }
                            this.out.write(95);
                            break block33;
                        }
                        this.closeGame();
                    }
                }
                if (!this.cancelled) continue;
                this.closeGame();
                boolean bl4 = false;
                return bl4;
            } while (this.sock == null);
            this.out.write(bl ? 0 : 1);
            this.out.write(GameGrid.POWER_DOUBLE ? 1 : 0);
            this.out.flush();
            if (this.cancelled) {
                this.closeGame();
                boolean bl5 = false;
                return bl5;
            }
            object = Maps.getMap(string);
            this.grid.useMap((int[][])object);
            this.out.write((byte)((int[][])object).length);
            this.out.write((byte)((Object)object[0]).length);
            for (bl2 = false; bl2 < ((Object)object).length; bl2 += 1) {
                for (int i = 0; i < ((Object)object[0]).length; ++i) {
                    this.out.write((byte)object[bl2][i]);
                }
            }
            this.out.flush();
            this.meFirst = bl;
            this.listener = new Thread(this);
            this.listening = true;
            this.listener.start();
            bl2 = true;
            return bl2;
        }
        catch (Exception exception) {
            if (this.cancelled) return false;
            JOptionPane.showMessageDialog(null, "Could not connect.", "Error", 0);
            return false;
        }
        finally {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean openJoinGame(String string, int n) {
        Socket socket = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        int n2 = 0;
        do {
            try {
                block16: {
                    block15: {
                        int n3;
                        block14: {
                            socket = new Socket(string, n);
                            inputStream = socket.getInputStream();
                            outputStream = socket.getOutputStream();
                            outputStream.write(23);
                            outputStream.flush();
                            n3 = inputStream.read();
                            if (n3 != 96) break block14;
                            if (this.password == null) {
                                socket.close();
                                JOptionPane.showMessageDialog(null, "This game requires a password.", "Password", 0);
                                return false;
                            }
                            this.writeString(this.password, outputStream);
                            if (inputStream.read() != 1) {
                                socket.close();
                                JOptionPane.showMessageDialog(null, "Incorrect password.", "Password", 0);
                                return false;
                            }
                            System.out.println("Password accepted");
                            break block15;
                        }
                        if (n3 != 95) break block16;
                    }
                    this.meFirst = inputStream.read() == 1;
                    GameGrid.POWER_DOUBLE = inputStream.read() == 1;
                    int n4 = inputStream.read();
                    int n5 = inputStream.read();
                    int[][] nArray = new int[n4][n5];
                    for (n4 = 0; n4 < nArray.length; ++n4) {
                        for (n5 = 0; n5 < nArray[0].length; ++n5) {
                            nArray[n4][n5] = inputStream.read();
                        }
                    }
                    this.grid.useMap(nArray);
                    this.sock = socket;
                    this.in = inputStream;
                    this.out = outputStream;
                    this.listener = new Thread(this);
                    this.listening = true;
                    this.listener.start();
                    return true;
                }
                socket.close();
                socket = null;
                inputStream = null;
                outputStream = null;
            }
            catch (Exception exception) {
                ++n2;
                try {
                    socket.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception3) {
                    // empty catch block
                }
            }
        } while (n2 < 3);
        JOptionPane.showMessageDialog(null, "Could not connect after 3 tries.", "Error", 0);
        return false;
    }

    public void closeGame() {
        this.listening = false;
        this.listener = null;
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.sock = null;
        this.in = null;
        this.out = null;
    }

    public boolean myTurn() {
        return this.meFirst && this.grid.isWhiteTurn() || !this.meFirst && !this.grid.isWhiteTurn();
    }

    public synchronized void sendPlaceItem(int n, int n2, int n3) {
        try {
            this.out.write(33);
            this.out.write(n2);
            this.out.write(n3);
            this.out.write(n);
            this.out.flush();
            this.grid.setMouseLocation(-1, -1);
            this.grid.notifyNotMyTurn();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Lost connection or game aborted.", "Abort Game", 0);
            this.grid.abortGame();
            this.closeGame();
        }
    }

    public void run() {
        try {
            while (this.listening) {
                int n = this.in.read();
                if (n == -1) {
                    throw new IOException("EOF");
                }
                if (n == 33) {
                    int n2;
                    if (this.myTurn()) {
                        while (this.myTurn()) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                    }
                    if ((n2 = this.in.read()) == -1) {
                        throw new IOException("EOF");
                    }
                    int n3 = this.in.read();
                    if (n3 == -1) {
                        throw new IOException("EOF");
                    }
                    int n4 = this.in.read();
                    if (n4 == -1) {
                        throw new IOException("EOF");
                    }
                    this.grid.placeItem(n2, n3, n4);
                    this.gridp.repaint();
                    this.grid.notifyMyTurn();
                    continue;
                }
                if (n == 34) {
                    this.deliverMessage(null, this.readString(this.in));
                    continue;
                }
                System.out.println("Unknown message type: " + n);
            }
        }
        catch (IOException iOException) {
            if (this.grid.isPlaying()) {
                JOptionPane.showMessageDialog(null, "Lost connection or game aborted.", "Abort Game", 0);
                this.grid.abortGame();
            }
            this.closeGame();
        }
    }

    private void deliverMessage(PeerInfo peerInfo, String string) {
        for (ChatListener chatListener : this.chatListeners) {
            chatListener.messageReceived(peerInfo, string);
        }
    }

    public void addChatListener(ChatListener chatListener) {
        this.chatListeners.add(chatListener);
    }

    public void removeChatListener(ChatListener chatListener) {
        this.chatListeners.remove(chatListener);
    }

    public synchronized void sendMessage(String string) {
        try {
            this.out.write(34);
            this.writeString(string, this.out);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "Lost connection or game aborted.", "Abort Game", 0);
            this.grid.abortGame();
            this.closeGame();
        }
    }

    private String readString(InputStream inputStream) throws IOException {
        int n = (inputStream.read() << 8) + (inputStream.read() & 0xFF);
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + (char)inputStream.read();
        }
        return string;
    }

    private void writeString(String string, OutputStream outputStream) throws IOException {
        char[] cArray = string.toCharArray();
        outputStream.write(cArray.length >> 8);
        outputStream.write(cArray.length & 0xFF);
        for (char c : cArray) {
            outputStream.write((byte)c);
        }
        outputStream.flush();
    }
}

