/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Image;
import java.awt.Rectangle;

public class Asteroid
extends Sprite {
    double lx;
    double ly;
    double velx;
    double vely;
    int wraps = 10;
    double mass = 1.0;
    boolean moved = false;

    public Asteroid(Image image, Rectangle rectangle, double d, double d2) {
        super(image, rectangle);
        this.setActive(true);
        this.setTangible(true);
        this.velx = d;
        this.vely = d2;
        this.lx = this.bounds.x;
        this.ly = this.bounds.y;
    }

    public Asteroid(Image image, Rectangle rectangle, double d, double d2, double d3) {
        super(image, rectangle);
        this.setActive(true);
        this.setTangible(true);
        this.velx = d;
        this.vely = d2;
        this.lx = this.bounds.x;
        this.ly = this.bounds.y;
        this.mass = d3;
        if (d3 < 1.0) {
            this.wraps = 2;
        }
    }

    public void update() {
        if (this.wraps < 0) {
            Global.gen.removeSprite(this);
        }
        this.lx += this.velx;
        this.ly -= this.vely;
        if (this.lx < -10.0) {
            this.lx = 490.0;
            --this.wraps;
        } else if (this.lx > 490.0) {
            this.lx = -10.0;
            --this.wraps;
        }
        if (this.ly < -10.0) {
            this.ly = 490.0;
            --this.wraps;
        } else if (this.ly > 490.0) {
            this.ly = -10.0;
            --this.wraps;
        }
        this.bounds.x = (int)this.lx;
        this.bounds.y = (int)this.ly;
    }

    public void collide(GTangible gTangible) {
        double d = this.velx;
        double d2 = this.vely;
        double d3 = 0.0;
        if (gTangible instanceof Player) {
            Player player = (Player)gTangible;
            this.velx = player.velX / this.mass;
            this.vely = player.velY / this.mass;
            player.velX = d * this.mass;
            player.velY = d2 * this.mass;
            player.calcAng();
        } else if (gTangible instanceof Gunner) {
            Gunner gunner = (Gunner)gTangible;
            this.velx = gunner.velx / this.mass;
            this.vely = gunner.velx / this.mass;
            gunner.velx = d * this.mass;
            gunner.velx = d2 * this.mass;
        } else if (gTangible instanceof Bomb) {
            Bomb bomb = (Bomb)gTangible;
            this.velx = bomb.velx / this.mass;
            this.vely = bomb.velx / this.mass;
            bomb.velx = d * this.mass;
            bomb.velx = d2 * this.mass;
        } else if (gTangible instanceof Asteroid) {
            Asteroid asteroid = (Asteroid)gTangible;
            if (!asteroid.moved) {
                this.velx = asteroid.velx * asteroid.mass / this.mass;
                this.vely = asteroid.vely * asteroid.mass / this.mass;
                asteroid.velx = d * this.mass / asteroid.mass;
                asteroid.vely = d2 * this.mass / asteroid.mass;
                this.moved = true;
            } else {
                asteroid.moved = false;
            }
        }
    }
}

