/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public class Main
extends JFrame
implements KeyListener {
    private GenPanel gp;
    private JPanel gameP;
    private StartPanel startP;
    private JPanel helpP = null;
    private JPanel scoreP = null;
    private CardLayout card;
    private boolean scoresNext = false;
    HSDialog hsD = new HSDialog(this);
    boolean rr = false;
    int cheat = 0;

    public static void main(String[] stringArray) {
        new Main();
    }

    public Main() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        Container container = this.getContentPane();
        this.card = new CardLayout();
        container.setLayout(this.card);
        Global.main = this;
        Global.observer = this;
        Global.gen = new GEngine(500, 500);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (Global.gen != null) {
                    Global.gen.stop();
                }
                Main.this.dispose();
                AppletWrapper.exit(0);
            }
        });
        GMedia.beginLoadImages(this);
        GMedia.addImage((Object)"player1", "images/player1.gif");
        GMedia.addImage((Object)"player1_thrust", "images/player1_thrust.gif");
        GMedia.addImage((Object)"player2", "images/player2.gif");
        GMedia.addImage((Object)"player2_thrust", "images/player2_thrust.gif");
        GMedia.addImage((Object)"player3", "images/player3.gif");
        GMedia.addImage((Object)"player3_thrust", "images/player3_thrust.gif");
        GMedia.addImage((Object)"player4", "images/player4.gif");
        GMedia.addImage((Object)"player4_thrust", "images/player4_thrust.gif");
        GMedia.addImage((Object)"powerup", "images/PowerUp.gif");
        GMedia.addImage((Object)"asteroid", "images/asteroid.gif");
        GMedia.addImage((Object)"explode", "images/explode.gif");
        GMedia.addImage((Object)"splash", "images/splash.gif");
        GMedia.addImage((Object)"gunner", "images/gunner.gif");
        GMedia.addImage((Object)"bomb", "images/bomb.gif");
        GMedia.addImage((Object)"target", "images/target.gif");
        GMedia.addImage((Object)"side1", "images/statbar1.gif");
        GMedia.addImage((Object)"side2", "images/statbar2.gif");
        GMedia.finishLoadImages();
        GMedia.addSound((Object)"die", "sounds/die.au");
        GMedia.addSound((Object)"resurect", "sounds/resurect.au");
        GMedia.addSound((Object)"fire", "sounds/fire.au");
        GMedia.addSound((Object)"fire_ast", "sounds/fire_ast.au");
        GMedia.addSound((Object)"fire_gun", "sounds/fire_gun.au");
        GMedia.addSound((Object)"thrust", "sounds/thrust.au");
        GMedia.addSound((Object)"mine", "sounds/mine.au");
        JPanel jPanel = new JPanel(new BorderLayout());
        this.gp = new GenPanel();
        this.gp.setPreferredSize(500, 500);
        Global.display = this.gp;
        jPanel.add("Center", this.gp);
        Global.stat1 = new StatPanel(GMedia.getImage("side1"));
        Global.stat2 = new StatPanel(GMedia.getImage("side2"));
        jPanel.add("West", Global.stat1);
        jPanel.add("East", Global.stat2);
        this.gameP = new JPanel(new FlowLayout(1));
        this.gameP.add(jPanel);
        this.gameP.setBackground(new Color(10, 10, 10));
        this.startP = new StartPanel();
        container.add("start", this.startP);
        container.add("game", this.gameP);
        this.addKeyListener(this);
        this.gp.addKeyListener(this);
        this.gameP.addKeyListener(this);
        this.startP.addKeyListener(this);
        this.loadHS();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(0, 0, dimension.width, dimension.height - 50);
        this.setVisible(true);
        this.showStart();
    }

    public void showStart() {
        if (!Global.gen.running) {
            this.startP.prep();
            this.card.show(this.getContentPane(), "start");
        }
    }

    public void showGame() {
        this.card.show(this.getContentPane(), "game");
    }

    public void showHelp() {
        if (!Global.gen.running) {
            if (this.helpP == null) {
                JComponent jComponent;
                Serializable serializable;
                this.helpP = new JPanel(new BorderLayout());
                try {
                    serializable = new File("Readme.html");
                    jComponent = new JEditorPane("file://" + ((File)serializable).getAbsolutePath());
                    ((JTextComponent)jComponent).setEditable(false);
                    JScrollPane jScrollPane = new JScrollPane(jComponent, 22, 30);
                    this.helpP.add("Center", jScrollPane);
                }
                catch (Exception exception) {
                    this.helpP.add("Center", new Label("Couldn't load \"Readme.html\""));
                }
                serializable = new JPanel(new FlowLayout(1));
                jComponent = new JButton("OK");
                ((AbstractButton)jComponent).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Global.main.showStart();
                    }
                });
                ((JComponent)serializable).setBackground(Color.black);
                jComponent.setOpaque(false);
                ((Container)serializable).add(jComponent);
                this.helpP.add("South", (Component)serializable);
                this.helpP.addKeyListener(this);
                this.getContentPane().add("help", this.helpP);
            }
            this.card.show(this.getContentPane(), "help");
        }
    }

    public void showScores() {
        if (!Global.gen.running) {
            if (this.scoreP == null) {
                this.scoreP = new JPanel(new BorderLayout());
                this.scoreP.add("Center", new ScorePanel());
                JPanel jPanel = new JPanel(new FlowLayout(1));
                JButton jButton = new JButton("OK");
                jButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Global.main.showStart();
                    }
                });
                jPanel.setBackground(Color.black);
                jButton.setOpaque(false);
                jPanel.add(jButton);
                this.scoreP.add("South", jPanel);
                this.scoreP.addKeyListener(this);
                this.getContentPane().add("scores", this.scoreP);
            }
            this.card.show(this.getContentPane(), "scores");
        }
    }

    protected void saveHS() {
        if (Global.hlist == null) {
            return;
        }
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream("SBscores.dat"));
            objectOutputStream.writeObject(Global.hlist);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Error when saving high scores.");
        }
    }

    private void loadHS() {
        try {
            FileInputStream fileInputStream = new FileInputStream("SBscores.dat");
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            HighScoreList highScoreList = (HighScoreList)objectInputStream.readObject();
            if (highScoreList != null) {
                Global.hlist = highScoreList;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (Global.hlist == null) {
            Global.hlist = new HighScoreList(10);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        boolean bl = false;
        if (Global.player1 >= 0) {
            if (n == 73 && !Global.players[Global.player1].up) {
                Global.reporter.report(Global.player1, 2);
            } else if (n == 75 && !Global.players[Global.player1].down) {
                Global.reporter.report(Global.player1, 3);
            } else if (n == 74 && !Global.players[Global.player1].left) {
                Global.reporter.report(Global.player1, 5);
            } else if (n == 76 && !Global.players[Global.player1].right) {
                Global.reporter.report(Global.player1, 4);
            } else if (n == 32 && !Global.players[Global.player1].fire) {
                Global.reporter.report(Global.player1, 10);
            } else if (n == 85) {
                Global.reporter.report(Global.player1, 14);
            } else if (n == 78 && !Global.players[Global.player1].fire2) {
                Global.reporter.report(Global.player1, 16);
            } else if (n == 79) {
                Global.reporter.report(Global.player1, 15);
            } else if (n == 44) {
                Global.reporter.report(Global.player1, 18);
            } else if (n == 77) {
                Global.reporter.report(Global.player1, 19);
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (Global.player2 >= 0 && bl) {
            if (n == 104 && !Global.players[Global.player2].up) {
                Global.reporter.report(Global.player2, 2);
            } else if (n == 101 && !Global.players[Global.player2].down) {
                Global.reporter.report(Global.player2, 3);
            } else if (n == 100 && !Global.players[Global.player2].left) {
                Global.reporter.report(Global.player2, 5);
            } else if (n == 102 && !Global.players[Global.player2].right) {
                Global.reporter.report(Global.player2, 4);
            } else if (n == 96 && !Global.players[Global.player2].fire) {
                Global.reporter.report(Global.player2, 10);
            } else if (n == 103) {
                Global.reporter.report(Global.player2, 14);
            } else if (n == 97 && !Global.players[Global.player2].fire2) {
                Global.reporter.report(Global.player2, 16);
            } else if (n == 105) {
                Global.reporter.report(Global.player2, 15);
            } else if (n == 99) {
                Global.reporter.report(Global.player2, 18);
            } else if (n == 98) {
                Global.reporter.report(Global.player2, 19);
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        boolean bl = false;
        if (Global.player1 >= 0) {
            if (n == 73) {
                Global.reporter.report(Global.player1, 6);
            } else if (n == 75) {
                Global.reporter.report(Global.player1, 7);
            } else if (n == 74) {
                Global.reporter.report(Global.player1, 9);
            } else if (n == 76) {
                Global.reporter.report(Global.player1, 8);
            } else if (n == 32 && !keyEvent.isShiftDown()) {
                Global.reporter.report(Global.player1, 11);
            } else if (n == 78 && !keyEvent.isShiftDown()) {
                Global.reporter.report(Global.player1, 17);
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (Global.player2 >= 0 && bl) {
            if (n == 104) {
                Global.reporter.report(Global.player2, 6);
            } else if (n == 101) {
                Global.reporter.report(Global.player2, 7);
            } else if (n == 100) {
                Global.reporter.report(Global.player2, 9);
            } else if (n == 102) {
                Global.reporter.report(Global.player2, 8);
            } else if (n == 96 && !keyEvent.isShiftDown()) {
                Global.reporter.report(Global.player2, 11);
            } else if (n == 97 && !keyEvent.isShiftDown()) {
                Global.reporter.report(Global.player2, 17);
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == 'S') {
            GMedia.soundsEnabled = !GMedia.soundsEnabled;
            GMedia.playSound("fire");
        }
        if (c == 'D') {
            Global.Debug = !Global.Debug;
            GMedia.playSound("fire_ast");
        } else if (c == 'Q') {
            if (Global.gen != null) {
                Global.gen.stop();
            }
            this.dispose();
            AppletWrapper.exit(0);
        } else if (c == 'R') {
            boolean bl = this.rr = !this.rr;
            if (this.rr) {
                GMedia.playSound("resurect");
            }
        } else if (Global.gen.running) {
            if (c == 'h') {
                if (Global.player1 >= 0 && Global.players[Global.player1] != null && (!Global.players[Global.player1].isVisible() || this.rr) && Global.players[Global.player1].lives > 0) {
                    Global.reporter.report(Global.player1, 13);
                    this.addPowerUp();
                }
            } else if (c == '*') {
                if (Global.player2 >= 0 && Global.players[Global.player2] != null && (!Global.players[Global.player2].isVisible() || this.rr) && Global.players[Global.player2].lives > 0) {
                    Global.reporter.report(Global.player2, 13);
                    this.addPowerUp();
                }
            } else if (c == '=') {
                if (Global.gameType != 4) {
                    int n = 0;
                    while (n < 4) {
                        if (Global.players[n] != null && (!Global.players[n].isVisible() || this.rr) && Global.players[n].lives > 0) {
                            Global.reporter.report(n, 13);
                            this.addPowerUp();
                        }
                        ++n;
                    }
                }
            } else if (c == 'P') {
                Global.gen.pause();
                this.gp.msg = "Paused";
                this.gp.mcolor = Color.yellow;
                this.gp.repaint();
            } else if (c == 'A') {
                this.endGame(0);
            } else if (this.cheat == 0 && c == 'a') {
                this.cheat = 1;
            } else if (this.cheat == 1 && c == 'l') {
                this.cheat = 2;
            } else if (this.cheat == 2 && c == 'L') {
                this.cheat = 3;
            } else if (this.cheat == 3 && (c == '0' || c == '1' || c == '2' || c == '3')) {
                this.cheat = 0;
                Player player = Global.players[c - 48];
                player.addDevice(new AfterBurner());
                player.addDevice(new Armor());
                player.addDevice(new AsteroidGun());
                player.addDevice(new BoostDevice());
                player.addDevice(new HaltDevice());
                player.addDevice(new KickDevice());
                player.addDevice(new LaserGun());
                player.addDevice(new MineDevice(3));
                player.addDevice(new PlasmaGun());
                player.addDevice(new RepairDevice(3));
                player.addDevice(new ScatterGun());
                player.addDevice(new Shield());
                GMedia.playSound("resurect");
            } else {
                this.cheat = 0;
            }
        } else if (c == 'P' && Global.gameType != 0) {
            this.gp.msg = null;
            Global.gen.resume();
        }
    }

    public void newHostGame() {
        Global.gameType = (byte)2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < 4) {
            n3 *= 10;
            if (Global.players[n4] != null) {
                ++n2;
                ++n3;
                if (Global.players[n4].name.equals("--net--")) {
                    ++n;
                } else if (Global.players[n4].name.startsWith("Computer")) {
                    ++n3;
                }
            }
            ++n4;
        }
        Global.dp("Nets: " + n + " players: " + n2 + " which: " + n3);
        Global.reporter = new GReporterHost(n);
        Global.gen.setPreActive(Global.reporter);
        Socket socket = null;
        try {
            ServerSocket serverSocket = new ServerSocket(9205);
            int n5 = 0;
            GReporterHost.GConnection gConnection = null;
            while (n5 < 4) {
                if (Global.players[n5] != null && Global.players[n5].name.equals("--net--")) {
                    if (socket == null) {
                        Global.dp("Waiting...");
                        socket = serverSocket.accept();
                        Global.dp("...got connection");
                        gConnection = new GReporterHost.GConnection(socket);
                        if (gConnection.in.readInt() == 956483) {
                            Global.dp("Read Magic Number");
                            ((GReporterHost)Global.reporter).addConnection(gConnection);
                        } else {
                            Global.dp("Bad Connection");
                            socket.close();
                            socket = null;
                            gConnection = null;
                        }
                    }
                    if (gConnection == null) continue;
                    gConnection.out.writeInt(n3);
                    Global.dp("sent which");
                    gConnection.out.writeInt(n5);
                    Global.dp("sent num");
                    gConnection.out.writeInt(Global.startLives);
                    Global.dp("sent lives");
                    gConnection.out.writeByte(Global.POWERUPS);
                    Global.dp("sent powerup");
                    Global.players[n5].name = gConnection.in.readUTF();
                    ++n5;
                    if (gConnection.in.readInt() == 0) {
                        Global.dp("no more");
                        socket = null;
                        gConnection = null;
                    }
                    Global.dp("done");
                    continue;
                }
                ++n5;
            }
            if (socket != null) {
                gConnection.out.writeInt(-333);
                socket = null;
                gConnection = null;
            }
            Global.stat1.player1 = Global.players[0] == null ? null : Global.players[0];
            Global.stat2.player1 = Global.players[1] == null ? null : Global.players[1];
            Global.stat1.player2 = Global.players[2] == null ? null : Global.players[2];
            Global.stat2.player2 = Global.players[3] == null ? null : Global.players[3];
            ((GReporterHost)Global.reporter).sendStart();
            Global.dp("ready to start");
            Global.gen.start();
            Global.display.requestFocus();
            Global.dp("Start (host)");
        }
        catch (Exception exception) {
            System.err.println("IOEXCEPTION. CAN'T START (host)");
            exception.printStackTrace();
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                socket = null;
            }
            ((GReporterHost)Global.reporter).closeConnections();
        }
    }

    public void newJoinGame() {
        boolean bl;
        Global.gameType = (byte)4;
        Global.gen.removeAll();
        Global.players[0] = null;
        Global.players[1] = null;
        Global.players[2] = null;
        Global.players[3] = null;
        Global.player1 = -1;
        Global.player2 = -1;
        Global.display.msg = null;
        System.gc();
        Properties properties = new Properties();
        JoinDialog joinDialog = new JoinDialog(properties);
        joinDialog.show();
        boolean bl2 = properties.get("local1") != null;
        boolean bl3 = bl = properties.get("local2") != null;
        if (!bl2 && !bl) {
            this.showStart();
            return;
        }
        String string = (String)properties.get("host");
        try {
            Global.dp("Connecting...");
            Socket socket = new Socket(string, 9205);
            Global.dp("connection");
            GReporterHost.GConnection gConnection = new GReporterHost.GConnection(socket);
            Global.dp("Sending Magic Number");
            gConnection.out.writeInt(956483);
            Global.reporter = new GReporterClient(gConnection);
            Global.gen.setPreActive(Global.reporter);
            Global.dp("Reading which");
            int n = gConnection.in.readInt();
            Global.dp("Reading num");
            int n2 = gConnection.in.readInt();
            Global.dp("Which players:" + n);
            Global.dp("My number:" + n2);
            Global.startLives = gConnection.in.readInt();
            Global.POWERUPS = gConnection.in.readByte();
            int n3 = 0;
            n3 = n / 1000;
            if (n3 != 0) {
                Global.players[0] = StartPanel.mkplayer(0);
                Global.players[0].name = n3 == 1 ? "Network 1" : "Computer 1";
                Global.players[0].lives = Global.startLives;
                Global.gen.addSprite(Global.players[0]);
            }
            if ((n3 = n / 100 % 10) != 0) {
                Global.players[1] = StartPanel.mkplayer(1);
                Global.players[1].name = n3 == 1 ? "Network 2" : "Computer 2";
                Global.players[1].lives = Global.startLives;
                Global.gen.addSprite(Global.players[1]);
            }
            if ((n3 = n / 10 % 10) != 0) {
                Global.players[2] = StartPanel.mkplayer(2);
                Global.players[2].name = n3 == 1 ? "Network 3" : "Computer 3";
                Global.players[2].lives = Global.startLives;
                Global.gen.addSprite(Global.players[2]);
            }
            if ((n3 = n % 10) != 0) {
                Global.players[3] = StartPanel.mkplayer(3);
                Global.players[3].name = n3 == 1 ? "Network 4" : "Computer 4";
                Global.players[3].lives = Global.startLives;
                Global.gen.addSprite(Global.players[3]);
            }
            if (bl2) {
                if (bl) {
                    Global.player1 = n2;
                    Global.players[n2].name = "Net 1";
                    gConnection.out.writeUTF(Global.players[n2].name);
                    Global.dp("Sending 2P");
                    gConnection.out.writeInt(1);
                    Global.dp("Reading which");
                    n = gConnection.in.readInt();
                    if (n == -333) {
                        Global.dp("2P denied");
                        Global.player2 = -3;
                    } else {
                        Global.dp("Reading num");
                        n2 = gConnection.in.readInt();
                        Global.startLives = gConnection.in.readInt();
                        Global.POWERUPS = gConnection.in.readByte();
                        Global.player2 = n2;
                        Global.players[n2].name = "Net 2";
                        gConnection.out.writeUTF(Global.players[n2].name);
                        Global.dp("sending no more");
                        gConnection.out.writeInt(0);
                    }
                } else {
                    Global.player1 = n2;
                    Global.players[n2].name = "Net 1";
                    gConnection.out.writeUTF(Global.players[n2].name);
                    Global.player2 = -3;
                    gConnection.out.writeInt(0);
                }
            } else if (bl) {
                Global.player2 = n2;
                Global.players[n2].name = "Net 2";
                gConnection.out.writeUTF(Global.players[n2].name);
                Global.player1 = -2;
                gConnection.out.writeInt(0);
            }
            Global.stat1.player1 = Global.players[0] == null ? null : Global.players[0];
            Global.stat2.player1 = Global.players[1] == null ? null : Global.players[1];
            Global.stat1.player2 = Global.players[2] == null ? null : Global.players[2];
            Global.stat2.player2 = Global.players[3] == null ? null : Global.players[3];
            Global.dp("Checking start sig");
            if (gConnection.in.readInt() != 5555) {
                return;
            }
            Global.dp("starting");
            Global.gen.start();
            Global.display.requestFocus();
            Global.dp("Start (join)");
        }
        catch (Exception exception) {
            System.err.println("IOEXCEPTION CAN'T START (join)");
            exception.printStackTrace();
        }
    }

    public void newLocalGame() {
        Global.gameType = 1;
        Global.reporter = new GReporter();
        Global.gen.setPreActive(Global.reporter);
        Global.stat1.player1 = Global.players[0] == null ? null : Global.players[0];
        Global.stat2.player1 = Global.players[1] == null ? null : Global.players[1];
        Global.stat1.player2 = Global.players[2] == null ? null : Global.players[2];
        Global.stat2.player2 = Global.players[3] == null ? null : Global.players[3];
        Global.gen.start();
        Global.display.requestFocus();
    }

    public void newSoloGame() {
        Global.gameType = (byte)5;
        Global.reporter = new GReporter();
        Global.gen.setPreActive(Global.reporter);
        Global.stat1.player1 = Global.players[0] == null ? null : Global.players[0];
        Global.stat2.player1 = Global.players[1] == null ? null : Global.players[1];
        Global.stat1.player2 = Global.players[2] == null ? null : Global.players[2];
        Global.stat2.player2 = Global.players[3] == null ? null : Global.players[3];
        ObsticleManager obsticleManager = new ObsticleManager();
        Global.gen.addSprite(obsticleManager);
        obsticleManager.init();
        Global.gen.start();
        Global.display.requestFocus();
    }

    public void playerDeath(int n) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < 4) {
            if (Global.players[n3] != null && Global.players[n3].lives > 0) {
                if (n2 != -1) {
                    return;
                }
                n2 = n3;
            }
            ++n3;
        }
        if (n2 != -1) {
            this.endGame(n2 + 1);
        } else {
            this.endGame(-1);
        }
    }

    protected void endGame(int n) {
        Global.gen.stop();
        if (Global.gameType == 2) {
            ((GReporterHost)Global.reporter).closeConnections();
        } else if (Global.gameType == 4) {
            // empty if block
        }
        this.gp.mcolor = Color.blue;
        if (n == 0) {
            this.gp.msg = "Game Over (Aborted)";
        } else if (n == -1 || Global.players[n - 1] == null) {
            if (Global.gameType == 5) {
                this.gp.msg = "Game Over";
                if (Global.hlist.testScore(ObsticleManager.score)) {
                    this.scoresNext = true;
                }
            } else {
                this.gp.msg = "Game Over (All dead!)";
            }
        } else {
            this.gp.msg = "Game Over: " + Global.players[n - 1].name + " Wins!!";
        }
        this.gp.repaint();
        Global.gameType = 0;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(8000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (Main.this.scoresNext) {
                    Main.this.hsD.show();
                    Global.hlist.addScore(new HighScoreList.HSob(Main.this.hsD.name, ObsticleManager.score, Main.this.hsD.quote));
                    Main.this.scoresNext = false;
                    Main.this.showScores();
                } else {
                    Main.this.showStart();
                }
            }
        });
        thread.start();
    }

    public void addPowerUp() {
        if (Global.POWERUPS == 0) {
            return;
        }
        if (Global.gameType == 4) {
            return;
        }
        double[] dArray = new double[]{Math.random(), Math.random() * 10.0 + 2.0, Math.random() * 10.0 + 2.0, Math.random()};
        Global.reporter.report2(30, dArray);
    }

    public void addAsteroid() {
        if (!Global.ASTEROIDS) {
            return;
        }
        if (Global.gameType == 4) {
            return;
        }
        double[] dArray = new double[4];
        double d = Math.random();
        if (d < 0.5) {
            dArray[0] = Math.random() * 460.0 + 20.0;
            dArray[1] = d < 0.25 ? 0.0 : 480.0;
        } else {
            dArray[0] = d < 0.25 ? 0.0 : 480.0;
            dArray[1] = Math.random() * 460.0 + 20.0;
        }
        dArray[2] = Math.random() * 10.0 + 2.0;
        dArray[3] = Math.random() * 10.0 + 2.0;
        Global.reporter.report2(31, dArray);
    }

    public void createPowerUp(double d, double d2, double d3, double d4) {
        Rectangle rectangle = new Rectangle(20, 240, 20, 20);
        if (d > 0.75) {
            rectangle.x = 460;
        } else if (d > 0.5) {
            rectangle.x = 240;
            rectangle.y = 20;
        } else if (d > 0.25) {
            rectangle.x = 240;
            rectangle.y = 460;
        }
        Global.gen.addSprite(new PowerUp(GMedia.getImage("powerup"), rectangle, d2, d3, d4));
    }

    public void createAsteroid(double d, double d2, double d3, double d4) {
        Global.gen.addSprite(new Asteroid(GMedia.getImage("asteroid"), new Rectangle((int)d, (int)d2, 20, 20), d3, d4));
    }
}

