/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;

public class NumberField
extends JTextField
implements KeyListener,
FocusListener {
    public static final boolean INTEGRAL = false;
    public static final boolean FLOATING = true;
    String last = null;
    int sizeLimit = -1;
    double min = 0.0;
    double max = 0.0;
    boolean limit = false;
    boolean type = false;

    public NumberField() {
        this.addKeyListener(this);
    }

    public NumberField(int n) {
        this.last = "" + n;
        this.setText(this.last);
        this.addKeyListener(this);
    }

    public NumberField(int n, int n2) {
        super("" + n, n2);
        this.last = "" + n;
        this.addKeyListener(this);
    }

    public NumberField(double d) {
        this.type = true;
        this.last = "" + d;
        this.setText(this.last);
        this.addKeyListener(this);
    }

    public NumberField(double d, int n) {
        super("" + d, n);
        this.type = true;
        this.last = "" + d;
        this.addKeyListener(this);
    }

    public NumberField(boolean bl) {
        this.type = bl;
        this.addKeyListener(this);
    }

    public NumberField(boolean bl, int n) {
        super("", n);
        this.type = bl;
        this.addKeyListener(this);
    }

    public int getIntValue() {
        if (this.last == null) {
            return -1;
        }
        if (!this.type) {
            return Integer.parseInt(this.last);
        }
        return (int)Double.parseDouble(this.last);
    }

    public void setIntValue(int n) {
        this.last = "" + n;
        this.forceRecheck();
    }

    public double getDoubleValue() {
        if (this.last == null) {
            return -1.0;
        }
        try {
            return Double.parseDouble(this.last);
        }
        catch (Exception exception) {
            System.out.println("Exception in NumberField.getDoubleValue(86):" + exception);
            return -1.0;
        }
    }

    public void setDoubleValue(double d) {
        this.last = !this.type ? "" + (int)d : "" + d;
        this.forceRecheck();
    }

    public void setMinValue(int n) {
        if (this.max < this.min && this.max >= (double)n) {
            this.max = n - 1;
        }
        this.min = n;
        this.forceRecheck();
    }

    public void setMaxValue(int n) {
        this.max = n;
        this.forceRecheck();
    }

    public void setMinValue(double d) {
        if (this.max < this.min && this.max >= d) {
            this.max = d - 1.0;
        }
        this.min = d;
        this.forceRecheck();
    }

    public void setMaxValue(double d) {
        this.max = d;
        this.forceRecheck();
    }

    public double getMinValue() {
        return this.min;
    }

    public double getMaxValue() {
        return this.max;
    }

    public void setLimitRange(boolean bl) {
        this.limit = bl;
        this.forceRecheck();
    }

    public boolean isLimitRange() {
        return this.limit;
    }

    public void setCharLimit(int n) {
        this.sizeLimit = n;
    }

    public boolean getType() {
        return this.type;
    }

    public void setType(boolean bl) {
        this.type = bl;
        this.setText(this.last);
        this.forceRecheck();
    }

    private void forceRecheck() {
        this.setText(this.last);
        this.last = null;
        this.checkValid(null);
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.checkValid(keyEvent);
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.checkValid(keyEvent);
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.checkValid(keyEvent);
    }

    public void focusGained(FocusEvent focusEvent) {
        ((JTextField)focusEvent.getSource()).selectAll();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.checkValid(null);
    }

    protected void checkValid(KeyEvent keyEvent) {
        String string = this.getText();
        if (this.last != null && string.equals(this.last)) {
            return;
        }
        if (this.type && string.endsWith(".") && !string.endsWith("..")) {
            return;
        }
        if (string.length() == 1 && (string.startsWith("-") || string.startsWith("+"))) {
            return;
        }
        if (string == null || string.equals("")) {
            this.last = "0";
            return;
        }
        if (this.sizeLimit <= 0 || string.length() <= this.sizeLimit) {
            try {
                double d = 0.0;
                d = !this.type ? (double)Integer.parseInt(string) : Double.parseDouble(string);
                if (this.limit) {
                    if (d < this.min) {
                        d = this.min;
                        string = "" + NumberField.format(d);
                        this.setText(string);
                    } else if (this.max >= this.min && d > this.max) {
                        d = this.max;
                        string = "" + NumberField.format(d);
                        this.setText(string);
                    }
                }
                this.last = string;
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.last != null) {
            this.setText(this.last);
        } else {
            this.setText("");
        }
        if (keyEvent != null) {
            keyEvent.consume();
        }
    }

    public static String format(double d) {
        if (d != (double)((int)d)) {
            return "" + d;
        }
        return "" + (int)d;
    }
}

