/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;

public class ObsticleManager
extends Sprite {
    public static int score = 0;
    private int level = 1;
    private Color color = new Color(1, 0, 254);
    private boolean flash = false;
    private int gunner_time = 1500;
    private int powerup_count = 900;
    private int target_count = 600;
    private int bomb_accum = 0;

    public ObsticleManager() {
        this.bounds.x = 200;
        this.bounds.y = 5;
        this.bounds.width = 100;
        this.bounds.height = 40;
        this.visible = true;
        this.active = true;
        this.tangible = false;
        score = 0;
    }

    public void init() {
        this.addMines(15);
        int n = 0;
        while (n < 2) {
            this.addBomb();
            ++n;
        }
        this.addGunner();
        this.addTarget();
    }

    public void update() {
        if (this.gunner_time-- <= 0) {
            this.addGunner();
        }
        if ((this.powerup_count -= (int)(Math.random() * 4.0 + 1.0)) <= 0) {
            Global.main.addPowerUp();
            this.powerup_count = 900;
        }
        if ((this.target_count -= (int)(Math.random() * 5.0 + 1.0)) <= 0) {
            this.addTarget();
            this.target_count = 600;
        }
    }

    public void paint(Graphics graphics) {
        if (this.flash) {
            this.flash = false;
            graphics.setColor(Color.green);
        } else {
            graphics.setColor(this.color);
        }
        graphics.setFont(new Font("Serif", 0, 18));
        graphics.drawString("Score: " + score, this.bounds.x, this.bounds.y + this.bounds.height);
    }

    private void addGunner() {
        int n = (int)(Math.random() * 260.0 + 120.0);
        int n2 = (int)(Math.random() * 260.0 + 120.0);
        double d = Math.random() * 8.0 + 2.0;
        double d2 = Math.random() * 8.0 + 2.0;
        int n3 = 3;
        double d3 = Math.random();
        if (d3 > 0.6) {
            n3 = 4;
        } else if (d3 > 0.35) {
            n3 = 5;
        }
        int n4 = 1;
        d3 = Math.random();
        if (d3 > 0.6) {
            n4 = 2;
        } else if (d3 > 0.3) {
            d = 0.0;
            d2 = 0.0;
        }
        Global.gen.addSprite(new Gunner(GMedia.getImage("gunner"), n, n2, 0.0, 0.0, n3, n4, this));
        this.gunner_time = 1500 - this.level;
    }

    private void addTarget() {
        int n = (int)(Math.random() * 260.0 + 120.0);
        int n2 = (int)(Math.random() * 260.0 + 120.0);
        double d = Math.random() * 10.0 + 2.0;
        double d2 = Math.random() * 10.0 + 2.0;
        int n3 = 1;
        double d3 = Math.random();
        if (d3 > 0.6) {
            n3 = 2;
        } else if (d3 > 0.3) {
            d = 0.0;
            d2 = 0.0;
        }
        Global.gen.addSprite(new Target(GMedia.getImage("target"), n, n2, d, d2, n3, this));
    }

    private void addMines(int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            n2 = (int)(Math.random() * 390.0 + 55.0);
            n3 = (int)(Math.random() * 390.0 + 55.0);
            Global.gen.addSprite(new Mine(n2, n3, -2));
            ++n4;
        }
    }

    protected void addBomb() {
        double d = Math.random() * 10.0 + 2.0;
        double d2 = Math.random() * 10.0 + 2.0;
        double d3 = Math.random();
        Rectangle rectangle = new Rectangle(20, 240, 15, 15);
        if (d3 > 0.75) {
            rectangle.x = 460;
        } else if (d3 > 0.5) {
            rectangle.x = 240;
            rectangle.y = 20;
        } else if (d3 > 0.25) {
            rectangle.x = 240;
            rectangle.y = 460;
        }
        int n = 1;
        if (Math.random() > 0.5) {
            n = 2;
        }
        Global.gen.addSprite(new Bomb(GMedia.getImage("bomb"), rectangle, d, d2, n, this));
    }

    public void gunnerDie() {
        this.gunner_time = 50;
        score += 2 * this.level + 100;
    }

    public void targetDie(double d) {
        score = (int)((double)score + d * (double)(this.level / 10 + 1));
        if (Math.random() > 0.9) {
            this.addTarget();
        }
    }

    public void bombDie() {
        score += this.level + 5;
        if (++this.bomb_accum > 7) {
            this.addBomb();
            this.level += 10;
            if (this.level > 255) {
                this.level = 255;
            }
            this.color = new Color(this.level, 0, 255 - this.level);
            this.addMines(this.level / 10);
            this.bomb_accum = 0;
            this.flash = true;
        }
        this.addBomb();
    }
}

