/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;

public class Player
extends Sprite {
    public String name = null;
    public int lives = 0;
    public int health = 100;
    public double strength = 1.0;
    public Color color;
    public String weapon1 = "Laser";
    public String weapon2 = "none";
    protected boolean up = false;
    protected boolean down = false;
    protected boolean left = false;
    protected boolean right = false;
    protected boolean fire = false;
    protected boolean fire2 = false;
    protected Rectangle startBounds;
    public int number = -1;
    Image thrustImg;
    Image nothrustImg;
    final double accel = 1.3;
    final double decel = 2.8;
    double max = 9.0;
    final double turn = 0.2617993877991494;
    final double turnSmall = 0.08726646259971647;
    protected double angle = 1.5707963267948966;
    double travelAng = 0.0;
    double velX = 0.0;
    double velY = 0.0;
    double locX = 0.0;
    double locY = 0.0;
    protected boolean boostFlag = false;
    private Device[] devs = new Device[12];
    private int numdevs = 0;
    private int curdev = -1;
    private Device[] devs2 = new Device[12];
    private int numdevs2 = 0;
    private int curdev2 = -1;

    public Player(Image image, Image image2, Rectangle rectangle, int n) {
        super(image, rectangle);
        this.nothrustImg = image;
        this.thrustImg = image2;
        this.setActive(true);
        this.setTangible(true);
        this.setVisible(true);
        this.number = n;
        this.startBounds = new Rectangle(this.bounds);
        this.locX = this.bounds.x;
        this.locY = this.bounds.y;
        this.addDevice(new LaserGun());
        this.curdev = 0;
        switch (this.number) {
            case 0: {
                this.color = Color.blue;
                break;
            }
            case 1: {
                this.color = Color.green;
                break;
            }
            case 2: {
                this.color = Color.yellow;
                break;
            }
            case 3: {
                this.color = Color.red;
            }
        }
    }

    public void paint(Graphics graphics) {
        int n = this.bounds.x + this.bounds.width / 2;
        int n2 = this.bounds.y + this.bounds.height / 2;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.translate(n, n2);
        graphics2D.rotate(Math.PI * 2 - (this.angle - 1.5707963267948966));
        graphics2D.drawImage(this.image, -this.bounds.width / 2, -this.bounds.height / 2, this.bounds.width, this.bounds.height, Global.observer);
        graphics2D.dispose();
        if (this.curdev != -1) {
            this.devs[this.curdev].paint(graphics);
        }
        if (this.curdev2 != -1) {
            this.devs2[this.curdev2].paint(graphics);
        }
    }

    public void update() {
        double d = Math.sqrt(this.velY * this.velY + this.velX * this.velX);
        if (this.up) {
            this.velX += 1.3 * Math.cos(this.angle);
            this.velY += 1.3 * Math.sin(this.angle);
            d = Math.sqrt(this.velY * this.velY + this.velX * this.velX);
            this.calcAng();
            if (d >= this.max) {
                this.velX = this.max * Math.cos(this.travelAng);
                this.velY = this.max * Math.sin(this.travelAng);
            }
        } else if (this.down) {
            if (d > 1.3) {
                double d2 = 1.3 * Math.cos(this.travelAng + Math.PI);
                this.velX = Math.abs(this.velX) > Math.abs(d2) ? (this.velX += d2) : 0.0;
                double d3 = 1.3 * Math.sin(this.travelAng + Math.PI);
                this.velY = Math.abs(this.velY) > Math.abs(d3) ? (this.velY += d3) : 0.0;
                this.calcAng();
            } else {
                this.velY = 0.0;
                this.velX = 0.0;
            }
        }
        if (this.left) {
            this.angle += d == 0.0 ? 0.08726646259971647 : 0.2617993877991494;
        } else if (this.right) {
            this.angle -= d == 0.0 ? 0.08726646259971647 : 0.2617993877991494;
        }
        while (this.angle < 0.0) {
            this.angle += Math.PI * 2;
        }
        while (this.angle >= Math.PI * 2) {
            this.angle -= Math.PI * 2;
        }
        if (this.velX != 0.0 || this.velY != 0.0) {
            this.locX += this.velX;
            this.locY -= this.velY;
            if (this.locX < 0.0) {
                this.locX = 0.0;
            } else if (this.locX > (double)(500 - this.bounds.width)) {
                this.locX = 500.0 - (double)this.bounds.width;
            }
            if (this.locY < 0.0) {
                this.locY = 0.0;
            } else if (this.locY > (double)(500 - this.bounds.height)) {
                this.locY = 500.0 - (double)this.bounds.height;
            }
            this.bounds.x = (int)this.locX;
            this.bounds.y = (int)this.locY;
            this.repaint();
        }
        if (this.curdev != -1) {
            this.devs[this.curdev].update();
        }
        if (this.curdev2 != -1) {
            this.devs2[this.curdev2].update();
        }
    }

    public final void calcAng() {
        this.travelAng = Math.atan(Math.abs(this.velY / this.velX));
        if (this.velY > 0.0) {
            if (this.velX < 0.0) {
                this.travelAng = Math.PI - this.travelAng;
            }
        } else {
            this.travelAng = this.velX > 0.0 ? Math.PI * 2 - this.travelAng : Math.PI + this.travelAng;
        }
    }

    public void moveUp(boolean bl) {
        this.up = bl;
        if (this.up) {
            GMedia.playSound("thrust");
            this.setImage(this.thrustImg);
        } else {
            this.setImage(this.nothrustImg);
        }
    }

    public void moveDown(boolean bl) {
        this.down = bl;
    }

    public void moveLeft(boolean bl) {
        this.left = bl;
    }

    public void moveRight(boolean bl) {
        this.right = bl;
    }

    public void fire(boolean bl) {
        if (bl && this.curdev2 != -1 && this.devs2[this.curdev2] instanceof Shield && this.fire2) {
            return;
        }
        this.fire = bl;
        if (this.curdev != -1) {
            this.devs[this.curdev].activate(bl);
            if (this.devs[this.curdev] instanceof Shield) {
                this.fire2(false);
            }
        }
    }

    public void fire2(boolean bl) {
        if (bl && this.curdev != -1 && this.devs[this.curdev] instanceof Shield && this.fire) {
            return;
        }
        this.fire2 = bl;
        if (this.curdev2 != -1) {
            this.devs2[this.curdev2].activate(bl);
            if (this.devs2[this.curdev2] instanceof Shield) {
                this.fire(false);
            }
        }
    }

    public void rotateDev() {
        if (this.numdevs > 0) {
            ++this.curdev;
            this.curdev %= this.numdevs;
            this.fire = this.devs[this.curdev].active;
            this.status();
        } else {
            this.curdev = -1;
            this.status();
        }
    }

    public void rotateDev2() {
        if (this.numdevs2 > 0) {
            ++this.curdev2;
            this.curdev2 %= this.numdevs2;
            this.fire2 = this.devs2[this.curdev2].active;
            this.status();
        } else {
            this.curdev2 = -1;
            this.status();
        }
    }

    public void switchDev() {
        if (this.curdev != -1 && this.numdevs2 < this.devs2.length) {
            this.devs2[this.numdevs2] = this.devs[this.curdev];
            this.devs2[this.numdevs2].id = this.numdevs2++;
            this.devs[this.curdev] = this.devs[--this.numdevs];
            this.devs[this.curdev].id = this.curdev;
            this.devs[this.numdevs] = null;
            this.curdev = this.numdevs > 0 ? (this.curdev %= this.numdevs) : -1;
            if (this.curdev2 == -1) {
                this.curdev2 = 0;
            }
            this.fire = this.devs[this.curdev].active;
            this.fire2 = this.devs2[this.curdev2].active;
            this.status();
        }
    }

    public void switchDev2() {
        if (this.curdev2 != -1 && this.numdevs < this.devs.length) {
            this.devs[this.numdevs] = this.devs2[this.curdev2];
            this.devs[this.numdevs].id = this.numdevs++;
            this.devs2[this.curdev2] = this.devs2[--this.numdevs2];
            this.devs2[this.curdev2].id = this.curdev2;
            this.devs2[this.numdevs2] = null;
            this.curdev2 = this.numdevs2 > 0 ? (this.curdev2 %= this.numdevs2) : -1;
            if (this.curdev == -1) {
                this.curdev = 0;
            }
            this.fire = this.curdev != -1 ? this.devs[this.curdev].active : false;
            this.fire2 = this.curdev2 != -1 ? this.devs2[this.curdev2].active : false;
            this.status();
        }
    }

    public void removeDevice(Device device) {
        if (device.id >= 0 && device.id < this.numdevs && this.devs[device.id] == device) {
            --this.numdevs;
            this.devs[device.id] = this.devs[this.numdevs];
            this.devs[device.id].id = device.id;
            this.devs[this.numdevs] = null;
            if (this.curdev == this.numdevs) {
                this.curdev = device.id;
            }
            device.id = -1;
            device.owner(null);
            this.curdev = this.numdevs > 0 ? (this.curdev %= this.numdevs) : -1;
            this.status();
        } else if (device.id >= 0 && device.id < this.numdevs2 && this.devs2[device.id] == device) {
            --this.numdevs2;
            this.devs2[device.id] = this.devs2[this.numdevs2];
            this.devs2[device.id].id = device.id;
            this.devs2[this.numdevs2] = null;
            if (this.curdev2 == this.numdevs2) {
                this.curdev2 = device.id;
            }
            device.id = -1;
            device.owner(null);
            this.curdev2 = this.numdevs2 > 0 ? (this.curdev2 %= this.numdevs2) : -1;
            this.status();
        }
    }

    public void addDevice(Device device) {
        if (this.numdevs < this.devs.length) {
            int n = 0;
            while (n < this.numdevs) {
                if (this.devs[n].getClass().equals(device.getClass())) {
                    this.devs[n].merge(device);
                    this.status();
                    return;
                }
                ++n;
            }
            int n2 = 0;
            while (n2 < this.numdevs2) {
                if (this.devs2[n2].getClass().equals(device.getClass())) {
                    this.devs2[n2].merge(device);
                    this.status();
                    return;
                }
                ++n2;
            }
            this.devs[this.numdevs] = device;
            device.id = this.numdevs++;
            device.owner(this);
        }
    }

    public void collide(GTangible gTangible) {
        if (gTangible instanceof PowerUp) {
            this.addDevice(((PowerUp)gTangible).item);
        } else if ((this.tangible && gTangible instanceof Shot && ((Shot)gTangible).player != this.number || gTangible instanceof Bomb) && (this.curdev == -1 || this.devs[this.curdev].collide((Sprite)gTangible)) && (this.curdev2 == -1 || this.devs2[this.curdev2].collide((Sprite)gTangible))) {
            if (gTangible instanceof Shot) {
                this.health = (int)((double)this.health - (double)((Shot)gTangible).power * this.strength);
                if (this.health < 0) {
                    this.health = 0;
                }
                this.status();
            } else if (gTangible instanceof Bomb) {
                this.health = (int)((double)this.health - 100.0 * this.strength);
                if (this.health < 0) {
                    this.health = 0;
                }
                this.status();
            }
            if (this.health <= 0) {
                this.die();
            }
        }
    }

    public void setBounds(Rectangle rectangle) {
        super.setBounds(rectangle);
        this.locX = this.bounds.x;
        this.locY = this.bounds.y;
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        super.setBounds(n, n2, n3, n4);
        this.locX = this.bounds.x;
        this.locY = this.bounds.y;
    }

    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
        this.locX = this.bounds.x;
        this.locY = this.bounds.y;
    }

    public void die() {
        this.setActive(false);
        this.setTangible(false);
        this.setVisible(false);
        Global.gen.addSprite(new Explosion(new Rectangle(this.bounds)));
        GMedia.playSound("die");
        --this.lives;
        this.status();
        if (this.lives <= 0) {
            Global.main.playerDeath(this.number);
        }
    }

    public void resurect() {
        this.setBounds(this.startBounds);
        this.velY = 0.0;
        this.velX = 0.0;
        this.fire = false;
        this.right = false;
        this.left = false;
        this.down = false;
        this.up = false;
        if (this.curdev != -1) {
            this.devs[this.curdev].activate(false);
        }
        this.setVisible(true);
        this.setTangible(true);
        this.setActive(true);
        this.health = 100;
        this.status();
        GMedia.playSound("resurect");
    }

    public void status() {
        this.weapon1 = this.curdev != -1 ? this.devs[this.curdev].getDisplay() : "none";
        this.weapon2 = this.curdev2 != -1 ? this.devs2[this.curdev2].getDisplay() : "none";
        Global.repaintStat(this.number);
    }
}

