/*
 * Decompiled with CFR 0.152.
 */
public class PlayerBrain
extends Sprite {
    Player player = null;
    final int NONE = 0;
    final int TURN = 1;
    final int ACCEL = 2;
    final int DECEL = 3;
    int ustate = 0;
    double uarg = 0.0;
    final int GO = 1;
    final int FIRE = 2;
    final int FIRING = 3;
    final int LE = 4;
    final int TE = 5;
    final int RE = 6;
    final int BE = 7;
    int bstate = 0;
    int edge = 0;
    double barg = 0.0;
    int barg2 = 0;
    int count = -1;

    public PlayerBrain(Player player) {
        this.player = player;
        this.bounds.width = 180;
        this.bounds.height = 180;
        this.bounds.x = this.player.bounds.x - 80;
        this.bounds.y = this.player.bounds.y - 80;
        this.visible = false;
        this.active = true;
        this.tangible = true;
    }

    public void update() {
        if (this.count == 0) {
            this.count = -5;
            if (this.player.lives > 0) {
                Global.reporter.report(this.player.number, 13);
            } else {
                this.active = false;
                this.tangible = false;
            }
            return;
        }
        if (this.count > 0) {
            --this.count;
        }
        if (this.count == -5) {
            return;
        }
        if (!this.player.isActive()) {
            this.bstate = 0;
            this.ustate = 0;
            this.count = 10;
            return;
        }
        this.count = -1;
        if (this.ustate == 0) {
            if (this.bstate == 1) {
                Global.dp("go");
                this.uarg = 0.6666666666666666 * this.player.max;
                this.ustate = 2;
                this.bstate = 0;
                Global.reporter.report(this.player.number, 2);
            } else if (this.bstate == 2) {
                Global.dp("fire");
                Global.reporter.report(this.player.number, 10);
                this.barg2 = 6;
                this.ustate = 0;
                this.bstate = 3;
            } else if (this.bstate == 3) {
                if (this.barg2-- == 0) {
                    Global.dp("end firing");
                    this.bstate = 0;
                    this.ustate = 0;
                }
            } else if (this.bounds.x < 0) {
                if (this.edge != 4) {
                    if (this.bounds.x > 250) {
                        this.turn(0.5235987755982988);
                    } else {
                        this.turn(5.759586531581287);
                    }
                    this.bstate = 1;
                    this.edge = 4;
                }
            } else if (this.bounds.y < 0) {
                if (this.bounds.y > 250) {
                    this.turn(5.235987755982989);
                } else {
                    this.turn(4.1887902047863905);
                }
                this.bstate = 1;
            } else if (this.bounds.x + this.bounds.width > 500) {
                if (this.bounds.x > 250) {
                    this.turn(2.6179938779914944);
                } else {
                    this.turn(3.6651914291880923);
                }
                this.bstate = 1;
            } else if (this.bounds.y + this.bounds.height > 500) {
                if (this.bounds.y > 250) {
                    this.turn(2.0943951023931953);
                } else {
                    this.turn(1.0471975511965976);
                }
                this.bstate = 1;
            }
            if (this.bstate == 1) {
                Global.dp("_go_");
            }
        }
        if (this.ustate == 1) {
            if (Math.abs(this.player.angle - this.uarg) < this.player.turn) {
                Global.dp("end turning");
                Global.reporter.report(this.player.number, 9);
                Global.reporter.report(this.player.number, 8);
                this.ustate = 0;
            }
        } else if (this.ustate == 2) {
            Global.dp("accel to " + this.uarg);
            if (Math.sqrt(this.player.velY * this.player.velY + this.player.velX * this.player.velX) >= this.uarg) {
                Global.dp("end accel");
                Global.reporter.report(this.player.number, 6);
                this.ustate = 0;
                this.edge = 0;
            }
        } else if (this.ustate == 3 && Math.sqrt(this.player.velY * this.player.velY + this.player.velX * this.player.velX) <= this.uarg) {
            Global.dp("end decel");
            Global.reporter.report(this.player.number, 7);
            this.ustate = 0;
        }
    }

    public void collide(GTangible gTangible) {
        if (gTangible instanceof Player && gTangible != this.player) {
            Player player = (Player)gTangible;
            int n = player.bounds.x - this.bounds.x;
            if (n == 0) {
                n = 1;
            }
            double d = Math.atan(Math.abs(player.bounds.y - this.bounds.y) / Math.abs(n));
            if (player.bounds.y - this.bounds.y < 0) {
                if (n > 0) {
                    d = Math.PI - d;
                }
            } else {
                d = n > 0 ? Math.PI * 2 - d : Math.PI + d;
            }
            this.turn(d);
            this.bstate = 2;
            if (Global.Debug) {
                System.out.print("+");
            }
            Global.reporter.report(this.player.number, 10);
        }
    }

    protected boolean turn(double d) {
        if (d != this.barg) {
            this.barg = this.uarg = d;
            this.ustate = 1;
            if (this.player.angle < Math.PI) {
                if (this.uarg > this.player.angle && this.uarg < this.player.angle + Math.PI) {
                    Global.reporter.report(this.player.number, 5);
                } else {
                    Global.reporter.report(this.player.number, 4);
                }
            } else if (this.uarg < this.player.angle && this.uarg > this.player.angle + Math.PI) {
                Global.reporter.report(this.player.number, 4);
            } else {
                Global.reporter.report(this.player.number, 5);
            }
            return true;
        }
        return false;
    }
}

