/*
 * Decompiled with CFR 0.152.
 */
import eam.saen.Sprite;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class AvatarSprite
extends Sprite
implements KeyListener {
    StatusSprite status;
    Main theMain;
    public static int right = 39;
    public static int left = 37;
    int vel = 0;

    public AvatarSprite(StatusSprite stat, Main m) {
        this.status = stat;
        this.theMain = m;
        this.setWidthPercent(0.05);
        this.setHeightPercent(0.05);
        this.setVisible(true);
        this.setActive(true);
        this.setGroup(2);
        this.setCollideable(true);
        this.setImage(Toolkit.getDefaultToolkit().getImage("Media/avatar.gif"));
        this.setLocation(180, 345);
    }

    public void resize(int width, int height) {
        Rectangle r = null;
        super.resize(width, height);
        r = this.getBounds();
        r.y = height - 35 - this.getHeight();
        this.setBounds(r);
        this.vel = (int)((double)(this.getWidth() / 3) * Main.level);
    }

    public void collisionWith(Sprite s) {
        if (s instanceof DeathSprite) {
            this.status.loseLives(1);
            if (this.status.lives <= 0) {
                this.theMain.doGameOver();
            }
        } else {
            this.status.addPoints(((FallingSprite)s).points);
        }
    }

    public void keyPressed(KeyEvent ke) {
        int key = ke.getKeyCode();
        if (key == right) {
            this.velx = this.vel;
        } else if (key == left) {
            this.velx = -this.vel;
        }
    }

    public void keyTyped(KeyEvent ke) {
    }

    public void keyReleased(KeyEvent ke) {
        int key = ke.getKeyCode();
        if (key == right || key == left) {
            this.velx = 0.0;
        }
    }
}

