/*
 * Decompiled with CFR 0.152.
 */
import eam.saen.Mask;
import eam.saen.Sprite;
import java.awt.Color;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;

public class FallingSprite
extends Sprite {
    public static Image goodImg = null;
    public static Image neutralImg = null;
    public static Image badImg = null;
    public static Mask goodMask = null;
    public static Mask neutMask = null;
    public static Mask badMask = null;
    int points;

    public FallingSprite(int p) {
        block2: {
            this.points = 0;
            this.points = p;
            this.setWidthPercent(0.05);
            this.setHeightPercent(0.05);
            this.setVisible(false);
            this.setActive(false);
            this.setGroup(1);
            if (goodImg != null) break block2;
            MediaTracker tracker = new MediaTracker(Main.self);
            goodImg = Toolkit.getDefaultToolkit().getImage("Media/GoodTreasure.gif");
            tracker.addImage(goodImg, 0);
            neutralImg = Toolkit.getDefaultToolkit().getImage("Media/NeutTreasure.gif");
            tracker.addImage(neutralImg, 1);
            badImg = Toolkit.getDefaultToolkit().getImage("Media/BadTreasure.gif");
            tracker.addImage(badImg, 2);
            try {
                tracker.waitForID(0);
                tracker.waitForID(1);
                tracker.waitForID(2);
            }
            catch (InterruptedException interruptedException) {
                System.err.println("Interrupted in loading Falling Sprite Images");
            }
        }
    }

    public void setPoints(int p) {
        this.points = p;
        if (p > 0) {
            this.setImage(goodImg);
        } else if (p == 0) {
            this.setImage(neutralImg);
        } else {
            this.setImage(badImg);
        }
    }

    public void updateVel() {
        double multi = Main.level / 5.0;
        if (multi < 1.0) {
            multi = 1.0;
        }
        this.velx = 0.0;
        this.vely = (int)((double)(this.getHeight() / 5) * multi);
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        this.updateVel();
    }

    public void suspend() {
        this.setCollideable(false);
        super.suspend();
    }

    public void resume() {
        this.setCollideable(true);
        super.resume();
    }

    public void collisionWith(Sprite s) {
        this.suspend();
        if (s instanceof AvatarSprite) {
            MessageSprite msg = null;
            if (this.points > 0) {
                Main.level += 0.1;
                msg = new MessageSprite(String.valueOf(this.points), Color.blue);
            } else if (this.points == 0) {
                Main.level -= 0.5;
                msg = new MessageSprite("Empty", Color.red);
            } else {
                msg = !(this instanceof DeathSprite) ? new MessageSprite(String.valueOf(this.points), Color.red) : new MessageSprite("Ouch!", Color.red);
            }
            msg.setBounds(this.getX(), this.getY(), 40, 20);
            this.getEngine().addSprite(msg);
        }
    }
}

