/*
 * Decompiled with CFR 0.152.
 */
import com.apple.mrj.MRJFileUtils;
import com.apple.mrj.MRJOSType;
import eam.saen.SpriteEngine;
import eam.saen.SpriteSurface;
import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Main
extends Frame
implements ActionListener {
    SpriteEngine engine;
    SpriteSurface screen;
    MenuItem pause;
    boolean playing = false;
    static AvatarSprite avatar = null;
    StatusSprite status = null;
    public static double level = 1.0;
    public static boolean HighScores = false;
    public static HighScoreList hlist = null;
    public static Main self;

    public static void main(String[] args) {
        try {
            new Main();
        }
        catch (Exception e) {
            System.out.println("caught exception:" + e);
            e.printStackTrace();
        }
        catch (Error err) {
            System.out.println("caught error:" + err + " says:" + err.getMessage());
            err.printStackTrace();
        }
    }

    public Main() {
        self = this;
        try {
            MRJOSType tp = new MRJOSType("sett");
            MRJOSType cr = new MRJOSType("TFls");
            MRJFileUtils.setDefaultFileType((MRJOSType)tp);
            MRJFileUtils.setDefaultFileCreator((MRJOSType)cr);
        }
        catch (Exception exception) {}
        ((Component)this).setBounds(50, 5, 400, 400);
        this.setLayout(new GridLayout(1, 1));
        this.screen = new SpriteSurface(400, 400);
        this.screen.setBackground(Color.gray);
        this.engine = new SpriteEngine(this.screen);
        this.screen.setSpriteEngine(this.engine);
        this.add(this.screen);
        this.screen.setSize(400, 400);
        this.pause = new MenuItem("Pause", new MenuShortcut(80));
        MenuBar mbar = new MenuBar();
        int[] nArray = new int[7];
        nArray[0] = 78;
        nArray[1] = 72;
        nArray[3] = 80;
        nArray[4] = 65;
        nArray[6] = 81;
        Menu game = Main.makeMenu("Game", new Object[]{"New Game", "High Scores", null, this.pause, "Abort", null, "Quit"}, nArray, this);
        mbar.add(game);
        this.setMenuBar(mbar);
        this.loadHS();
        this.addMouseListener(new 1());
        this.addWindowListener(new 2());
        ((Component)this).setVisible(true);
        this.engine.setBoundaryChecking(true);
        this.engine.setFrameRate(20);
        this.engine.setBackgroundImage(Toolkit.getDefaultToolkit().getImage("Media/Fallsbg.gif"));
        this.engine.addSprite(new IntroSprite());
        this.engine.start();
    }

    public void actionPerformed(ActionEvent ae) {
        String args = ((MenuItem)ae.getSource()).getLabel();
        if (args.equals("New Game")) {
            if (this.playing || HighScores) {
                return;
            }
            level = 1.0;
            this.engine.removeAll();
            this.engine.addSprite(new DropSprite(this.engine));
            this.status = new StatusSprite();
            avatar = new AvatarSprite(this.status, this);
            this.addKeyListener(avatar);
            this.screen.addKeyListener(avatar);
            this.engine.addSprite(avatar);
            this.engine.addSprite(this.status);
            this.playing = true;
        } else if (args.equals("High Scores")) {
            if (this.playing || HighScores) {
                return;
            }
            this.engine.removeAll();
            this.engine.addSprite(new ScoreSprite(hlist));
            HighScores = true;
        } else if (args.equals("Pause")) {
            if (this.playing) {
                this.engine.suspend();
                this.pause.setLabel("Continue");
            }
        } else if (args.equals("Continue")) {
            if (this.playing) {
                this.engine.resume();
                this.pause.setLabel("Pause");
            }
        } else if (args.equals("Abort")) {
            this.doGameOver();
        } else if (args.equals("Quit")) {
            this.doQuit();
        }
    }

    public void doQuit() {
        this.engine.stop();
        this.saveHS();
        System.exit(0);
    }

    public void doGameOver() {
        if (this.playing) {
            this.engine.removeAll();
            this.removeKeyListener(avatar);
            this.screen.removeKeyListener(avatar);
            avatar = null;
            this.playing = false;
            this.engine.addSprite(new GameOverSprite(this.status.points));
            this.status = null;
            this.engine.resume();
        }
    }

    public void saveHS() {
        try {
            ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream("HighScores"));
            hlist.saveKeys();
            out.writeObject(hlist);
            out.close();
        }
        catch (Exception exception) {
            System.out.println("problem saving high scores");
        }
    }

    public void loadHS() {
        try {
            FileInputStream fin = new FileInputStream("HighScores");
            ObjectInputStream in = new ObjectInputStream(fin);
            HighScoreList list = (HighScoreList)in.readObject();
            if (list != null) {
                hlist = list;
            }
            hlist.loadKeys();
        }
        catch (Exception exception) {}
        if (hlist == null) {
            hlist = new HighScoreList(10);
        }
    }

    public static Menu makeMenu(Object parent, Object[] items, int[] shortcuts, Object target) {
        Menu m = null;
        if (parent instanceof Menu) {
            m = (Menu)parent;
        } else if (parent instanceof String) {
            m = new Menu((String)parent);
        } else {
            return null;
        }
        int i = 0;
        while (i < items.length) {
            MenuItem mi;
            if (items[i] instanceof String) {
                int sc = shortcuts[i];
                mi = sc != 0 ? new MenuItem((String)items[i], new MenuShortcut(shortcuts[i])) : new MenuItem((String)items[i]);
                if (target instanceof ActionListener) {
                    mi.addActionListener((ActionListener)target);
                }
                m.add(mi);
            } else if (items[i] instanceof CheckboxMenuItem && target instanceof ItemListener) {
                CheckboxMenuItem cmi = (CheckboxMenuItem)items[i];
                cmi.addItemListener((ItemListener)target);
                m.add(cmi);
            } else if (items[i] instanceof MenuItem) {
                mi = (MenuItem)items[i];
                if (target instanceof ActionListener) {
                    mi.addActionListener((ActionListener)target);
                }
                m.add(mi);
            } else if (items[i] == null) {
                m.addSeparator();
            }
            ++i;
        }
        return m;
    }

    private final class 1
    extends MouseAdapter {
        public void mousePressed(MouseEvent me) {
            if (HighScores) {
                Main.this.engine.removeAll();
                Main.this.engine.addSprite(new IntroSprite());
                HighScores = false;
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends WindowAdapter {
        public void windowClosing(WindowEvent me) {
            Main.this.doQuit();
        }

        /* synthetic */ 2() {
        }
    }
}

