/*
 * Decompiled with CFR 0.152.
 */
import eam.saen.Sprite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;

public class StatusSprite
extends Sprite {
    int points = 0;
    int lives = 5;

    public StatusSprite() {
        this.setWidthPercent(1.0);
        this.setHeightPercent(0.0);
        this.setBounds(0, 370, 400, 30);
        this.setVisible(true);
        this.setActive(false);
        this.setCollideable(true);
    }

    public void paint(Graphics g) {
        Rectangle bounds = this.getBounds();
        if (this.lives >= 3) {
            g.setColor(Color.green);
        } else if (this.lives >= 2) {
            g.setColor(Color.yellow);
        } else {
            g.setColor(Color.red);
        }
        g.drawRect(bounds.x, bounds.y, bounds.width, bounds.height);
        g.setFont(new Font("Dialog", 1, 18));
        g.drawString("Lives: " + this.lives + "  Score: " + this.points + "  Level: " + (int)Main.level, bounds.x + 20, bounds.y + 2 * (bounds.height / 3));
    }

    public void resize(int width, int height) {
        super.resize(width, height);
        Rectangle r = this.getBounds();
        this.setBounds(0, height - 30, r.width, r.height);
    }

    public boolean canCollideWith(Sprite s) {
        return s instanceof FallingSprite;
    }

    public void addPoints(int p) {
        this.points += p;
        this.getEngine().registerChange(this.getBounds());
    }

    public void loseLives(int l) {
        this.lives -= l;
        this.getEngine().registerChange(this.getBounds());
    }
}

