/*
 * Decompiled with CFR 0.152.
 */
package eam.saen;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;

public class Mask {
    protected boolean[][] mask;
    Image imgTemp = null;
    Color invTemp = null;

    public Mask(Image image) {
        this.makeFromImage(image, Color.white);
    }

    public Mask(Image image, Color color) {
        this.makeFromImage(image, color);
    }

    public Mask(Mask mask) {
        this.mask = new boolean[mask.mask.length][mask.mask[0].length];
        int n = 0;
        while (n < this.mask.length) {
            System.arraycopy(mask.mask[n], 0, this.mask[n], 0, mask.mask[n].length);
            ++n;
        }
    }

    public void makeFromImage(Image image) {
        this.makeFromImage(image, Color.white);
    }

    public void makeFromImage(Image image, Color color) {
        this.imgTemp = image;
        this.invTemp = color;
        Thread thread = new Thread(new 1());
        thread.start();
    }

    public Image getMaskImage(Component component) {
        Image image = component.createImage(this.mask.length, this.mask[0].length);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, image.getWidth(null), image.getHeight(null));
        graphics.setColor(Color.black);
        int n = 0;
        while (n < this.mask.length) {
            int n2 = 0;
            while (n2 < this.mask[0].length) {
                if (this.mask[n][n2]) {
                    graphics.drawLine(n, n2, n, n2);
                }
                ++n2;
            }
            ++n;
        }
        return image;
    }

    public boolean isCollision(Mask mask, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = n;
        int n6 = n2;
        int n7 = 0;
        int n8 = 0;
        if (n >= 0) {
            n4 = this.mask.length - n;
        } else {
            n4 = mask.getWidth() - n;
            n5 = 0;
            n7 = -n;
        }
        if (n4 <= 0) {
            return false;
        }
        if (n2 >= 0) {
            n3 = this.mask[0].length - n2;
        } else {
            n3 = mask.getHeight() - n2;
            n6 = 0;
            n8 = -n2;
        }
        if (n3 <= 0) {
            return false;
        }
        int n9 = 0;
        while (n9 < n4) {
            int n10 = 0;
            while (n10 < n3) {
                if (this.mask[n9 + n5][n10 + n6] && mask.mask[n9 + n7][n10 + n8]) {
                    return true;
                }
                ++n10;
            }
            ++n9;
        }
        return false;
    }

    public boolean isCollision(Rectangle rectangle) {
        if (rectangle.x < 0) {
            rectangle.width += rectangle.x;
            rectangle.x = 0;
        }
        if (rectangle.y < 0) {
            rectangle.height += rectangle.y;
            rectangle.y = 0;
        }
        int n = rectangle.x;
        while (n < rectangle.width + rectangle.x && n < this.mask.length + rectangle.x) {
            int n2 = rectangle.y;
            while (n2 < rectangle.height + rectangle.y && n2 < this.mask[0].length + rectangle.y) {
                if (this.mask[n][n2]) {
                    return true;
                }
                ++n2;
            }
            ++n;
        }
        return false;
    }

    public boolean isPoint(int n, int n2) {
        if (n < this.mask.length && n2 < this.mask[0].length) {
            return this.mask[n][n2];
        }
        return false;
    }

    public void setPoint(int n, int n2, boolean bl) {
        if (n < this.mask.length && n2 < this.mask[0].length) {
            this.mask[n][n2] = bl;
        }
    }

    public int getWidth() {
        return this.mask.length;
    }

    public int getHeight() {
        return this.mask[0].length;
    }

    private final class 1
    implements Runnable {
        public void run() {
            System.out.println("making mask");
            int n = Mask.this.imgTemp.getHeight(null);
            int n2 = Mask.this.imgTemp.getWidth(null);
            Mask.this.mask = new boolean[n2][n];
            int[] nArray = new int[n2 * n];
            System.out.println("before grab pixels");
            PixelGrabber pixelGrabber = new PixelGrabber(Mask.this.imgTemp, 0, 0, n2, n, nArray, 0, n);
            while (pixelGrabber.getStatus() != 32 || pixelGrabber.getStatus() != 64 || pixelGrabber.getStatus() != 128) {
                Thread.yield();
            }
            System.out.println("after while loop");
            ColorModel colorModel = ColorModel.getRGBdefault();
            int n3 = Mask.this.invTemp.getRed();
            int n4 = Mask.this.invTemp.getGreen();
            int n5 = Mask.this.invTemp.getBlue();
            System.out.println("before filter");
            int n6 = 0;
            while (n6 < n2) {
                int n7 = 0;
                while (n7 < n) {
                    Mask.this.mask[n6][n7] = colorModel.getRed(nArray[n7 * n + n6]) != n3 && colorModel.getGreen(nArray[n7 * n + n6]) != n4 && colorModel.getBlue(nArray[n7 * n + n6]) != n5;
                    ++n7;
                }
                ++n6;
            }
            System.out.println("mask made");
            Mask.this.imgTemp = null;
            Mask.this.invTemp = null;
        }

        /* synthetic */ 1() {
        }
    }
}

