/*
 * Decompiled with CFR 0.152.
 */
package eam.saen;

import eam.saen.Mask;
import eam.saen.SpriteEngine;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;

public class Sprite {
    protected Image pict = null;
    protected Rectangle bounds;
    protected double widthPercent = -1.0;
    protected double heightPercent = -1.0;
    protected double xLoc = 0.0;
    protected double yLoc = 0.0;
    protected double velx = 0.0;
    protected double vely = 0.0;
    protected boolean visible = false;
    protected boolean active = false;
    protected boolean boundaryContained = true;
    protected SpriteEngine engine = null;
    protected int index = -1;
    protected boolean maskEnabled = false;
    protected Mask mask = null;
    protected boolean collideable = false;
    protected int group = 0;

    public Sprite() {
        this.bounds = new Rectangle(0, 0, 10, 10);
    }

    public Sprite(Image image) {
        if (image != null) {
            this.pict = image;
            this.bounds = new Rectangle(0, 0, this.pict.getWidth(null), this.pict.getHeight(null));
            return;
        }
        this.bounds = new Rectangle(0, 0, 10, 10);
    }

    public void paint(Graphics graphics) {
        if (this.pict != null) {
            graphics.drawImage(this.pict, this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, null);
        }
    }

    public void update() {
        if (this.velx != 0.0 || this.vely != 0.0) {
            Rectangle rectangle = new Rectangle(this.bounds);
            this.xLoc += this.velx;
            this.yLoc += this.vely;
            this.bounds.x = (int)this.xLoc;
            this.bounds.y = (int)this.yLoc;
            this.engine.registerChange(rectangle.union(this.bounds));
        }
    }

    public boolean canCollideWith(Sprite sprite) {
        return false;
    }

    public void collisionWith(Sprite sprite) {
    }

    public void resize(int n, int n2) {
        int n3;
        Rectangle rectangle = new Rectangle(this.bounds);
        if (this.widthPercent > 0.0) {
            n3 = this.bounds.width;
            this.bounds.width = (int)((double)n * this.widthPercent);
            this.xLoc = (double)this.bounds.width * this.xLoc / (double)n3;
            this.bounds.x = (int)this.xLoc;
        }
        if (this.heightPercent > 0.0) {
            n3 = this.bounds.height;
            this.bounds.height = (int)((double)n2 * this.heightPercent);
            this.yLoc = (double)this.bounds.height * this.yLoc / (double)n3;
            this.bounds.y = (int)this.yLoc;
        }
        if (!rectangle.equals(this.bounds) && this.engine != null && this.visible) {
            this.engine.registerChange(rectangle.union(this.bounds));
        }
    }

    public void registerChange(Rectangle rectangle) {
        this.engine.registerChange(rectangle);
    }

    public void suspend() {
        if (this.visible) {
            this.engine.registerChange(this.bounds);
        }
        this.visible = false;
        this.active = false;
    }

    public void resume() {
        if (!this.visible) {
            this.engine.registerChange(this.bounds);
        }
        this.visible = true;
        this.active = true;
    }

    public void remove() {
        this.engine.removeSprite(this);
    }

    public void close() {
    }

    public Image getImage() {
        return this.pict;
    }

    public void setImage(Image image) {
        this.pict = image;
        if (this.engine != null) {
            this.engine.registerChange(this.bounds);
        }
    }

    public Rectangle getBounds() {
        return new Rectangle(this.bounds);
    }

    public void setBounds(Rectangle rectangle) {
        if (rectangle != null) {
            Rectangle rectangle2 = new Rectangle(this.bounds);
            this.xLoc = rectangle.x;
            this.yLoc = rectangle.y;
            this.bounds.x = (int)this.xLoc;
            this.bounds.y = (int)this.yLoc;
            this.bounds.width = rectangle.width;
            this.bounds.height = rectangle.height;
            if (this.engine != null) {
                this.engine.registerChange(rectangle2.union(this.bounds));
            }
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Rectangle rectangle = new Rectangle(this.bounds);
        this.xLoc = n;
        this.yLoc = n2;
        this.bounds.x = (int)this.xLoc;
        this.bounds.y = (int)this.yLoc;
        this.bounds.width = n3;
        this.bounds.height = n4;
        if (this.engine != null) {
            this.engine.registerChange(rectangle.union(this.bounds));
        }
    }

    public void setBounds(double d, double d2, int n, int n2) {
        Rectangle rectangle = new Rectangle(this.bounds);
        this.xLoc = d;
        this.yLoc = d2;
        this.bounds.x = (int)this.xLoc;
        this.bounds.y = (int)this.yLoc;
        this.bounds.width = n;
        this.bounds.height = n2;
        if (this.engine != null) {
            this.engine.registerChange(rectangle.union(this.bounds));
        }
    }

    public void setLocation(int n, int n2) {
        Rectangle rectangle = new Rectangle(this.bounds);
        this.xLoc = n;
        this.yLoc = n2;
        this.bounds.x = (int)this.xLoc;
        this.bounds.y = (int)this.yLoc;
        if (this.engine != null) {
            this.engine.registerChange(rectangle.union(this.bounds));
        }
    }

    public void setLocation(double d, double d2) {
        Rectangle rectangle = new Rectangle(this.bounds);
        this.xLoc = d;
        this.yLoc = d2;
        this.bounds.x = (int)this.xLoc;
        this.bounds.y = (int)this.yLoc;
        if (this.engine != null) {
            this.engine.registerChange(rectangle.union(this.bounds));
        }
    }

    public void setSize(int n, int n2) {
        Rectangle rectangle = new Rectangle(this.bounds);
        this.bounds.width = n;
        this.bounds.height = n2;
        if (this.engine != null) {
            this.engine.registerChange(rectangle.union(this.bounds));
        }
    }

    public int getX() {
        return this.bounds.x;
    }

    public int getY() {
        return this.bounds.y;
    }

    public int getWidth() {
        return this.bounds.width;
    }

    public int getHeight() {
        return this.bounds.height;
    }

    public double getWidthPercent() {
        return this.widthPercent;
    }

    public void setWidthPercent(double d) {
        this.widthPercent = d;
    }

    public double getHeightPercent() {
        return this.heightPercent;
    }

    public void setHeightPercent(double d) {
        this.heightPercent = d;
    }

    public double getVelX() {
        return this.velx;
    }

    public void setVelX(double d) {
        this.velx = d;
    }

    public double getVelY() {
        return this.vely;
    }

    public void setVelY(double d) {
        this.vely = d;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean bl) {
        if (bl != this.visible && this.engine != null) {
            this.engine.registerChange(this.bounds);
        }
        this.visible = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isBoundaryContained() {
        return this.boundaryContained;
    }

    public void setBoundaryContained(boolean bl) {
        this.boundaryContained = bl;
    }

    public boolean isMaskEnabled() {
        return this.maskEnabled;
    }

    public void setMaskEnabled(boolean bl) {
        this.maskEnabled = bl;
    }

    public boolean isCollideable() {
        return this.collideable;
    }

    public void setCollideable(boolean bl) {
        this.collideable = bl;
    }

    public Mask getMask() {
        return this.mask;
    }

    public void setMask(Mask mask) {
        this.mask = mask;
    }

    public int getGroup() {
        return this.group;
    }

    public void setGroup(int n) {
        this.group = n;
    }

    protected void setEngine(SpriteEngine spriteEngine) {
        this.engine = spriteEngine;
    }

    protected void removeEngine() {
        this.engine = null;
    }

    public SpriteEngine getEngine() {
        return this.engine;
    }
}

