/*
 * Decompiled with CFR 0.152.
 */
package eam.saen;

import eam.saen.CustomCollisionChecker;
import eam.saen.GenericSpriteSurface;
import eam.saen.Sprite;
import eam.saen.util.SimpleLinkedList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;

public class SpriteEngine
implements Runnable {
    private Sprite[] sprites;
    private int numSprites = 0;
    private int maxSprites = -1;
    private SimpleLinkedList del = null;
    private Thread animator = null;
    private long delay = 100L;
    private boolean endLoop = false;
    private GenericSpriteSurface screen;
    private boolean doubleBuffer = true;
    private Image buffer = null;
    protected Dimension bufferSize = null;
    protected Sprite bgSprite = null;
    protected Image bgImage = null;
    protected Color bgColor = Color.black;
    private Rectangle clipRegion = null;
    protected int scrollx = 0;
    protected int scrolly = 0;
    private boolean scaleable = false;
    private boolean boundaryCheck = false;
    private Rectangle surfaceBounds = null;
    private boolean checkCollisions = true;
    private boolean maskCC = true;
    private boolean customCC = true;
    public boolean pause = false;

    public SpriteEngine(GenericSpriteSurface genericSpriteSurface) {
        this.screen = genericSpriteSurface;
        this.sprites = new Sprite[50];
    }

    public SpriteEngine(GenericSpriteSurface genericSpriteSurface, int n) {
        this.screen = genericSpriteSurface;
        this.maxSprites = n;
        this.sprites = new Sprite[n];
    }

    public void start() {
        if (this.animator != null) {
            this.animator.resume();
            return;
        }
        this.animator = new Thread(this);
        this.animator.start();
    }

    public void stop() {
        if (this.animator != null) {
            this.endLoop = true;
        }
    }

    public void suspend() {
        if (this.animator != null) {
            this.animator.suspend();
        }
    }

    public void resume() {
        if (this.animator != null) {
            this.animator.resume();
        }
    }

    public void run() {
        if (this.doubleBuffer && this.buffer == null) {
            this.buffer = this.screen.createImage(this.surfaceBounds.width, this.surfaceBounds.height);
        }
        while (!this.endLoop) {
            try {
                if (!this.pause) {
                    this.updateSprites();
                    this.checkCollisions();
                    if (this.del != null) {
                        this.del.goToFirst();
                        int n = 0;
                        while (n < this.del.length()) {
                            this.removeSpriteNow((Sprite)this.del.getCurrent());
                            this.del.goToNext();
                            ++n;
                        }
                        this.del = null;
                    }
                    this.update(this.screen.getSurfaceGraphics());
                }
                try {
                    Thread.sleep(this.delay);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    public void update(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (this.doubleBuffer && this.buffer != null) {
            this.paint(this.buffer.getGraphics());
            graphics.drawImage(this.buffer, 0, 0, this.surfaceBounds.width, this.surfaceBounds.height, null);
            return;
        }
        this.paint(graphics);
    }

    public synchronized void paint(Graphics graphics) {
        if (this.clipRegion == null || graphics == null) {
            return;
        }
        graphics.setClip(this.clipRegion);
        graphics.translate(this.scrollx, this.scrolly);
        if (this.bgSprite != null && this.bgSprite.isVisible()) {
            this.bgSprite.paint(graphics);
        } else if (this.bgImage != null) {
            graphics.drawImage(this.bgImage, 0, 0, this.bgImage.getWidth(null), this.bgImage.getHeight(null), null);
        } else {
            graphics.setColor(this.bgColor);
            graphics.fillRect(this.clipRegion.x, this.clipRegion.y, this.clipRegion.width, this.clipRegion.height);
        }
        int n = 0;
        while (n < this.numSprites) {
            if (this.sprites[n].isVisible() && this.sprites[n].getBounds().intersects(this.clipRegion)) {
                this.sprites[n].paint(graphics);
            }
            ++n;
        }
        this.clipRegion = null;
    }

    public void paintAll(Graphics graphics) {
        this.clipRegion = new Rectangle(this.surfaceBounds);
        this.clipRegion.x += this.scrollx;
        this.clipRegion.y += this.scrolly;
        if (graphics != null) {
            this.update(graphics);
        }
    }

    public synchronized void refresh() {
        if (this.animator != null && this.surfaceBounds != null) {
            this.clipRegion = new Rectangle(this.surfaceBounds);
            return;
        }
        this.paintAll(this.screen.getSurfaceGraphics());
    }

    public void updateSprites() {
        if (this.bgSprite != null && this.bgSprite.isActive()) {
            this.bgSprite.update();
        }
        int n = 0;
        while (n < this.numSprites) {
            if (this.sprites[n].isActive()) {
                this.sprites[n].update();
            }
            ++n;
        }
    }

    public void checkCollisions() {
        int n;
        int n2;
        if (this.boundaryCheck) {
            n2 = 0;
            while (n2 < this.numSprites) {
                if (this.sprites[n2].isBoundaryContained()) {
                    Rectangle rectangle = this.sprites[n2].getBounds();
                    n = 0;
                    if (rectangle.x < this.surfaceBounds.x) {
                        rectangle.x = this.surfaceBounds.x;
                        n = 1;
                    }
                    if (rectangle.y < this.surfaceBounds.y) {
                        rectangle.y = this.surfaceBounds.y;
                        n = 1;
                    }
                    if (rectangle.x + rectangle.width > this.surfaceBounds.x + this.surfaceBounds.width) {
                        rectangle.x = this.surfaceBounds.x + this.surfaceBounds.width - rectangle.width;
                        n = 1;
                    }
                    if (rectangle.y + rectangle.height > this.surfaceBounds.y + this.surfaceBounds.height) {
                        rectangle.y = this.surfaceBounds.y + this.surfaceBounds.height - rectangle.height;
                        n = 1;
                    }
                    if (n != 0) {
                        this.sprites[n2].setBounds(rectangle);
                    }
                }
                ++n2;
            }
        }
        if (!this.checkCollisions) {
            return;
        }
        n2 = 0;
        while (n2 < this.numSprites) {
            int n3 = n2 + 1;
            while (n3 < this.numSprites) {
                if (this.sprites[n2].isCollideable() && this.sprites[n3].isCollideable()) {
                    n = this.sprites[n2].getGroup();
                    int n4 = this.sprites[n3].getGroup();
                    if (!(n == 0 && !this.sprites[n2].canCollideWith(this.sprites[n3]) || n4 == 0 && !this.sprites[n3].canCollideWith(this.sprites[n2]) || n == n4 && n > 0)) {
                        boolean bl = false;
                        Rectangle rectangle = this.sprites[n2].getBounds();
                        Rectangle rectangle2 = this.sprites[n3].getBounds();
                        bl = this.customCC && this.sprites[n2] instanceof CustomCollisionChecker ? ((CustomCollisionChecker)((Object)this.sprites[n2])).isCollisionWith(this.sprites[n3]) : (this.customCC && this.sprites[n3] instanceof CustomCollisionChecker ? ((CustomCollisionChecker)((Object)this.sprites[n3])).isCollisionWith(this.sprites[n2]) : (this.maskCC && this.sprites[n2].isMaskEnabled() ? (this.sprites[n3].isMaskEnabled() ? this.sprites[n2].getMask().isCollision(this.sprites[n3].getMask(), rectangle2.x - rectangle.x, rectangle2.y - rectangle.y) : this.sprites[n2].getMask().isCollision(new Rectangle(rectangle2.x - rectangle.x, rectangle2.y - rectangle.y, rectangle2.width, rectangle2.height))) : (this.maskCC && this.sprites[n3].isMaskEnabled() ? this.sprites[n3].getMask().isCollision(new Rectangle(rectangle.x - rectangle2.x, rectangle.y - rectangle2.y, rectangle.width, rectangle.height)) : rectangle.intersects(rectangle2))));
                        if (bl) {
                            this.sprites[n2].collisionWith(this.sprites[n3]);
                            this.sprites[n3].collisionWith(this.sprites[n2]);
                        }
                    }
                }
                ++n3;
            }
            ++n2;
        }
    }

    public SimpleLinkedList getSpritesIn(Rectangle rectangle) {
        SimpleLinkedList simpleLinkedList = new SimpleLinkedList();
        int n = 0;
        while (n < this.numSprites) {
            if (this.sprites[n].getBounds().intersects(rectangle)) {
                simpleLinkedList.add(this.sprites[n]);
            }
            ++n;
        }
        return simpleLinkedList;
    }

    public void registerChange(Rectangle rectangle) {
        rectangle.x += this.scrollx;
        rectangle.y += this.scrolly;
        if (this.clipRegion == null) {
            this.clipRegion = rectangle;
            return;
        }
        this.clipRegion = this.clipRegion.union(rectangle);
    }

    public void resize(int n, int n2) {
        if (n <= 0) {
            n = 1;
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        if (this.surfaceBounds == null) {
            this.surfaceBounds = new Rectangle(0, 0, n, n2);
        } else {
            this.surfaceBounds.width = n;
            this.surfaceBounds.height = n2;
        }
        int n3 = 0;
        while (n3 < this.numSprites) {
            this.sprites[n3].resize(n, n2);
            ++n3;
        }
        if (this.doubleBuffer) {
            this.buffer = this.screen.createImage(this.surfaceBounds.width, this.surfaceBounds.height);
        }
        this.paintAll(this.screen.getSurfaceGraphics());
    }

    public synchronized void addSprite(Sprite sprite) {
        if (sprite.index != -1) {
            return;
        }
        if (this.maxSprites != -1 && this.numSprites >= this.maxSprites) {
            return;
        }
        if (this.numSprites >= this.sprites.length) {
            Sprite[] spriteArray = new Sprite[this.sprites.length + 25];
            System.arraycopy(this.sprites, 0, spriteArray, 0, this.sprites.length);
            this.sprites = spriteArray;
        }
        this.sprites[this.numSprites] = sprite;
        sprite.index = this.numSprites++;
        sprite.setEngine(this);
        sprite.resize(this.surfaceBounds.width, this.surfaceBounds.height);
        if (sprite.isVisible()) {
            this.registerChange(sprite.getBounds());
        }
    }

    public void removeSprite(Sprite sprite) {
        if (this.del == null) {
            this.del = new SimpleLinkedList();
        }
        this.del.add(sprite);
    }

    protected synchronized void removeSpriteNow(Sprite sprite) {
        if (sprite.index == -1 || sprite.index >= this.numSprites) {
            return;
        }
        if (sprite.isVisible()) {
            this.registerChange(sprite.getBounds());
        }
        sprite.removeEngine();
        if (sprite.index == this.numSprites - 1) {
            this.sprites[sprite.index] = null;
            sprite.index = -1;
            --this.numSprites;
        } else {
            this.sprites[sprite.index] = this.sprites[--this.numSprites];
            this.sprites[sprite.index].index = sprite.index;
            sprite.index = -1;
        }
        sprite.close();
    }

    public synchronized void replaceSprite(Sprite sprite, Sprite sprite2) {
        if (sprite.index == -1 || sprite.index >= this.numSprites || sprite2.index != -1) {
            return;
        }
        if (sprite.isVisible()) {
            this.registerChange(sprite.getBounds());
        }
        sprite.removeEngine();
        this.sprites[sprite.index] = sprite2;
        sprite2.index = sprite.index;
        sprite2.setEngine(this);
        sprite2.resize(this.surfaceBounds.width, this.surfaceBounds.height);
        if (sprite2.isVisible()) {
            this.registerChange(sprite2.getBounds());
        }
        sprite.index = -1;
    }

    public synchronized void removeAll() {
        int n = 0;
        while (n < this.numSprites) {
            this.sprites[n].index = -1;
            this.sprites[n].removeEngine();
            this.sprites[n].close();
            this.sprites[n] = null;
            ++n;
        }
        this.numSprites = 0;
        this.refresh();
    }

    public int getFrameRate() {
        return (int)(1000L / this.delay);
    }

    public void setFrameRate(int n) {
        this.delay = 1000 / n;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long l) {
        if (l > 0L) {
            this.delay = l;
        }
    }

    public GenericSpriteSurface getSpriteSurface() {
        return this.screen;
    }

    public void setSpriteSurface(GenericSpriteSurface genericSpriteSurface) {
        this.screen = genericSpriteSurface;
    }

    public boolean isDoubleBuffering() {
        return this.doubleBuffer;
    }

    public void setDoubleBuffering(boolean bl) {
        this.doubleBuffer = bl;
    }

    public Dimension getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(Dimension dimension) {
        this.bufferSize = dimension;
        if (this.doubleBuffer) {
            this.buffer = this.bufferSize == null ? this.screen.createImage(this.surfaceBounds.width, this.surfaceBounds.height) : this.screen.createImage(this.bufferSize.width, this.bufferSize.height);
            this.refresh();
        }
    }

    public Sprite getBackgroundSprite() {
        return this.bgSprite;
    }

    public void setBackgroundSprite(Sprite sprite) {
        this.bgSprite = sprite;
        this.refresh();
    }

    public Image getBackgroundImage() {
        return this.bgImage;
    }

    public void setBackgroundImage(Image image) {
        this.bgImage = image;
        this.refresh();
    }

    public Color getBackgroundColor() {
        return this.bgColor;
    }

    public void setBackgroundColor(Color color) {
        if (color != null) {
            this.bgColor = color;
            this.refresh();
        }
    }

    public Point getScroll() {
        return new Point(this.scrollx, this.scrolly);
    }

    public void setScroll(Point point) {
        this.scrollx = point.x;
        this.scrolly = point.y;
        this.refresh();
    }

    public void setScroll(int n, int n2) {
        this.scrollx = n;
        this.scrolly = n2;
        this.refresh();
    }

    public boolean isBoundaryChecking() {
        return this.boundaryCheck;
    }

    public void setBoundaryChecking(boolean bl) {
        this.boundaryCheck = bl;
    }

    public boolean isCollisionChecking() {
        return this.checkCollisions;
    }

    public void setCollisionChecking(boolean bl) {
        this.checkCollisions = bl;
    }

    public boolean isMaskEnabled() {
        return this.maskCC;
    }

    public void setMaskEnabled(boolean bl) {
        this.maskCC = bl;
    }

    public boolean isCustomCheckingEnabled() {
        return this.customCC;
    }

    public void setCustomCheckingEnabled(boolean bl) {
        this.customCC = bl;
    }
}

