/*
 * Decompiled with CFR 0.152.
 */
package eam.saen.grid;

import eam.saen.Sprite;
import eam.saen.grid.Grid;
import java.awt.Dimension;
import java.awt.Rectangle;

public class GridSprite
extends Sprite {
    protected Grid grid;

    public GridSprite(Grid grid) {
        this.grid = grid;
    }

    public GridSprite(Grid grid, double d, double d2) {
        this.grid = grid;
        this.widthPercent = d;
        this.heightPercent = d2;
        this.sizeToGrid();
    }

    public void resize(int n, int n2) {
        int n3;
        Rectangle rectangle = new Rectangle(this.bounds);
        Dimension dimension = this.grid.getTileSize();
        if (this.widthPercent > 0.0) {
            n3 = this.bounds.width;
            this.bounds.width = (int)((double)dimension.width * this.widthPercent);
            this.xLoc = (double)this.bounds.width * this.xLoc / (double)n3;
            this.bounds.x = (int)this.xLoc;
        }
        if (this.heightPercent > 0.0) {
            n3 = this.bounds.height;
            this.bounds.height = (int)((double)dimension.height * this.heightPercent);
            this.yLoc = (double)this.bounds.height * this.yLoc / (double)n3;
            this.bounds.y = (int)this.yLoc;
        }
        if (!rectangle.equals(this.bounds) && this.engine != null && this.visible) {
            this.engine.registerChange(rectangle.union(this.bounds));
        }
    }

    public void close() {
        this.grid = null;
    }

    public void snapToGrid() {
        Dimension dimension = this.grid.getTileSize();
        int n = (this.bounds.x + dimension.width / 2) / dimension.width;
        int n2 = (this.bounds.y + dimension.height / 2) / dimension.height;
        Rectangle rectangle = this.grid.getTileBounds(n, n2);
        this.bounds.x = rectangle.x;
        this.xLoc = rectangle.x;
        this.bounds.y = rectangle.y;
        this.yLoc = rectangle.y;
    }

    public void sizeToGrid() {
        Dimension dimension = this.grid.getTileSize();
        this.bounds.width = (int)((double)dimension.width * this.widthPercent);
        this.bounds.height = (int)((double)dimension.height * this.heightPercent);
    }

    public void moveTo(int n, int n2) {
        Rectangle rectangle = this.grid.getTileBounds(n, n2);
        this.bounds.x = rectangle.x;
        this.xLoc = rectangle.x;
        this.bounds.y = rectangle.y;
        this.yLoc = rectangle.y;
    }
}

