import java.awt.*;
import java.util.*;
import javax.swing.*;


	
public class Auxin implements Iterable<Point>
{
	private ArrayList<Point> pts = new ArrayList<Point>();
	public int radius;
	
	public Auxin(int radius) {
		this.radius = radius;
	}
	
	public void paint(Graphics2D g) {
		if( pts.size() == 0 )
			return;
		
		for(int i = 0; i < pts.size(); i++) {
			Point p = pts.get(i);
			g.fillOval(p.x - 2, p.y - 2, 4, 4);
		}
		
		g = (Graphics2D)g.create();
		g.setColor( g.getColor().darker() );
		for(int i = 0; i < pts.size(); i++) {
			Point p = pts.get(i);
			g.drawOval(p.x - radius, p.y - radius, radius * 2, radius * 2);
		}
	}
	
	/**
	 * Attempt to add a point.  If it is within the disk of another point, return false.
	 */
	public boolean addPoint(Point p) {
		
		for(Point check : pts) {
			double dx = check.x - p.x;
			double dy = check.y - p.y;
			if( dx*dx + dy*dy <= (radius*2)*(radius*2) /*radius of both auxin*/ )
				return false;
		}
		
		pts.add(p);
		return true;
	}
	
	public int size() {
		return pts.size();
	}
	
	public Iterator<Point> iterator() {
		return pts.iterator();
	}
	
}
