import java.awt.*;
import java.util.*;
import javax.swing.*;
import java.awt.event.*;


	
public class Bounds
{
	private ArrayList<Point> pts = new ArrayList<Point>();
	private boolean grid[][] = null;
	private int startX, startY;
	public boolean fill = true;
	public boolean border = true;
	
	public Bounds() {
		
	}
	
	public void paint(Graphics2D g) {
		if( pts.size() == 0 )
			return;
		
		if( grid != null && fill ) {
			Graphics2D g2 = (Graphics2D)g.create();
			g2.translate(startX, startY);
			g2.setComposite(AlphaComposite.SrcOver.derive(0.5f));
			
			for(int x = 0; x < grid.length; x++) {
				for(int y = 0; y < grid[0].length; y++) {
					if( grid[x][y] ) {
						g2.drawLine(x, y, x, y);
					}
				}
			}
		}
		
		if( border ) {
			Point first, cur;
			cur = first = pts.get(0);
			
			for(int i = 1; i < pts.size(); i++) {
				Point next = pts.get(i);
				g.drawLine(cur.x, cur.y, next.x, next.y);
				cur = next;
			}
			
			g.drawLine(cur.x, cur.y, first.x, first.y);
		}
	}
	
	public boolean contains(Point p) {
		return contains(p.x, p.y);
	}
	
	public boolean contains(int x, int y) {
		if( pts.size() == 0 || grid == null )
			return false;	//no shape yet
		
		x -= startX;
		y -= startY;
		
		if( x < 0 || x >= grid.length || y < 0 || y >= grid[0].length )
			return false;	//out of bounds for sure
		
		return grid[x][y];
	}
	
	public Dimension getSize() {
		return grid != null? new Dimension(grid.length, grid[0].length) : new Dimension(0,0);
	}
	
	public Point getOffset() {
		return new Point(startX, startY);
	}
	
	public boolean isFilled() {
		return grid != null;
	}
	
	public void addPoint(Point p) {
		pts.add(p);
	}
	
	public void rasterize() {
		try{
			//Determine rectangle bounds
			int lowX = -1, highX = -1, lowY = -1, highY = -1;
			for(Point p : pts) {
				if( lowX == -1 || p.x < lowX )
					lowX = p.x;
				if( highX == -1 || p.x > highX )
					highX = p.x;
				if( lowY == -1 || p.y < lowY )
					lowY = p.y;
				if( highY == -1 || p.y > highY )
					highY = p.y;
			}
			grid = new boolean[highX - lowX + 1][highY - lowY + 1];
			startX = lowX;
			startY = lowY;
			//System.out.println("Ranges "+lowX+"-"+highX+", "+lowY+"-"+highY);
			
			//Add the outline
			Point first, cur;
			cur = first = pts.get(0);
			for(int i = 1; i < pts.size(); i++) {
				Point next = pts.get(i);
				addLine(cur.x, cur.y, next.x, next.y);
				cur = next;
			}
			addLine(cur.x, cur.y, first.x, first.y);
			//printGrid();
				
			//Fill from the center
			fill(grid.length / 2, grid[0].length / 2);
			//printGrid();
			
		}catch(Exception e) {
			e.printStackTrace();
			printGrid();
		}
	}
	
	private void printGrid() {
		if( grid == null )
			System.out.println("Grid = null");
		else {
			System.out.println("Grid "+grid.length+"x"+grid[0].length);
			for(int i = 0; i < grid[0].length; i++) {
				for(int j = 0; j < grid.length; j++) {
					if(grid[j][i])
						System.out.print("#");
					else
						System.out.print(".");
				}
				System.out.println();
			}
		}
	}
	
	private void addLine(int x1, int y1, int x2, int y2) {
		x1 -= startX;
		x2 -= startX;
		y1 -= startY;
		y2 -= startY;
		
		//make sure the endpoints are marked
		grid[x1][y1] = true;
		grid[x2][y2] = true;
		
		double dx = x2 - x1;	//-5
		double dy = y2 - y1;	//10
		
		if( dx != 0 ) {
			double d = dy/dx;	//-2
			
			if( Math.abs(d) > 1.0 ) {
				//A step in X would skip some pixels in y, so let's step by Y
				
				dx /= dy;		//-0.5
				if( dy > 0 ) {
					double x = x1;
					for(int y = y1; y <= y2; y += 1, x += dx) {
						final int ix = (int)(x + 0.5);
						if( ix < 0 || ix >= grid.length) continue;	//bounds check
						
						grid[ix][y] = true;
					}
				} else {
					double x = x1;
					for(int y = y1; y >= y2; y -= 1, x -= dx) {
						final int ix = (int)(x + 0.5);
						if( ix < 0 || ix >= grid.length) continue;	//bounds check
						
						grid[ix][y] = true;
					}
				}
				
			} else {
				dy = d;
				if( dx > 0 ) {
					double y = y1;
					for(int x = x1; x <= x2; x += 1, y += dy) {
						final int iy = (int)(y + 0.5);
						if( iy < 0 || iy >= grid[0].length) continue;	//bounds check
						
						grid[x][iy] = true;
						
						//if( iy + 1 >= grid[0].length) continue;
						//grid[x][iy + 1] = true;
					}
				} else {
					double y = y1;
					for(int x = x1; x >= x2; x -= 1, y -= dy) {
						final int iy = (int)(y + 0.5);
						if( iy < 0 || iy >= grid[0].length) continue;	//bounds check
						
						grid[x][iy] = true;
						
						//if( iy + 1 >= grid[0].length) continue;
						//grid[x][iy + 1] = true;
					}
				}
			}
			
		} else if( dy > 0 ) {
			for(int y = y1; y <= y2; y += 1) {
				grid[x1][y] = true;
			}
		} else if( dy < 0 ) {
			for(int y = y1; y >= y2; y -= 1) {
				grid[x1][y] = true;
			}
		}

	}
	
	private void fill(int x, int y) {
		Stack<Point> fill = new Stack<Point>();
		fill.push(new Point(x,y));
		
		while( fill.size() > 0 ) {
			Point p = fill.pop();
			
			if( p.x < 0 || p.x >= grid.length || p.y < 0 || p.y >= grid[0].length )
				continue;	//out of bounds
			if( grid[p.x][p.y] )
				continue;	//already filled
			
			grid[p.x][p.y] = true;
			fill.push(new Point(p.x + 1, p.y));
			fill.push(new Point(p.x - 1, p.y));
			fill.push(new Point(p.x, p.y + 1));
			fill.push(new Point(p.x, p.y - 1));
		}
	}
	
	public void scale(Point from, double factor) {
		if( pts.size() == 0 )
			return;
		
		//Move every point away from the centroid by a factor
		for(Point p : pts) {
			double dx = from.x - p.x;
			double dy = from.y - p.y;
			
			dx *= factor;
			dy *= factor;
			
			p.x = (int)(from.x - dx);
			p.y = (int)(from.y - dy);
		}
		
		//Update the fill
		rasterize();
	}
	
}
